/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.addons.mqtt.ui;

import org.eclipse.apogy.addons.mqtt.MQTTBrokerConnectionInfo;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.resource.FontDescriptor;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PasswordDialog
extends Dialog {
    private static final Logger Logger = LoggerFactory.getLogger(PasswordDialog.class);
    private MQTTBrokerConnectionInfo mqttBrokerConnectionInfo;
    private Text passwordText;
    private String password;

    public PasswordDialog(Shell parentShell) {
        super(parentShell);
    }

    public PasswordDialog(Shell parentShell, MQTTBrokerConnectionInfo mqttBrokerConnectionInfo) {
        this(parentShell);
        this.mqttBrokerConnectionInfo = mqttBrokerConnectionInfo;
    }

    public String getPassword() {
        return this.password;
    }

    protected Control createDialogArea(Composite parent) {
        Composite container = (Composite)super.createDialogArea(parent);
        container.setLayout((Layout)new GridLayout(3, false));
        Label instructionText = new Label(container, 0);
        instructionText.setText("MQTT Connection : " + this.mqttBrokerConnectionInfo.getName());
        instructionText.setLayoutData((Object)new GridData(4, 128, true, false, 3, 1));
        FontDescriptor boldDescriptor = FontDescriptor.createFrom((Font)instructionText.getFont()).setStyle(1);
        boldDescriptor.setHeight(18);
        Font boldFont = boldDescriptor.createFont((Device)instructionText.getDisplay());
        instructionText.setFont(boldFont);
        Label userLabel = new Label(container, 0);
        userLabel.setText("User Name : ");
        Text userNameText = new Text(container, 12);
        userNameText.setLayoutData((Object)new GridData(4, 128, true, false, 2, 1));
        userNameText.setEnabled(false);
        if (this.mqttBrokerConnectionInfo.getEffectiveUserName() != null) {
            userNameText.setText(this.mqttBrokerConnectionInfo.getUserName());
        }
        Label brokerLabel = new Label(container, 0);
        brokerLabel.setText("Broker URL : ");
        Text brokerURLText = new Text(container, 12);
        brokerURLText.setLayoutData((Object)new GridData(4, 128, true, false, 2, 1));
        brokerURLText.setEnabled(false);
        if (this.mqttBrokerConnectionInfo.getBrokerHostName() != null) {
            brokerURLText.setText(this.mqttBrokerConnectionInfo.getBrokerHostName());
        }
        Label label = new Label(container, 0);
        label.setText("Password:");
        this.passwordText = new Text(container, 2052);
        this.passwordText.setEchoChar('*');
        this.passwordText.setToolTipText("Please enter the password for user named <" + this.mqttBrokerConnectionInfo.getEffectiveUserName() + "> for the broker at URL <" + this.mqttBrokerConnectionInfo.getBrokerHostName() + ">.");
        GridData texGridData = new GridData(4, 128, false, false, 1, 1);
        texGridData.widthHint = 250;
        texGridData.minimumWidth = 250;
        this.passwordText.setLayoutData((Object)texGridData);
        final Button showButton = new Button(container, 32);
        showButton.setText("Show");
        showButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent event) {
                if (showButton.getSelection()) {
                    PasswordDialog.this.passwordText.setEchoChar('\u0000');
                } else {
                    PasswordDialog.this.passwordText.setEchoChar('*');
                }
            }

            public void widgetDefaultSelected(SelectionEvent arg0) {
            }
        });
        return container;
    }

    protected void okPressed() {
        this.password = this.passwordText.getText();
        super.okPressed();
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText("Password for Broker Connection named <" + this.mqttBrokerConnectionInfo.getName() + ">.");
    }

    protected Point getInitialSize() {
        return new Point(750, 300);
    }
}

