/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.addons.mqtt;

import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import org.eclipse.apogy.addons.mqtt.MQTTBrokerConnectionInfoRegistry;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.xmi.impl.XMIResourceFactoryImpl;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Activator
extends AbstractUIPlugin {
    public static final String MQTTBrokerConnectionInfoRegistryFileName = "MQTTBrokerConnectionInfoRegistry.xml";
    private static final Logger Logger = LoggerFactory.getLogger(Activator.class);

    public void start(BundleContext arg0) throws Exception {
        this.loadMQTTBrokerConnectionInfo();
    }

    public void stop(BundleContext arg0) throws Exception {
        this.saveMQTTBrokerConnectionInfo();
    }

    private void loadMQTTBrokerConnectionInfo() {
        Bundle bundle = FrameworkUtil.getBundle(((Object)((Object)this)).getClass());
        IPath path = Platform.getStateLocation((Bundle)bundle);
        path = path.addTrailingSeparator().append(MQTTBrokerConnectionInfoRegistryFileName);
        try {
            File f = path.toFile();
            if (f.exists()) {
                Resource.Factory.Registry reg = Resource.Factory.Registry.INSTANCE;
                Map m = reg.getExtensionToFactoryMap();
                m.put("xml", new XMIResourceFactoryImpl());
                ResourceSetImpl resourceSet = new ResourceSetImpl();
                Resource resource = resourceSet.getResource(URI.createURI((String)("file://" + path.toOSString())), true);
                MQTTBrokerConnectionInfoRegistry registry = (MQTTBrokerConnectionInfoRegistry)resource.getContents().get(0);
                MQTTBrokerConnectionInfoRegistry.INSTANCE.getBrokersConnnectionInfo().addAll(registry.getBrokersConnnectionInfo());
                Logger.info("Loaded <" + registry.getBrokersConnnectionInfo().size() + "> MQTTBrokerConnectionInfo from registry.");
            } else {
                Logger.info("MQTTBrokerConnectionInfoRegistry file {} does not exist, creating an empty one.", (Object)path.toOSString());
                this.saveMQTTBrokerConnectionInfo();
            }
        }
        catch (Exception e) {
            Logger.error("Failed to load MQTTBrokerConnectionInfoRegistry from file <" + path.toOSString() + "> !", (Throwable)e);
        }
    }

    private void saveMQTTBrokerConnectionInfo() {
        Bundle bundle = FrameworkUtil.getBundle(((Object)((Object)this)).getClass());
        IPath path = Platform.getStateLocation((Bundle)bundle);
        path = path.addTrailingSeparator().append(MQTTBrokerConnectionInfoRegistryFileName);
        Resource.Factory.Registry reg = Resource.Factory.Registry.INSTANCE;
        Map m = reg.getExtensionToFactoryMap();
        m.put("xml", new XMIResourceFactoryImpl());
        ResourceSetImpl resSet = new ResourceSetImpl();
        Resource resource = resSet.createResource(URI.createURI((String)("file://" + path.toOSString())));
        resource.getContents().add((Object)MQTTBrokerConnectionInfoRegistry.INSTANCE);
        try {
            resource.save(Collections.EMPTY_MAP);
            Logger.info("Saved <" + MQTTBrokerConnectionInfoRegistry.INSTANCE.getBrokersConnnectionInfo().size() + "> MQTTBrokerConnectionInfo from registry to file <" + path.toOSString() + ">.");
        }
        catch (IOException e) {
            Logger.error("Failed to save MQTTBrokerConnectionInfoRegistry to file <" + path.toOSString() + "> !", (Throwable)e);
        }
    }
}

