/*
 * Decompiled with CFR 0.152.
 */
package sensor_msgs;

import java.nio.ByteOrder;
import org.eclipse.emf.ecore.xml.type.internal.DataValue;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.buffer.ChannelBuffers;
import org.json.JSONObject;
import org.ros.internal.message.RawMessage;
import sensor_msgs.CompressedImage;
import std_msgs.Header;
import std_msgs.HeaderMQTT;

public class CompressedImageMQTT
implements CompressedImage {
    private Header header;
    private String format;
    private ChannelBuffer data;

    public CompressedImageMQTT() {
    }

    public CompressedImageMQTT(JSONObject jsonObject) throws Exception {
        this.fromJSONObject(jsonObject);
    }

    public CompressedImageMQTT(String jsonString) throws Exception {
        this.parseJSONString(jsonString);
    }

    public RawMessage toRawMessage() {
        return null;
    }

    public Header getHeader() {
        return this.header;
    }

    public void setHeader(Header value) {
        this.header = value;
    }

    public String getFormat() {
        return this.format;
    }

    public void setFormat(String value) {
        this.format = value;
    }

    public ChannelBuffer getData() {
        return this.data;
    }

    public void setData(ChannelBuffer value) {
        this.data = value;
    }

    public JSONObject toJSONObject() throws Exception {
        return CompressedImageMQTT.toJSONObject(this);
    }

    public static JSONObject toJSONObject(CompressedImage compressedImage) throws Exception {
        JSONObject jsonObject = new JSONObject();
        if (compressedImage.getHeader() != null) {
            jsonObject.put("header", (Object)HeaderMQTT.toJSONObject(compressedImage.getHeader()));
        }
        jsonObject.put("format", (Object)compressedImage.getFormat());
        String imageDataString = DataValue.Base64.encode((byte[])compressedImage.getData().array());
        jsonObject.put("data", (Object)imageDataString);
        return jsonObject;
    }

    protected void parseJSONString(String jsonString) throws Exception {
        JSONObject jsonObject = new JSONObject(jsonString);
        this.fromJSONObject(jsonObject);
    }

    protected void fromJSONObject(JSONObject jsonObject) throws Exception {
        if (jsonObject.has("header")) {
            this.setHeader(new HeaderMQTT(jsonObject.getJSONObject("header")));
        }
        this.setFormat(jsonObject.getString("format"));
        String d = jsonObject.getString("data");
        byte[] imageData = DataValue.Base64.decode((String)d);
        ChannelBuffer buffer = ChannelBuffers.buffer((ByteOrder)ChannelBuffers.LITTLE_ENDIAN, (int)imageData.length);
        buffer.writeBytes(imageData);
        this.setData(buffer);
    }
}

