/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.addons.mqtt.ros.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.TimeoutException;
import org.eclipse.apogy.addons.mqtt.ApogyAddonsMQTTFacade;
import org.eclipse.apogy.addons.mqtt.ApogyAddonsMQTTPackage;
import org.eclipse.apogy.addons.mqtt.MQTTClientState;
import org.eclipse.apogy.addons.mqtt.MQTTTopic;
import org.eclipse.apogy.addons.mqtt.QualityOfService;
import org.eclipse.apogy.addons.mqtt.callbacks.CompositeElementCallback;
import org.eclipse.apogy.addons.mqtt.callbacks.CompositeMqttCallback;
import org.eclipse.apogy.addons.mqtt.ros.ApogyAddonsMQTTROSFacade;
import org.eclipse.apogy.addons.mqtt.ros.ApogyAddonsMQTTROSPackage;
import org.eclipse.apogy.addons.mqtt.ros.MQTTROSArbitratorClientProfile;
import org.eclipse.apogy.addons.mqtt.ros.MQTTROSArbitratorServerRegistry;
import org.eclipse.apogy.addons.mqtt.ros.MQTTROSArbitratorServiceID;
import org.eclipse.apogy.addons.mqtt.ros.MQTTROSServiceAnswer;
import org.eclipse.apogy.addons.mqtt.ros.MQTTROSServiceCall;
import org.eclipse.apogy.addons.mqtt.ros.impl.MQTTROSArbitratorServerImpl;
import org.eclipse.apogy.common.emf.ApogyCommonTransactionFacade;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.paho.client.mqttv3.IMqttDeliveryToken;
import org.eclipse.paho.client.mqttv3.MqttCallback;
import org.eclipse.paho.client.mqttv3.MqttConnectOptions;
import org.eclipse.paho.client.mqttv3.MqttMessage;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MQTTROSArbitratorServerCustomImpl
extends MQTTROSArbitratorServerImpl {
    private static final Logger Logger = LoggerFactory.getLogger(MQTTROSArbitratorServerCustomImpl.class);
    private static int TOKEN_HISTORY_SIZE = 1024;
    private Map<String, List<Long>> userToUsedTokenList = new HashMap<String, List<Long>>();
    private MqttCallback clientsCallback;
    private boolean debug = false;

    @Override
    public Map<MQTTROSArbitratorClientProfile, List<MQTTROSArbitratorServiceID>> getClientIDToServicesMap() {
        Map<MQTTROSArbitratorClientProfile, List<MQTTROSArbitratorServiceID>> tmp = super.getClientIDToServicesMap();
        if (tmp == null) {
            tmp = new HashMap<MQTTROSArbitratorClientProfile, List<MQTTROSArbitratorServiceID>>();
            for (MQTTROSArbitratorClientProfile user : this.getUsers()) {
                tmp.put(user, new ArrayList<MQTTROSArbitratorServiceID>((Collection<MQTTROSArbitratorServiceID>)user.getGrantedServices()));
            }
            ApogyCommonTransactionFacade.INSTANCE.basicSet((EObject)this, (EStructuralFeature)ApogyAddonsMQTTROSPackage.Literals.MQTTROS_ARBITRATOR_SERVER__CLIENT_ID_TO_SERVICES_MAP, tmp, true);
        }
        return tmp;
    }

    @Override
    public Map<MQTTROSArbitratorServiceID, MQTTROSArbitratorClientProfile> getServicesToExclusiveUserIDMap() {
        Map<MQTTROSArbitratorServiceID, MQTTROSArbitratorClientProfile> tmp = super.getServicesToExclusiveUserIDMap();
        if (tmp == null) {
            tmp = new HashMap<MQTTROSArbitratorServiceID, MQTTROSArbitratorClientProfile>();
            for (MQTTROSArbitratorClientProfile user : this.getUsers()) {
                for (MQTTROSArbitratorServiceID service : user.getExclusivelyGrantedServices()) {
                    tmp.put(service, user);
                }
            }
            ApogyCommonTransactionFacade.INSTANCE.basicSet((EObject)this, (EStructuralFeature)ApogyAddonsMQTTROSPackage.Literals.MQTTROS_ARBITRATOR_SERVER__SERVICES_TO_EXCLUSIVE_USER_ID_MAP, tmp, true);
        }
        return tmp;
    }

    @Override
    public void start() {
        Logger.info("Starting MQTTROSArbitratorServer ...");
        Logger.info("Starting Client Side MQTTClient ...");
        if (this.getClientSide().getConnectionOptions() != null) {
            MqttConnectOptions options = this.getClientSide().getConnectionOptions().asMqttConnectOptions();
            if (this.debug) {
                System.out.println("Connection Options ------------------------------------------");
                System.out.println("Connection Type     : " + this.getClientSide().getConnectionOptions().getClass().getSimpleName());
                System.out.println("User                : " + options.getUserName());
                System.out.println("Password            : " + new String(options.getPassword()));
                System.out.println("Connection Timeout  : " + options.getConnectionTimeout());
                System.out.println("Clean Session       : " + options.isCleanSession());
                System.out.println("Auto Reconnect      : " + options.isAutomaticReconnect());
                System.out.println("-------------------------------------------------------------");
            }
        }
        ApogyCommonTransactionFacade.INSTANCE.basicSet((EObject)this.getClientSide(), (EStructuralFeature)ApogyAddonsMQTTPackage.Literals.MQTT_CLIENT__VERBOSE, (Object)true, true);
        this.getClientSide().start();
        try {
            Thread.sleep(5000L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        int waitCount = 0;
        while (this.getClientSide().getState() != MQTTClientState.CONNECTED && this.getClientSide().getState() != MQTTClientState.FAILED) {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            Logger.info("Client Side State < " + this.getClientSide().getState() + "> connecting <" + ++waitCount + "> ...");
        }
        if (this.getClientSide().getState() == MQTTClientState.FAILED) {
            throw new RuntimeException("Client Side MQTT client failed to connect to broker !");
        }
        List<MQTTTopic> clientSideTopics = this.createClientTopics();
        for (MQTTTopic topic : clientSideTopics) {
            try {
                Logger.info("Subscribing to Client Side topic <" + topic.getTopicName() + ">...");
                this.getClientSide().subscribe(topic);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        Logger.info("Starting ROS Side MQTTClient ...");
        this.getRosSide().start();
        try {
            Thread.sleep(5000L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        waitCount = 0;
        while (this.getRosSide().getState() != MQTTClientState.CONNECTED && this.getRosSide().getState() != MQTTClientState.FAILED) {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            Logger.info("Client Side State < " + this.getRosSide().getState() + "> connecting <" + ++waitCount + "> ...");
        }
        if (this.getRosSide().getState() == MQTTClientState.FAILED) {
            throw new RuntimeException("ROS Side MQTT client failed to connect to broker !");
        }
        List<MQTTTopic> rosSideTopics = this.createROSSideTopics();
        for (MQTTTopic topic : rosSideTopics) {
            try {
                Logger.info("Subscribing to ROS Side topic <" + topic.getTopicName() + ">...");
                this.getRosSide().subscribe(topic);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (!MQTTROSArbitratorServerRegistry.INSTANCE.getServerList().contains((Object)this)) {
            MQTTROSArbitratorServerRegistry.INSTANCE.getServerList().add((Object)this);
        }
        Logger.info("MQTTROSArbitratorServer running.");
    }

    @Override
    public void stop() {
        if (this.getClientSide() != null) {
            this.getClientSide().stop();
        }
        if (this.getRosSide() != null) {
            this.getRosSide().stop();
        }
        MQTTROSArbitratorServerRegistry.INSTANCE.getServerList().remove((Object)this);
    }

    @Override
    public MQTTROSArbitratorClientProfile findExclusiveUser(MQTTROSArbitratorServiceID service) {
        return this.getServicesToExclusiveUserIDMap().get(service);
    }

    @Override
    public synchronized boolean grantControl(MQTTROSArbitratorClientProfile user, MQTTROSArbitratorServiceID service) {
        List<MQTTROSArbitratorServiceID> userServices;
        if (this.findExclusiveUser(service) != null) {
            Logger.info("Cannot grant user <" + user.getUserID() + "> control over service <" + service.getServiceName() + "> since it is exclusivelly granted to another user !");
            return false;
        }
        if (!this.getUsers().contains((Object)user)) {
            ApogyCommonTransactionFacade.INSTANCE.basicAdd((EObject)this, (EStructuralFeature)ApogyAddonsMQTTROSPackage.Literals.MQTTROS_ARBITRATOR_SERVER__USERS, (Object)user, true);
        }
        if ((userServices = this.getClientIDToServicesMap().get(user)) == null) {
            userServices = new ArrayList<MQTTROSArbitratorServiceID>();
            this.getClientIDToServicesMap().put(user, userServices);
        }
        userServices.add(service);
        ApogyCommonTransactionFacade.INSTANCE.basicAdd((EObject)user, (EStructuralFeature)ApogyAddonsMQTTROSPackage.Literals.MQTTROS_ARBITRATOR_CLIENT_PROFILE__GRANTED_SERVICES, (Object)service, true);
        Logger.info("Granted user <" + user.getUserID() + "> control over service <" + service.getServiceName() + ">.");
        return true;
    }

    @Override
    public synchronized boolean revokeControl(MQTTROSArbitratorClientProfile user, MQTTROSArbitratorServiceID service) {
        List<MQTTROSArbitratorServiceID> services = this.getClientIDToServicesMap().get(user);
        if (services == null) {
            return false;
        }
        if (services.contains(service)) {
            services.remove(service);
            ApogyCommonTransactionFacade.INSTANCE.basicRemove((EObject)user, (EStructuralFeature)ApogyAddonsMQTTROSPackage.Literals.MQTTROS_ARBITRATOR_CLIENT_PROFILE__GRANTED_SERVICES, (Object)service, true);
            Logger.info("Revoke service <" + service.getServiceName() + "> from user <" + user.getUserID() + "> completed.");
            return true;
        }
        Logger.warn("Revoking service <" + service.getServiceName() + "> from user <" + user.getUserID() + "> failed !");
        return false;
    }

    @Override
    public synchronized boolean grantExclusiveControl(MQTTROSArbitratorClientProfile user, MQTTROSArbitratorServiceID service) {
        if (this.findExclusiveUser(service) != null) {
            Logger.error("Cannot grant user <" + user.getUserID() + "> exclusive control over service <" + service.getServiceName() + ">, it is already granted to another user !");
            return false;
        }
        if (!this.getUsers().contains((Object)user)) {
            ApogyCommonTransactionFacade.INSTANCE.basicAdd((EObject)this, (EStructuralFeature)ApogyAddonsMQTTROSPackage.Literals.MQTTROS_ARBITRATOR_SERVER__USERS, (Object)user, true);
        }
        this.getServicesToExclusiveUserIDMap().put(service, user);
        ApogyCommonTransactionFacade.INSTANCE.basicAdd((EObject)user, (EStructuralFeature)ApogyAddonsMQTTROSPackage.Literals.MQTTROS_ARBITRATOR_CLIENT_PROFILE__EXCLUSIVELY_GRANTED_SERVICES, (Object)service, true);
        for (MQTTROSArbitratorClientProfile otherUser : this.getClientIDToServicesMap().keySet()) {
            this.revokeControl(otherUser, service);
        }
        Logger.info("Granted user <" + user.getUserID() + "> exclusive control over service <" + service.getServiceName() + ">.");
        return true;
    }

    @Override
    public synchronized boolean revokeExclusiveControl(MQTTROSArbitratorClientProfile user, MQTTROSArbitratorServiceID service) {
        if (this.findExclusiveUser(service) == null) {
            return false;
        }
        this.getServicesToExclusiveUserIDMap().remove(service);
        ApogyCommonTransactionFacade.INSTANCE.basicRemove((EObject)user, (EStructuralFeature)ApogyAddonsMQTTROSPackage.Literals.MQTTROS_ARBITRATOR_CLIENT_PROFILE__EXCLUSIVELY_GRANTED_SERVICES, (Object)service, true);
        Logger.info("Revoke service <" + service.getServiceName() + "> from user <" + user.getUserID() + ">.");
        return true;
    }

    @Override
    public synchronized boolean canControl(MQTTROSArbitratorClientProfile user, MQTTROSArbitratorServiceID service) {
        boolean canControl = false;
        canControl = user.getGrantedServices().contains((Object)service);
        if (!canControl) {
            canControl = user.getExclusivelyGrantedServices().contains((Object)service);
        }
        return canControl;
    }

    @Override
    public synchronized JSONObject dispatch(MQTTROSServiceCall serviceCall) throws Exception {
        MQTTROSArbitratorClientProfile user = this.getUserProfileByUserId(serviceCall.getUserID());
        ApogyCommonTransactionFacade.INSTANCE.basicAdd((EObject)this, (EStructuralFeature)ApogyAddonsMQTTROSPackage.Literals.MQTTROS_ARBITRATOR_SERVER__CALLS, (Object)serviceCall, true);
        if (!this.serviceExist(serviceCall.getServiceName())) {
            String msg = "Service <" + serviceCall.getServiceName() + "> is not in the list of managed services !";
            MQTTROSServiceAnswer response = ApogyAddonsMQTTROSFacade.INSTANCE.createMQTTROSServiceAnswer(serviceCall);
            response.setException(new Exception(msg));
            serviceCall.setResponse(response);
            Logger.error(msg);
            try {
                MQTTTopic responseTopic = this.getClientResponseTopic(serviceCall);
                this.getClientSide().publish(responseTopic, ApogyAddonsMQTTROSFacade.INSTANCE.convertToJSON(response).toString());
            }
            catch (Throwable e) {
                Logger.error("Could not respond to user <" + user.getUserID() + "> !", e);
            }
            throw new Exception(msg);
        }
        Logger.info("Dispatching service request on service <" + serviceCall.getServiceName() + "> by user <" + user.getUserID() + "> with token <" + serviceCall.getToken() + ">...");
        MQTTROSArbitratorServiceID service = this.getMQTTROSArbitratorServiceIDByName(serviceCall.getServiceName());
        if (this.validateMQTTROSServiceCall(serviceCall, user, service)) {
            String msg = "Service call <" + serviceCall.getServiceName() + "> by <" + serviceCall.getUserID() + "> validated";
            Logger.info(msg);
            MQTTTopic requestTopic = this.getROSRequestTopic(serviceCall);
            MQTTTopic responseTopic = this.getROSResponseTopic(serviceCall);
            ROSCallBack rosCallback = new ROSCallBack((CompositeMqttCallback)responseTopic.getCallBack(), serviceCall);
            Logger.info("Forwarding service call to ROS topic <" + requestTopic.getTopicName() + ">...");
            String rosRequest = new String(serviceCall.getRosRequest().toString());
            Logger.info("REQUEST CONTENT IS : " + serviceCall.getRosRequest().toString());
            this.getRosSide().publish(requestTopic, rosRequest);
            rosCallback.startTimer();
            return null;
        }
        String msg = "User <" + serviceCall.getUserID() + "> does not have execution permission for service <" + serviceCall.getServiceName() + "> !";
        Logger.error(msg);
        MQTTROSServiceAnswer response = ApogyAddonsMQTTROSFacade.INSTANCE.createMQTTROSServiceAnswer(serviceCall);
        response.setException(new Exception(msg));
        serviceCall.setResponse(response);
        try {
            MQTTTopic responseTopic = this.getClientResponseTopic(serviceCall);
            this.getClientSide().publish(responseTopic, ApogyAddonsMQTTROSFacade.INSTANCE.convertToJSON(response).toString());
        }
        catch (Throwable e) {
            Logger.error("Could not respond to user <" + user.getUserID() + "> !", e);
        }
        throw new Exception(msg);
    }

    @Override
    public MQTTROSArbitratorClientProfile getUserProfileByUserId(String userID) {
        MQTTROSArbitratorClientProfile user = null;
        Iterator it = this.getUsers().iterator();
        while (user == null && it.hasNext()) {
            MQTTROSArbitratorClientProfile profile = (MQTTROSArbitratorClientProfile)it.next();
            if (profile.getUserID().compareTo(userID) != 0) continue;
            user = profile;
        }
        return user;
    }

    @Override
    public MQTTROSArbitratorServiceID getMQTTROSArbitratorServiceIDByName(String serviceName) {
        MQTTROSArbitratorServiceID service = null;
        Iterator it = this.getServices().iterator();
        while (service == null && it.hasNext()) {
            MQTTROSArbitratorServiceID s = (MQTTROSArbitratorServiceID)it.next();
            if (s.getServiceName().compareTo(serviceName) != 0) continue;
            service = s;
        }
        return service;
    }

    @Override
    public boolean removeUser(MQTTROSArbitratorClientProfile user) {
        if (this.getUsers().contains((Object)user)) {
            ArrayList<MQTTROSArbitratorServiceID> services = new ArrayList<MQTTROSArbitratorServiceID>((Collection<MQTTROSArbitratorServiceID>)user.getGrantedServices());
            for (MQTTROSArbitratorServiceID service : services) {
                this.revokeControl(user, service);
            }
            ArrayList<MQTTROSArbitratorServiceID> exclusiveServices = new ArrayList<MQTTROSArbitratorServiceID>((Collection<MQTTROSArbitratorServiceID>)user.getExclusivelyGrantedServices());
            for (MQTTROSArbitratorServiceID service : exclusiveServices) {
                this.revokeExclusiveControl(user, service);
            }
            this.userToUsedTokenList.remove(user.getUserID());
            ApogyCommonTransactionFacade.INSTANCE.basicRemove((EObject)this, (EStructuralFeature)ApogyAddonsMQTTROSPackage.Literals.MQTTROS_ARBITRATOR_SERVER__USERS, (Object)user, true);
            Logger.info("Removed user <" + user.getUserID() + "> from the current users list.");
            return true;
        }
        Logger.error("Cannot remove user <" + user.getUserID() + "> since it is not in the current users list !");
        return false;
    }

    @Override
    public void removeAllUsers() {
        ArrayList<MQTTROSArbitratorClientProfile> tmp = new ArrayList<MQTTROSArbitratorClientProfile>((Collection<MQTTROSArbitratorClientProfile>)this.getUsers());
        for (MQTTROSArbitratorClientProfile user : tmp) {
            this.removeUser(user);
        }
    }

    @Override
    public boolean addUser(MQTTROSArbitratorClientProfile user) {
        if (!this.getUsers().contains((Object)user)) {
            ApogyCommonTransactionFacade.INSTANCE.basicAdd((EObject)this, (EStructuralFeature)ApogyAddonsMQTTROSPackage.Literals.MQTTROS_ARBITRATOR_SERVER__USERS, (Object)user, true);
            ArrayList<MQTTROSArbitratorServiceID> services = new ArrayList<MQTTROSArbitratorServiceID>((Collection<MQTTROSArbitratorServiceID>)user.getGrantedServices());
            for (MQTTROSArbitratorServiceID service : services) {
                this.grantControl(user, service);
            }
            ArrayList<MQTTROSArbitratorServiceID> exclusiveServices = new ArrayList<MQTTROSArbitratorServiceID>((Collection<MQTTROSArbitratorServiceID>)user.getExclusivelyGrantedServices());
            for (MQTTROSArbitratorServiceID service : exclusiveServices) {
                this.grantExclusiveControl(user, service);
            }
            Logger.info("Added user <" + user.getUserID() + "> to the current users list.");
            return true;
        }
        Logger.error("Cannot add user <" + user.getUserID() + "> since it is already in the current users list !");
        return false;
    }

    @Override
    public void addUsers(List<MQTTROSArbitratorClientProfile> userList) {
        for (MQTTROSArbitratorClientProfile user : userList) {
            this.addUser(user);
        }
    }

    @Override
    public void clearUserTokenHistory(MQTTROSArbitratorClientProfile user) {
        if (user != null) {
            try {
                this.userToUsedTokenList.remove(user.getUserID());
                Logger.info("Cleared user <" + user.getUserID() + "> tokens list.");
            }
            catch (Exception e) {
                Logger.error("Failed to clear user <" + user.getUserID() + "> tokens list.", (Throwable)e);
            }
        }
    }

    private boolean serviceExist(String serviceName) {
        boolean result = false;
        if (serviceName != null) {
            Iterator serviceIterator = this.getServices().iterator();
            while (serviceIterator.hasNext() && !result) {
                if (serviceName.compareTo(((MQTTROSArbitratorServiceID)serviceIterator.next()).getServiceName()) != 0) continue;
                result = true;
            }
        }
        return result;
    }

    private List<MQTTTopic> createClientTopics() {
        ArrayList<MQTTTopic> topics = new ArrayList<MQTTTopic>();
        for (MQTTROSArbitratorServiceID topicName : this.getServices()) {
            try {
                String clientRequestTopicName = ApogyAddonsMQTTROSFacade.INSTANCE.getMQTTROSArbitratorServerRequestTopicName(topicName.getServiceName());
                MQTTTopic clientRequestTopic = ApogyAddonsMQTTFacade.INSTANCE.createMQTTTopic(clientRequestTopicName, QualityOfService.QOS_1, this.getClientsMQTTCallback(), -1L);
                topics.add(clientRequestTopic);
                String clientResponseTopicName = ApogyAddonsMQTTROSFacade.INSTANCE.getMQTTROSArbitratorServerResponseTopicName(topicName.getServiceName());
                MQTTTopic clientResponseTopic = ApogyAddonsMQTTFacade.INSTANCE.createMQTTTopic(clientResponseTopicName, QualityOfService.QOS_1, null, -1L);
                topics.add(clientResponseTopic);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return topics;
    }

    private List<MQTTTopic> createROSSideTopics() {
        ArrayList<MQTTTopic> topics = new ArrayList<MQTTTopic>();
        for (MQTTROSArbitratorServiceID service : this.getServices()) {
            try {
                String rosRequestTopicName = ApogyAddonsMQTTROSFacade.INSTANCE.getROSRequestTopicName(service.getServiceName());
                MQTTTopic rosRequestTopic = ApogyAddonsMQTTFacade.INSTANCE.createMQTTTopic(rosRequestTopicName, QualityOfService.QOS_1, null, -1L);
                topics.add(rosRequestTopic);
                String rosResponseTopicName = ApogyAddonsMQTTROSFacade.INSTANCE.getROSResponseTopicName(service.getServiceName());
                MQTTTopic rosResponseTopic = ApogyAddonsMQTTFacade.INSTANCE.createMQTTTopic(rosResponseTopicName, QualityOfService.QOS_1, (MqttCallback)new CompositeMqttCallback(), -1L);
                topics.add(rosResponseTopic);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return topics;
    }

    private MqttCallback getClientsMQTTCallback() {
        if (this.clientsCallback == null) {
            this.clientsCallback = new MqttCallback(){

                public void connectionLost(Throwable arg0) {
                }

                public void deliveryComplete(IMqttDeliveryToken arg0) {
                }

                public void messageArrived(String arg0, MqttMessage msg) throws Exception {
                    MQTTROSServiceCall serviceCall = ApogyAddonsMQTTROSFacade.INSTANCE.convertToJMQTTROSServiceCall(new JSONObject(new String(msg.getPayload())));
                    MQTTROSArbitratorServerCustomImpl.this.dispatch(serviceCall);
                }
            };
        }
        return this.clientsCallback;
    }

    private boolean validateCallToken(MQTTROSArbitratorClientProfile user, MQTTROSServiceCall serviceCall) {
        long now = System.currentTimeMillis();
        if (user == null) {
            Logger.warn("User <" + serviceCall.getUserID() + "> is not registered!");
            return false;
        }
        List<Long> tokens = this.userToUsedTokenList.get(serviceCall.getUserID());
        if (tokens != null && tokens.contains(serviceCall.getToken())) {
            Logger.warn("Token <" + serviceCall.getToken() + "> previously used by user <" + user.getUserID() + "> !");
            return false;
        }
        Logger.info("Adding token <" + Long.toString(serviceCall.getToken()) + "> for user <" + user.getUserID() + ">");
        this.updateUserToken(user, serviceCall);
        if (this.getServiceCallTimeAndLocalTimeWindow() > 0L) {
            long callTime = serviceCall.getTime().getTime();
            long timeDifference = now - callTime;
            if (Math.abs(timeDifference) > this.getServiceCallTimeAndLocalTimeWindow()) {
                Logger.warn("Service Call Time is oudated. Time difference is <" + Long.toString(timeDifference) + "> millisecond !");
                return false;
            }
            Logger.debug("Service Call Time vis Local Server Time difference is <" + Long.toString(timeDifference) + "> millisecond.");
        }
        return true;
    }

    private boolean validateMQTTROSServiceCall(MQTTROSServiceCall serviceCall, MQTTROSArbitratorClientProfile user, MQTTROSArbitratorServiceID service) {
        if (!this.canControl(user, service)) {
            Logger.warn("User <" + serviceCall.getUserID() + "> does has not been granted control for service <" + serviceCall.getServiceName() + ">!");
            return false;
        }
        return true;
    }

    private void updateUserToken(MQTTROSArbitratorClientProfile user, MQTTROSServiceCall serviceCall) {
        List<Long> tokens = this.userToUsedTokenList.get(user.getUserID());
        if (tokens == null) {
            tokens = new ArrayList<Long>();
            this.userToUsedTokenList.put(user.getUserID(), tokens);
        }
        tokens.add(serviceCall.getToken());
        while (tokens.size() > TOKEN_HISTORY_SIZE) {
            tokens.remove(0);
        }
    }

    private MQTTTopic getROSRequestTopic(MQTTROSServiceCall serviceCall) {
        MQTTTopic requestTopic = null;
        String clientRequestTopicName = ApogyAddonsMQTTROSFacade.INSTANCE.getROSRequestTopicName(serviceCall.getServiceName());
        Iterator it = this.getRosSide().getSubscribedTopics().iterator();
        while (requestTopic == null && it.hasNext()) {
            MQTTTopic topic = (MQTTTopic)it.next();
            if (topic.getTopicName().compareTo(clientRequestTopicName) != 0) continue;
            requestTopic = topic;
        }
        return requestTopic;
    }

    private MQTTTopic getROSResponseTopic(MQTTROSServiceCall serviceCall) {
        MQTTTopic requestTopic = null;
        String clientRequestTopicName = ApogyAddonsMQTTROSFacade.INSTANCE.getROSResponseTopicName(serviceCall.getServiceName());
        Iterator it = this.getRosSide().getSubscribedTopics().iterator();
        while (requestTopic == null && it.hasNext()) {
            MQTTTopic topic = (MQTTTopic)it.next();
            if (topic.getTopicName().compareTo(clientRequestTopicName) != 0) continue;
            requestTopic = topic;
        }
        return requestTopic;
    }

    private MQTTTopic getClientResponseTopic(MQTTROSServiceCall serviceCall) {
        MQTTTopic requestTopic = null;
        String clientRequestTopicName = ApogyAddonsMQTTROSFacade.INSTANCE.getMQTTROSArbitratorServerResponseTopicName(serviceCall.getServiceName());
        Iterator it = this.getClientSide().getSubscribedTopics().iterator();
        while (requestTopic == null && it.hasNext()) {
            MQTTTopic topic = (MQTTTopic)it.next();
            if (topic.getTopicName().compareTo(clientRequestTopicName) != 0) continue;
            requestTopic = topic;
        }
        return requestTopic;
    }

    private class ROSCallBack
    extends CompositeElementCallback {
        private MQTTROSServiceCall serviceCall;
        private Timer timer;

        public ROSCallBack(CompositeMqttCallback parent) {
            super(parent);
        }

        public ROSCallBack(CompositeMqttCallback parent, MQTTROSServiceCall serviceCall) {
            this(parent);
            this.serviceCall = serviceCall;
        }

        public void connectionLost(Throwable throwable) {
            MQTTROSServiceAnswer response = ApogyAddonsMQTTROSFacade.INSTANCE.createMQTTROSServiceAnswer(this.serviceCall);
            response.setException(throwable);
            this.serviceCall.setResponse(response);
            try {
                MQTTTopic responseTopic = MQTTROSArbitratorServerCustomImpl.this.getClientResponseTopic(this.serviceCall);
                MQTTROSArbitratorServerCustomImpl.this.getClientSide().publish(responseTopic, ApogyAddonsMQTTROSFacade.INSTANCE.convertToJSON(response).toString());
                this.container.removeCallback((MqttCallback)this);
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }

        public void deliveryComplete(IMqttDeliveryToken arg0) {
        }

        public void messageArrived(String topicName, MqttMessage message) throws Exception {
            this.stopTimer();
            MQTTROSServiceAnswer response = ApogyAddonsMQTTROSFacade.INSTANCE.createMQTTROSServiceAnswer(this.serviceCall);
            response.setResponse(new String(message.getPayload()));
            ApogyCommonTransactionFacade.INSTANCE.basicSet((EObject)this.serviceCall, (EStructuralFeature)ApogyAddonsMQTTROSPackage.Literals.MQTTROS_SERVICE_CALL__RESPONSE, (Object)response, true);
            Logger.info("Sending response to client <" + this.serviceCall.getUserID() + "> for service call to <" + this.serviceCall.getServiceName() + ">.");
            MQTTTopic responseTopic = MQTTROSArbitratorServerCustomImpl.this.getClientResponseTopic(this.serviceCall);
            this.container.removeCallback((MqttCallback)this);
            try {
                System.out.println("Response =================================");
                System.out.println(ApogyAddonsMQTTROSFacade.INSTANCE.convertToJSON(response).toString());
                MQTTROSArbitratorServerCustomImpl.this.getClientSide().publish(responseTopic, ApogyAddonsMQTTROSFacade.INSTANCE.convertToJSON(response).toString());
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }

        public void startTimer() {
            if (this.serviceCall.getTimeout() != -1L) {
                this.getTimer().schedule(new TimerTask(){

                    @Override
                    public void run() {
                        try {
                            ROSCallBack.this.timedOut();
                        }
                        catch (Exception exception) {}
                    }
                }, this.serviceCall.getTimeout());
            }
        }

        public void stopTimer() {
            this.getTimer().cancel();
        }

        private Timer getTimer() {
            if (this.timer == null) {
                this.timer = new Timer(false);
            }
            return this.timer;
        }

        private void timedOut() throws Exception {
            String msg = "Call to ROS service <" + this.serviceCall.getServiceName() + "> by <" + this.serviceCall.getUserID() + "> has timed out !";
            Logger.error(msg);
            this.stopTimer();
            this.container.removeCallback((MqttCallback)this);
            MQTTROSServiceAnswer response = ApogyAddonsMQTTROSFacade.INSTANCE.createMQTTROSServiceAnswer(this.serviceCall);
            JSONObject res = new JSONObject();
            res.put("allo", 1.0);
            response.setResponse(res);
            response.setException(new TimeoutException(msg));
            this.serviceCall.setResponse(response);
            MQTTTopic responseTopic = MQTTROSArbitratorServerCustomImpl.this.getClientResponseTopic(this.serviceCall);
            this.container.removeCallback((MqttCallback)this);
            try {
                MQTTROSArbitratorServerCustomImpl.this.getClientSide().publish(responseTopic, ApogyAddonsMQTTROSFacade.INSTANCE.convertToJSON(response).toString());
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }
    }
}

