/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.addons.mqtt.ros.impl;

import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.TimeoutException;
import org.eclipse.apogy.addons.mqtt.ApogyAddonsMQTTFacade;
import org.eclipse.apogy.addons.mqtt.MQTTTopic;
import org.eclipse.apogy.addons.mqtt.QualityOfService;
import org.eclipse.apogy.addons.mqtt.callbacks.CompositeElementCallback;
import org.eclipse.apogy.addons.mqtt.callbacks.CompositeMqttCallback;
import org.eclipse.apogy.addons.mqtt.ros.ApogyAddonsMQTTROSFacade;
import org.eclipse.apogy.addons.mqtt.ros.ApogyAddonsMQTTROSFactory;
import org.eclipse.apogy.addons.mqtt.ros.MQTTROSServiceAnswer;
import org.eclipse.apogy.addons.mqtt.ros.MQTTROSServiceCall;
import org.eclipse.apogy.addons.mqtt.ros.impl.MQTTROSArbitratorClientImpl;
import org.eclipse.paho.client.mqttv3.IMqttDeliveryToken;
import org.eclipse.paho.client.mqttv3.MqttCallback;
import org.eclipse.paho.client.mqttv3.MqttMessage;
import org.json.JSONObject;

public class MQTTROSArbitratorClientCustomImpl
extends MQTTROSArbitratorClientImpl {
    private SecureRandom seedRandom = new SecureRandom();
    private SecureRandom secureRandom = new SecureRandom(this.seedRandom.generateSeed(100));
    private List<Long> previouslyUsedTokens = new ArrayList<Long>();

    @Override
    public void setArbitratorInducedDelay(long newArbitratorInducedDelay) {
        if (newArbitratorInducedDelay >= 0L) {
            super.setArbitratorInducedDelay(newArbitratorInducedDelay);
        }
    }

    @Override
    public void start() {
        this.getMqttClient().start();
    }

    @Override
    public void stop() {
        if (this.getMqttClient() != null) {
            this.getMqttClient().stop();
        }
    }

    @Override
    public void call(MQTTROSServiceCall serviceCall) throws Exception {
        serviceCall.setUserID(this.getMqttClient().getConnectionOptions().getUserName());
        JSONObject callJSONObject = ApogyAddonsMQTTROSFacade.INSTANCE.convertToJSON(serviceCall);
        MQTTTopic requestTopic = this.getServiceRequestTopic(serviceCall.getServiceName());
        MQTTTopic responseTopic = this.getServiceResponseTopic(serviceCall.getServiceName());
        CompositeMqttCallback compositeCallback = (CompositeMqttCallback)responseTopic.getCallBack();
        ClientMqttCallback reponseCallback = new ClientMqttCallback(compositeCallback, serviceCall);
        reponseCallback.startTimer();
        System.out.println("--------------------------------");
        System.out.println("TOPIC NAME : " + requestTopic.getTopicName());
        System.out.println("COMMAND STRING : ");
        System.out.println(callJSONObject.toString());
        System.out.println("--------------------------------");
        this.getMqttClient().publish(requestTopic, callJSONObject.toString());
    }

    @Override
    public void call(String serviceName, JSONObject rosRequest) throws Exception {
        MQTTROSServiceCall serviceCall = ApogyAddonsMQTTROSFactory.eINSTANCE.createMQTTROSServiceCall();
        if (this.getMqttClient() != null && this.getMqttClient().getConnectionOptions() != null) {
            serviceCall.setUserID(this.getMqttClient().getConnectionOptions().getUserName());
        }
        serviceCall.setServiceName(serviceName);
        serviceCall.setToken(this.getNextToken());
        serviceCall.setRosRequest(rosRequest);
        this.call(serviceCall);
    }

    private long getNextToken() {
        long token = this.secureRandom.nextLong();
        while (this.previouslyUsedTokens.contains(token)) {
            token = this.secureRandom.nextLong();
        }
        this.previouslyUsedTokens.add(token);
        return token;
    }

    private MQTTTopic getServiceRequestTopic(String serviceName) {
        String requestTopicName = ApogyAddonsMQTTROSFacade.INSTANCE.getMQTTROSArbitratorServerRequestTopicName(serviceName);
        MQTTTopic topic = this.getMQTTTopicByName(requestTopicName);
        if (topic == null) {
            topic = ApogyAddonsMQTTFacade.INSTANCE.createMQTTTopic(requestTopicName, QualityOfService.QOS_1, null, -1L);
            this.getMqttClient().subscribe(topic);
        }
        return topic;
    }

    private MQTTTopic getServiceResponseTopic(String serviceName) {
        String responseTopicName = ApogyAddonsMQTTROSFacade.INSTANCE.getMQTTROSArbitratorServerResponseTopicName(serviceName);
        MQTTTopic topic = this.getMQTTTopicByName(responseTopicName);
        if (topic == null) {
            topic = ApogyAddonsMQTTFacade.INSTANCE.createMQTTTopic(responseTopicName, QualityOfService.QOS_1, (MqttCallback)new CompositeMqttCallback(), -1L);
            this.getMqttClient().subscribe(topic);
        }
        return topic;
    }

    private MQTTTopic getMQTTTopicByName(String topicName) {
        MQTTTopic topic = null;
        Iterator it = this.getMqttClient().getSubscribedTopics().iterator();
        while (topic == null && it.hasNext()) {
            MQTTTopic t = (MQTTTopic)it.next();
            if (t.getTopicName().compareTo(topicName) != 0) continue;
            topic = t;
        }
        return topic;
    }

    private class ClientMqttCallback
    extends CompositeElementCallback {
        private MQTTROSServiceCall serviceCall;
        private Timer timer;

        public ClientMqttCallback(CompositeMqttCallback parent, MQTTROSServiceCall serviceCall) {
            super(parent);
            parent.addCallback((MqttCallback)this);
            this.serviceCall = serviceCall;
        }

        public void connectionLost(Throwable throwable) {
            this.stopTimer();
            this.container.removeCallback((MqttCallback)this);
            MQTTROSServiceAnswer response = ApogyAddonsMQTTROSFactory.eINSTANCE.createMQTTROSServiceAnswer();
            response.setResponse(null);
            response.setException(throwable);
            this.serviceCall.setResponse(response);
        }

        public void deliveryComplete(IMqttDeliveryToken token) {
        }

        public void messageArrived(String topicNAme, MqttMessage message) throws Exception {
            JSONObject jsonObject = new JSONObject(new String(message.getPayload()));
            MQTTROSServiceAnswer response = ApogyAddonsMQTTROSFacade.INSTANCE.convertToMQTTROSServiceAnswer(jsonObject);
            if (response.getToken() == this.serviceCall.getToken() && response.getUserID().compareTo(this.serviceCall.getUserID()) == 0 && response.getServiceName().compareTo(this.serviceCall.getServiceName()) == 0) {
                this.stopTimer();
                this.container.removeCallback((MqttCallback)this);
                this.serviceCall.setResponse(response);
            }
        }

        public void startTimer() {
            if (this.serviceCall.getTimeout() != -1L) {
                this.getTimer().schedule(new TimerTask(){

                    @Override
                    public void run() {
                        ClientMqttCallback.this.timedOut();
                    }
                }, this.serviceCall.getTimeout() + MQTTROSArbitratorClientCustomImpl.this.getArbitratorInducedDelay());
            }
        }

        public void stopTimer() {
            this.getTimer().cancel();
        }

        private Timer getTimer() {
            if (this.timer == null) {
                this.timer = new Timer(false);
            }
            return this.timer;
        }

        private void timedOut() {
            this.stopTimer();
            this.container.removeCallback((MqttCallback)this);
            MQTTROSServiceAnswer response = ApogyAddonsMQTTROSFactory.eINSTANCE.createMQTTROSServiceAnswer();
            response.setResponse(null);
            response.setException(new TimeoutException("Call to Arbitrator has timed out !"));
            this.serviceCall.setResponse(response);
        }
    }
}

