/*
 * Decompiled with CFR 0.152.
 */
package geometry_msgs;

import geometry_msgs.Point;
import geometry_msgs.PointMQTT;
import geometry_msgs.Pose;
import geometry_msgs.Quaternion;
import geometry_msgs.QuaternionMQTT;
import javax.vecmath.Matrix4d;
import javax.vecmath.Quat4d;
import javax.vecmath.Vector3d;
import org.json.JSONObject;
import org.ros.internal.message.RawMessage;

public class PoseMQTT
implements Pose {
    private Point position;
    private Quaternion orientation;

    public PoseMQTT() {
    }

    public PoseMQTT(Matrix4d matrix) {
        Vector3d position = new Vector3d();
        matrix.get(position);
        PointMQTT point = new PointMQTT(position.getX(), position.getY(), position.getZ());
        this.setPosition(point);
        Quat4d quat = new Quat4d();
        quat.set(matrix);
        QuaternionMQTT quaternion = new QuaternionMQTT(quat.x, quat.y, quat.z, quat.w);
        this.setOrientation(quaternion);
    }

    public PoseMQTT(JSONObject jsonObject) throws Exception {
        this.parseJSONObject(jsonObject);
    }

    public PoseMQTT(String jsonString) throws Exception {
        JSONObject jsonObject = new JSONObject(jsonString);
        this.parseJSONObject(jsonObject);
    }

    public RawMessage toRawMessage() {
        return null;
    }

    public Point getPosition() {
        return this.position;
    }

    public void setPosition(Point value) {
        this.position = value;
    }

    public Quaternion getOrientation() {
        return this.orientation;
    }

    public void setOrientation(Quaternion value) {
        this.orientation = value;
    }

    public static JSONObject toJSONObject(Pose pose) throws Exception {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("position", (Object)PointMQTT.toJSONObject(pose.getPosition()));
        jsonObject.put("orientation", (Object)QuaternionMQTT.toJSONObject(pose.getOrientation()));
        return jsonObject;
    }

    protected void parseJSONObject(JSONObject jsonObject) throws Exception {
        this.setPosition(new PointMQTT(jsonObject.getJSONObject("position")));
        this.setOrientation(new QuaternionMQTT(jsonObject.getJSONObject("orientation")));
    }
}

