/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.addons.mobility.pathplanners.graph.impl;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.SortedSet;
import org.eclipse.apogy.addons.geometry.paths.ApogyAddonsGeometryPathsFactory;
import org.eclipse.apogy.addons.geometry.paths.PathUtilities;
import org.eclipse.apogy.addons.geometry.paths.WayPointPath;
import org.eclipse.apogy.addons.mobility.pathplanners.ApogyAddonsMobilityPathplannersPackage;
import org.eclipse.apogy.addons.mobility.pathplanners.graph.ApogyAddonsMobilityPathplannersGraphFactory;
import org.eclipse.apogy.addons.mobility.pathplanners.graph.ApogyAddonsMobilityPathplannersGraphPackage;
import org.eclipse.apogy.addons.mobility.pathplanners.graph.CostBasedMeshWayPointPathPlanner;
import org.eclipse.apogy.addons.mobility.pathplanners.graph.GraphUtilities;
import org.eclipse.apogy.addons.mobility.pathplanners.graph.MobilityEdge;
import org.eclipse.apogy.addons.mobility.pathplanners.graph.MobilityEdgeFactory;
import org.eclipse.apogy.addons.mobility.pathplanners.graph.impl.SimpleDirectedWeightedGraphBasedMeshWayPointPathPlannerImpl;
import org.eclipse.apogy.common.emf.ApogyCommonTransactionFacade;
import org.eclipse.apogy.common.geometry.data.Mesh;
import org.eclipse.apogy.common.geometry.data3d.ApogyCommonGeometryData3DFacade;
import org.eclipse.apogy.common.geometry.data3d.CartesianCoordinatesSet;
import org.eclipse.apogy.common.geometry.data3d.CartesianPlane;
import org.eclipse.apogy.common.geometry.data3d.CartesianPolygon;
import org.eclipse.apogy.common.geometry.data3d.CartesianPositionCoordinates;
import org.eclipse.apogy.common.geometry.data3d.CartesianTriangle;
import org.eclipse.apogy.common.geometry.data3d.CartesianTriangularMesh;
import org.eclipse.apogy.common.geometry.data3d.Geometry3DUtilities;
import org.eclipse.apogy.common.topology.ApogyCommonTopologyFacade;
import org.eclipse.apogy.common.topology.ContentNode;
import org.eclipse.apogy.common.topology.TransformNode;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.jgrapht.Graph;
import org.jgrapht.graph.SimpleDirectedWeightedGraph;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleDirectedWeightedGraphBasedMeshWayPointPathPlannerCustomImpl<PolygonType extends CartesianPolygon>
extends SimpleDirectedWeightedGraphBasedMeshWayPointPathPlannerImpl<PolygonType> {
    private static final Logger Logger = LoggerFactory.getLogger(SimpleDirectedWeightedGraphBasedMeshWayPointPathPlannerImpl.class);
    private Adapter costFunctionsAdapter = null;
    private boolean graphIsDirty = true;

    protected SimpleDirectedWeightedGraphBasedMeshWayPointPathPlannerCustomImpl() {
        this.eAdapters().add((Object)this.getCostFunctionsAdapter());
    }

    @Override
    public SimpleDirectedWeightedGraph getSimpleDirectedWeightedGraph() {
        if (this.graphIsDirty) {
            Logger.debug("Graph is dirty, regenerating it...");
            try {
                SimpleDirectedWeightedGraph graph = this.createGraph();
                this.graphIsDirty = false;
                ApogyCommonTransactionFacade.INSTANCE.basicSet((EObject)this, (EStructuralFeature)ApogyAddonsMobilityPathplannersGraphPackage.Literals.SIMPLE_DIRECTED_WEIGHTED_GRAPH_BASED_MESH_WAY_POINT_PATH_PLANNER__SIMPLE_DIRECTED_WEIGHTED_GRAPH, (Object)graph);
            }
            catch (Exception e) {
                Logger.error(e.getMessage(), (Throwable)e);
                ApogyCommonTransactionFacade.INSTANCE.basicSet((EObject)this, (EStructuralFeature)ApogyAddonsMobilityPathplannersGraphPackage.Literals.SIMPLE_DIRECTED_WEIGHTED_GRAPH_BASED_MESH_WAY_POINT_PATH_PLANNER__SIMPLE_DIRECTED_WEIGHTED_GRAPH, null);
            }
        }
        return super.getSimpleDirectedWeightedGraph();
    }

    public WayPointPath plan(CartesianPositionCoordinates currentPosition, CartesianPositionCoordinates destinationPosition) throws Exception {
        ApogyCommonTransactionFacade.INSTANCE.basicSet((EObject)this, (EStructuralFeature)ApogyAddonsMobilityPathplannersPackage.Literals.WAY_POINT_PATH_PLANNER__CURRENT_POSITION, (Object)currentPosition);
        ApogyCommonTransactionFacade.INSTANCE.basicSet((EObject)this, (EStructuralFeature)ApogyAddonsMobilityPathplannersPackage.Literals.WAY_POINT_PATH_PLANNER__CURRENT_DESTINATION, (Object)destinationPosition);
        Date start = new Date();
        WayPointPath path = ApogyAddonsGeometryPathsFactory.eINSTANCE.createWayPointPath();
        List<CartesianPolygon> polygonPath = null;
        polygonPath = this.getPolygonPath(currentPosition, destinationPosition);
        path = this.generatePath(currentPosition, destinationPosition, polygonPath);
        Date end = new Date();
        double time = (double)(end.getTime() - start.getTime()) / 1000.0;
        Logger.debug("Planned path between (" + currentPosition.getX() + ", " + currentPosition.getY() + ", " + currentPosition.getZ() + ") and (" + destinationPosition.getX() + ", " + destinationPosition.getY() + ", " + destinationPosition.getZ() + ") in " + time + " seconds.");
        return path;
    }

    public WayPointPath doProcess(CartesianCoordinatesSet input, IProgressMonitor monitor) throws Exception {
        if (input.getPoints().size() < 2) {
            Logger.debug("Needs to specify at least two points to plan a path ! Specified <" + input.getPoints().size() + "> points !");
            throw new Exception("Needs to specify at least two points to plan a path ! Specified <" + input.getPoints().size() + "> points !");
        }
        WayPointPath path = ApogyAddonsGeometryPathsFactory.eINSTANCE.createWayPointPath();
        try {
            monitor.beginTask("Planning path.", input.getPoints().size() - 1);
            int i = 1;
            while (i < input.getPoints().size()) {
                Logger.debug("Planning between point[" + (i - 1) + "] and point [" + i + "]...");
                ApogyCommonTransactionFacade.INSTANCE.basicSet((EObject)this, (EStructuralFeature)ApogyAddonsMobilityPathplannersPackage.Literals.WAY_POINT_PATH_PLANNER__CURRENT_POSITION, input.getPoints().get(i - 1));
                ApogyCommonTransactionFacade.INSTANCE.basicSet((EObject)this, (EStructuralFeature)ApogyAddonsMobilityPathplannersPackage.Literals.WAY_POINT_PATH_PLANNER__CURRENT_DESTINATION, input.getPoints().get(i));
                WayPointPath pathSegment = this.plan(this.getCurrentPosition(), this.getCurrentDestination());
                path = PathUtilities.append((WayPointPath)path, (WayPointPath)pathSegment, (boolean)true);
                ApogyCommonTransactionFacade.INSTANCE.basicSet((EObject)this, (EStructuralFeature)ApogyAddonsMobilityPathplannersPackage.Literals.WAY_POINT_PATH_PLANNER__CURRENT_POSITION, (Object)this.getCurrentDestination());
                monitor.worked(1);
                Logger.debug("Planning between point[" + (i - 1) + "] and point [" + i + "] done.");
                ++i;
            }
            Logger.debug("Planning completed.");
        }
        finally {
            monitor.done();
        }
        monitor.done();
        return path;
    }

    protected SimpleDirectedWeightedGraph createGraph() throws Exception {
        Logger.debug("Creating Graph...");
        if (this.getMesh() == null) {
            Logger.debug("No mesh has been defined defined !");
            throw new Exception("No mesh has been defined defined !");
        }
        if (this.getCostFunctions().size() == 0) {
            Logger.debug("No cost function has been defined !");
            throw new Exception("No cost function has been defined !");
        }
        Logger.debug("Creating Graph using <" + this.getCostFunctions() + "> cost function(s)...");
        MobilityEdgeFactory edgeFactory = ApogyAddonsMobilityPathplannersGraphFactory.eINSTANCE.createMobilityEdgeFactory();
        edgeFactory.getCostFunctions().addAll(this.getCostFunctions());
        Date start = new Date();
        SimpleDirectedWeightedGraph tempGraph = GraphUtilities.createGraph(this.getMesh(), edgeFactory, null);
        Date end = new Date();
        double time = (double)(end.getTime() - start.getTime()) / 1000.0;
        Logger.debug("Created Graph with " + tempGraph.vertexSet().size() + " vertices and " + tempGraph.edgeSet().size() + " edges in " + time + " seconds.");
        return tempGraph;
    }

    protected CartesianPolygon getStartPolygon(CartesianPositionCoordinates startPositionCoordinates) {
        Logger.debug("getStartPolygon()...");
        CartesianPolygon start = null;
        SortedSet sortedPolygons = Geometry3DUtilities.sortCartesianPolygonByDistance((CartesianPositionCoordinates)startPositionCoordinates, (Collection)this.getMesh().getPolygons());
        if (sortedPolygons.size() > 0) {
            start = (CartesianPolygon)sortedPolygons.first();
        }
        Logger.debug("getStartPolygon(). Done.");
        return start;
    }

    protected CartesianPolygon getEndPolygon(CartesianPositionCoordinates endPositionCoordinates) {
        Logger.debug("getEndPolygon()...");
        CartesianPolygon end = null;
        SortedSet sortedPolygons = Geometry3DUtilities.sortCartesianPolygonByDistance((CartesianPositionCoordinates)endPositionCoordinates, (Collection)this.getMesh().getPolygons());
        if (sortedPolygons.size() > 0) {
            end = (CartesianPolygon)sortedPolygons.first();
        }
        Logger.debug("getEndPolygon(). Done.");
        return end;
    }

    protected List<CartesianPolygon> getPolygonPath(CartesianPositionCoordinates currentPosition, CartesianPositionCoordinates destinationPosition) throws Exception {
        List<CartesianPolygon> polygonPath = new ArrayList<CartesianPolygon>();
        CartesianPolygon startPolygon = this.getStartPolygon(currentPosition);
        CartesianPolygon endPolygon = this.getEndPolygon(destinationPosition);
        if (startPolygon != null || endPolygon != null) {
            Logger.debug("Calling DijkstraShortestPath...");
            List<MobilityEdge> edges = GraphUtilities.getDijkstraShortestPath((Graph)this.getSimpleDirectedWeightedGraph(), startPolygon, endPolygon);
            double pathCost = GraphUtilities.getPathCost(edges);
            Logger.debug("Calling DijkstraShortestPath done.");
            if (Double.isInfinite(pathCost)) {
                Logger.debug("Infinite cost Path.");
                throw new Exception("Infinite cost Path.");
            }
            polygonPath = GraphUtilities.getPolygonPath(edges);
        } else if (startPolygon == null) {
            Logger.debug("Could not find a polygon for the start position !");
            throw new Exception("Could not find a polygon for the start position !");
        }
        return polygonPath;
    }

    protected WayPointPath generatePath(CartesianPositionCoordinates currentPosition, CartesianPositionCoordinates destinationPosition, List<CartesianPolygon> polygonPath) {
        WayPointPath path = null;
        if (this.isEnablePathSimplification()) {
            path = GraphUtilities.getSimplifiedPathThroughPolygonsCentroid(CartesianPlane.XY, currentPosition, destinationPosition, polygonPath, this.getRobotWidthForPathSimplication());
        } else {
            path = GraphUtilities.getPathThroughPolygonsCentroid(polygonPath);
            path.getPoints().add(0, (Object)ApogyCommonGeometryData3DFacade.INSTANCE.createCartesianPositionCoordinates(currentPosition));
            path.getPoints().add((Object)ApogyCommonGeometryData3DFacade.INSTANCE.createCartesianPositionCoordinates(destinationPosition));
        }
        return path;
    }

    private void savePolygonPath(List<CartesianTriangle> polygonPath, String path, String fileName) {
        TransformNode root = ApogyCommonTopologyFacade.INSTANCE.createTransformNodeXYZ(0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
        CartesianTriangularMesh pathMesh = ApogyCommonGeometryData3DFacade.INSTANCE.createCartesianTriangularMesh(polygonPath);
        ContentNode pathNode = ApogyCommonTopologyFacade.INSTANCE.createContentNode((Object)pathMesh);
        pathNode.setDescription("Polygon Path.");
        root.getChildren().add((Object)pathNode);
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        Resource resource = resourceSet.createResource(URI.createFileURI((String)(String.valueOf(path) + File.separator + fileName)));
        resource.getContents().add((Object)pathMesh);
        try {
            resource.save(Collections.EMPTY_MAP);
        }
        catch (IOException e) {
            Logger.error(e.getMessage(), (Throwable)e);
        }
    }

    public void setMesh(Mesh newMesh) {
        this.graphIsDirty = true;
        super.setMesh(newMesh);
    }

    private Adapter getCostFunctionsAdapter() {
        if (this.costFunctionsAdapter == null) {
            this.costFunctionsAdapter = new AdapterImpl(){

                public void notifyChanged(Notification msg) {
                    if (msg.getFeatureID(CostBasedMeshWayPointPathPlanner.class) == 7) {
                        ApogyCommonTransactionFacade.INSTANCE.basicSet((EObject)SimpleDirectedWeightedGraphBasedMeshWayPointPathPlannerCustomImpl.this, (EStructuralFeature)ApogyAddonsMobilityPathplannersGraphPackage.Literals.SIMPLE_DIRECTED_WEIGHTED_GRAPH_BASED_MESH_WAY_POINT_PATH_PLANNER__SIMPLE_DIRECTED_WEIGHTED_GRAPH, null);
                        SimpleDirectedWeightedGraphBasedMeshWayPointPathPlannerCustomImpl.this.eUnset(8);
                    }
                }
            };
        }
        return this.costFunctionsAdapter;
    }
}

