/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.addons.sensors.pose.impl;

import javax.vecmath.Matrix3d;
import org.eclipse.apogy.addons.sensors.pose.impl.SimulatedPoseSensorImpl;
import org.eclipse.apogy.common.math.ApogyCommonMathFacade;
import org.eclipse.apogy.common.math.ApogyCommonMathFactory;
import org.eclipse.apogy.common.math.GeometricUtils;
import org.eclipse.apogy.common.math.Tuple3d;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimulatedPoseSensorCustomImpl
extends SimulatedPoseSensorImpl {
    private static final Logger Logger = LoggerFactory.getLogger(SimulatedPoseSensorImpl.class);

    protected SimulatedPoseSensorCustomImpl() {
        this.initialize();
    }

    private void initialize() {
        if (this.getRotationMatrix() == null) {
            this.setRotationMatrix(ApogyCommonMathFactory.eINSTANCE.createMatrix3x3());
        }
        if (this.getPosition() == null) {
            this.setPosition(ApogyCommonMathFactory.eINSTANCE.createTuple3d());
        }
        Thread t = new Thread(){

            @Override
            public void run() {
                while (true) {
                    try {
                        while (true) {
                            Matrix3d oldRotation = SimulatedPoseSensorCustomImpl.this.getRotationMatrix().asMatrix3d();
                            Matrix3d newRotation = GeometricUtils.packXYZ((double)(SimulatedPoseSensorCustomImpl.this.getUpdatePeriod() * SimulatedPoseSensorCustomImpl.this.getXAngularVelocity()), (double)(SimulatedPoseSensorCustomImpl.this.getUpdatePeriod() * SimulatedPoseSensorCustomImpl.this.getYAngularVelocity()), (double)(SimulatedPoseSensorCustomImpl.this.getUpdatePeriod() * SimulatedPoseSensorCustomImpl.this.getZAngularVelocity()));
                            oldRotation.mul(newRotation);
                            SimulatedPoseSensorCustomImpl.this.setRotationMatrix(ApogyCommonMathFacade.INSTANCE.createMatrix3x3(oldRotation));
                            Tuple3d oldPosition = SimulatedPoseSensorCustomImpl.this.getPosition();
                            Tuple3d newPosition = ApogyCommonMathFactory.eINSTANCE.createTuple3d();
                            newPosition.setX(oldPosition.getX() + SimulatedPoseSensorCustomImpl.this.getXVelocity() * SimulatedPoseSensorCustomImpl.this.getUpdatePeriod());
                            newPosition.setY(oldPosition.getY() + SimulatedPoseSensorCustomImpl.this.getYVelocity() * SimulatedPoseSensorCustomImpl.this.getUpdatePeriod());
                            newPosition.setZ(oldPosition.getZ() + SimulatedPoseSensorCustomImpl.this.getZVelocity() * SimulatedPoseSensorCustomImpl.this.getUpdatePeriod());
                            SimulatedPoseSensorCustomImpl.this.setPosition(newPosition);
                            long delay = Math.round(SimulatedPoseSensorCustomImpl.this.getUpdatePeriod() * 1000.0);
                            Thread.sleep(delay);
                        }
                    }
                    catch (Exception e) {
                        Logger.error(e.getMessage(), (Throwable)e);
                        continue;
                    }
                    break;
                }
            }
        };
        t.start();
    }
}

