/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.core.environment.earth.orbit.ui.wizards;

import org.eclipse.apogy.core.environment.earth.orbit.ApogyCoreEnvironmentEarthOrbitPackage;
import org.eclipse.apogy.core.environment.earth.orbit.EarthSpacecraft;
import org.eclipse.apogy.core.environment.earth.orbit.TLEEarthOrbitModel;
import org.eclipse.apogy.core.environment.earth.orbit.URLBasedTLE;
import org.eclipse.apogy.core.environment.orbit.ApogyCoreEnvironmentOrbitPackage;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.UpdateValueStrategy;
import org.eclipse.core.databinding.conversion.Converter;
import org.eclipse.core.databinding.conversion.IConverter;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.emf.databinding.EMFProperties;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.jface.databinding.swt.ISWTObservableValue;
import org.eclipse.jface.databinding.swt.WidgetProperties;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

public class SpacecraftIDsWizardPage
extends WizardPage {
    private static final String WIZARD_PAGE_ID = "org.eclipse.apogy.core.environment.earth.orbit.ui.wizards.SpacecraftIDsWizardPage";
    private EarthSpacecraft spacecraft;
    private DataBindingContext m_bindingContext;
    private Text noradIDText;
    private Text internationalDesignatorText;

    public SpacecraftIDsWizardPage(EarthSpacecraft spacecraft) {
        super(WIZARD_PAGE_ID);
        this.spacecraft = spacecraft;
        this.setTitle("Spacecraft Identifiers.");
        this.setDescription("Set the Spacecraft Identifiers.");
        this.validate();
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        container.setLayout((Layout)new GridLayout(2, true));
        this.setControl((Control)container);
        Label noradIDLabel = new Label(container, 0);
        noradIDLabel.setText("NORAD ID:");
        noradIDLabel.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.noradIDText = new Text(container, 2052);
        this.noradIDText.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        Label internationalDesignatorLabel = new Label(container, 0);
        internationalDesignatorLabel.setText("International Designator:");
        internationalDesignatorLabel.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.internationalDesignatorText = new Text(container, 2052);
        this.internationalDesignatorText.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.m_bindingContext = this.initDataBindings();
        container.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                if (SpacecraftIDsWizardPage.this.m_bindingContext != null) {
                    SpacecraftIDsWizardPage.this.m_bindingContext.dispose();
                }
            }
        });
    }

    protected void validate() {
        this.setErrorMessage(null);
        this.setPageComplete(this.getErrorMessage() == null);
    }

    protected DataBindingContext initDataBindings() {
        TLEEarthOrbitModel tleEarthOrbitModel;
        DataBindingContext bindingContext = new DataBindingContext();
        ISWTObservableValue noradIdObserveWidget = WidgetProperties.text((int)24).observe((Widget)this.noradIDText);
        IObservableValue noradIDObserveValue = EMFProperties.value((EStructuralFeature)ApogyCoreEnvironmentEarthOrbitPackage.Literals.EARTH_SPACECRAFT__NORAD_ID).observe((Object)this.spacecraft);
        bindingContext.bindValue((IObservableValue)noradIdObserveWidget, noradIDObserveValue, null, null);
        ISWTObservableValue internationalDesignatorObserveWidget = WidgetProperties.text((int)24).observe((Widget)this.internationalDesignatorText);
        IObservableValue internationalDesignatorObserveValue = EMFProperties.value((EStructuralFeature)ApogyCoreEnvironmentOrbitPackage.Literals.SPACECRAFT__INTERNATIONAL_DESIGNATOR).observe((Object)this.spacecraft);
        bindingContext.bindValue((IObservableValue)internationalDesignatorObserveWidget, internationalDesignatorObserveValue, null, null);
        if (this.spacecraft.getOrbitModel() instanceof TLEEarthOrbitModel && (tleEarthOrbitModel = (TLEEarthOrbitModel)this.spacecraft.getOrbitModel()).getTle() instanceof URLBasedTLE) {
            IObservableValue tleNoradIDObserveValue = EMFProperties.value((EStructuralFeature)ApogyCoreEnvironmentEarthOrbitPackage.Literals.URL_BASED_TLE__TARGET_SATELLITE_NUMBER).observe((Object)tleEarthOrbitModel.getTle());
            bindingContext.bindValue((IObservableValue)noradIdObserveWidget, tleNoradIDObserveValue, new UpdateValueStrategy().setConverter((IConverter)new Converter(String.class, Integer.class){

                public Object convert(Object fromObject) {
                    return Integer.parseInt((String)fromObject);
                }
            }), new UpdateValueStrategy(UpdateValueStrategy.POLICY_NEVER));
        }
        return bindingContext;
    }
}

