/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.core.environment.earth.orbit.ui.wizards;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.eclipse.apogy.common.emf.ApogyCommonTransactionFacade;
import org.eclipse.apogy.core.environment.earth.orbit.ApogyCoreEnvironmentEarthOrbitPackage;
import org.eclipse.apogy.core.environment.earth.orbit.ObservationTarget;
import org.eclipse.apogy.core.environment.earth.orbit.OrbitAnalysisData;
import org.eclipse.apogy.core.environment.earth.orbit.ui.wizards.CommitImportedObservationWizardPage;
import org.eclipse.apogy.core.environment.earth.orbit.ui.wizards.ObservationImporterWizardPage;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.widgets.Shell;

public class ImportObservationsWizard
extends Wizard {
    private OrbitAnalysisData orbitAnalysisData;
    private List<ObservationTarget> importedTargets = null;
    private ObservationImporterWizardPage selectObservationImporterWizardPage;
    private CommitImportedObservationWizardPage commitImportedObservationWizardPage;

    public ImportObservationsWizard(OrbitAnalysisData orbitAnalysisData) {
        this.setWindowTitle("Import Observations.");
        this.orbitAnalysisData = orbitAnalysisData;
    }

    public void addPages() {
        this.selectObservationImporterWizardPage = new ObservationImporterWizardPage(this.orbitAnalysisData){

            @Override
            protected void observationsImported(List<ObservationTarget> importedTargets) {
                ImportObservationsWizard.this.importedTargets = importedTargets;
                ImportObservationsWizard.this.commitImportedObservationWizardPage.setImportedTargets(importedTargets);
            }
        };
        this.addPage((IWizardPage)this.selectObservationImporterWizardPage);
        this.commitImportedObservationWizardPage = new CommitImportedObservationWizardPage(this.orbitAnalysisData);
        this.addPage((IWizardPage)this.commitImportedObservationWizardPage);
    }

    public boolean canFinish() {
        return this.importedTargets != null;
    }

    public boolean performFinish() {
        try {
            Set<ObservationTarget> targetsToAddToOrbitAnalysisData = this.commitImportedObservationWizardPage.getTargetsToAddToOrbitAnalysisData();
            ApogyCommonTransactionFacade.INSTANCE.basicAdd((EObject)this.orbitAnalysisData, (EStructuralFeature)ApogyCoreEnvironmentEarthOrbitPackage.Literals.ORBIT_ANALYSIS_DATA__OBSERVATION_TARGETS, targetsToAddToOrbitAnalysisData, true);
            Set<ObservationTarget> targetsToRemoveFromOrbitAnalysisData = this.commitImportedObservationWizardPage.getTargetsToRemoveFromOrbitAnalysisData();
            ApogyCommonTransactionFacade.INSTANCE.basicRemove((EObject)this.orbitAnalysisData, (EStructuralFeature)ApogyCoreEnvironmentEarthOrbitPackage.Literals.ORBIT_ANALYSIS_DATA__OBSERVATION_TARGETS, targetsToRemoveFromOrbitAnalysisData, true);
            return true;
        }
        catch (Exception e) {
            this.getShell().getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    MultiStatus status = this.createMultiStatus(e.getLocalizedMessage(), e);
                    ErrorDialog.openError((Shell)ImportObservationsWizard.this.getShell(), (String)"Import failed", (String)"An exception occured during targets import.", (IStatus)status);
                }

                private MultiStatus createMultiStatus(String msg, Throwable t) {
                    StackTraceElement[] stackTraces;
                    ArrayList<Status> childStatuses = new ArrayList<Status>();
                    StackTraceElement[] stackTraceElementArray = stackTraces = Thread.currentThread().getStackTrace();
                    int n = stackTraces.length;
                    int n2 = 0;
                    while (n2 < n) {
                        StackTraceElement stackTrace = stackTraceElementArray[n2];
                        Status status = new Status(4, "org.eclipse.apogy.core.environment.earth.orbit", stackTrace.toString());
                        childStatuses.add(status);
                        ++n2;
                    }
                    MultiStatus ms = new MultiStatus("org.eclipse.apogy.core.environment.earth.orbit", 4, (IStatus[])childStatuses.toArray(new Status[0]), t.toString(), t);
                    return ms;
                }
            });
            return false;
        }
    }
}

