/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.core.environment.earth.orbit.ui.provider;

import java.text.DecimalFormat;
import org.eclipse.apogy.common.emf.ApogyCommonEMFFacade;
import org.eclipse.apogy.common.emf.TimeInterval;
import org.eclipse.apogy.core.environment.earth.orbit.ui.VisibilityPassWorldWindLayer;
import org.eclipse.apogy.core.environment.earth.orbit.ui.provider.VisibilityPassWorldWindLayerItemProvider;
import org.eclipse.emf.common.notify.AdapterFactory;

public class VisibilityPassWorldWindLayerCustomItemProvider
extends VisibilityPassWorldWindLayerItemProvider {
    private DecimalFormat durationFormat = new DecimalFormat("0.0");

    public VisibilityPassWorldWindLayerCustomItemProvider(AdapterFactory adapterFactory) {
        super(adapterFactory);
    }

    @Override
    public String getText(Object object) {
        String suffix;
        VisibilityPassWorldWindLayer layer = (VisibilityPassWorldWindLayer)object;
        String text = layer.getName();
        if (text == null || text.length() == 0) {
            text = this.getString("_UI_VisibilityPass_type");
        }
        text = String.valueOf(text) + " (";
        if (layer.getVisibilityPass() != null) {
            long duration = ApogyCommonEMFFacade.INSTANCE.getDuration((TimeInterval)layer.getVisibilityPass());
            if (duration > 60000L) {
                double minutes = (double)duration / 60000.0;
                text = String.valueOf(text) + this.durationFormat.format(minutes) + " min";
            } else {
                double seconds = (double)duration / 1000.0;
                text = String.valueOf(text) + this.durationFormat.format(seconds) + " s";
            }
        }
        if ((suffix = this.getAbstractWorldWindLayerText(layer)) != null && suffix.length() > 0) {
            text = String.valueOf(text) + ", " + suffix;
        }
        text = String.valueOf(text) + ")";
        return text;
    }
}

