/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.core.environment.earth.orbit.ui.impl;

import gov.nasa.worldwind.layers.RenderableLayer;
import gov.nasa.worldwind.render.Polyline;
import gov.nasa.worldwind.render.Renderable;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.apogy.core.environment.earth.EarthOutlook;
import org.eclipse.apogy.core.environment.earth.GeographicCoordinates;
import org.eclipse.apogy.core.environment.earth.orbit.VisibilityPass;
import org.eclipse.apogy.core.environment.earth.orbit.VisibilityPassSpacecraftPosition;
import org.eclipse.apogy.core.environment.earth.orbit.ui.impl.VisibilityPassWorldWindLayerImpl;
import org.eclipse.apogy.core.environment.earth.orbit.ui.utils.WorldWindOrbitUtils;
import org.eclipse.apogy.core.environment.earth.ui.utils.WorldWindUtils;
import org.eclipse.swt.graphics.RGBA;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VisibilityPassWorldWindLayerCustomImpl
extends VisibilityPassWorldWindLayerImpl {
    private static final Logger Logger = LoggerFactory.getLogger(VisibilityPassWorldWindLayerCustomImpl.class);

    @Override
    public void setColor(RGBA newColor) {
        super.setColor(newColor);
        if (this.isAutoUpdateEnabled()) {
            try {
                this.update();
            }
            catch (Exception e) {
                Logger.error("Error ocurred while updating the color. ", (Throwable)e);
            }
        }
    }

    @Override
    public void setDrawFillLines(boolean newDrawFillLines) {
        super.setDrawFillLines(newDrawFillLines);
        try {
            this.update();
        }
        catch (Exception e) {
            Logger.error("Error ocurred while updating the draw fill lines. ", (Throwable)e);
        }
    }

    @Override
    public void setVisibilityPass(VisibilityPass newVisibilityPass) {
        super.setVisibilityPass(newVisibilityPass);
        if (this.isAutoUpdateEnabled()) {
            try {
                this.update();
            }
            catch (Exception e) {
                Logger.error("Error ocurred while updating the VisibilityPass. ", (Throwable)e);
            }
        }
    }

    protected void updateRenderableLayer() {
        RenderableLayer layer = this.getRenderableLayer();
        layer.removeAllRenderables();
        if (this.isVisible() && this.getVisibilityPass() != null) {
            try {
                if (this.getVisibilityPass().getPositionHistory() != null && !this.getVisibilityPass().getPositionHistory().getPositions().isEmpty()) {
                    ArrayList<GeographicCoordinates> coordinates = new ArrayList<GeographicCoordinates>();
                    coordinates.add((GeographicCoordinates)this.getVisibilityPass().getOutlook());
                    for (VisibilityPassSpacecraftPosition position : this.getVisibilityPass().getPositionHistory().getPositions()) {
                        coordinates.add(position.getCoordinates());
                    }
                    coordinates.add((GeographicCoordinates)this.getVisibilityPass().getOutlook());
                    List<Polyline> polylines = WorldWindOrbitUtils.createPolyLineFromGeographicCoordinatesListNoWrapAround(coordinates, 66);
                    Color color = WorldWindUtils.convertFrom((RGBA)this.getColor());
                    for (Polyline line : polylines) {
                        line.setLineWidth(2.0);
                        line.setColor(color);
                        layer.addRenderable((Renderable)line);
                    }
                    if (this.isDrawFillLines()) {
                        EarthOutlook target = this.getVisibilityPass().getOutlook();
                        ArrayList<GeographicCoordinates> lineCoordinates = new ArrayList<GeographicCoordinates>();
                        for (GeographicCoordinates coord : coordinates) {
                            lineCoordinates.clear();
                            lineCoordinates.add((GeographicCoordinates)target);
                            lineCoordinates.add(coord);
                            List<Polyline> lines = WorldWindOrbitUtils.createPolyLineFromGeographicCoordinatesListNoWrapAround(lineCoordinates, 0);
                            for (Polyline lineSegment : lines) {
                                lineSegment.setColor(color);
                                lineSegment.setLineWidth(2.0);
                                layer.addRenderable((Renderable)lineSegment);
                            }
                        }
                    }
                }
            }
            catch (Exception e) {
                Logger.error("Error occured during updateRenderableLayer().", (Throwable)e);
            }
        }
    }
}

