/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.core.environment.earth.orbit.ui.impl;

import gov.nasa.worldwind.layers.RenderableLayer;
import gov.nasa.worldwind.render.BasicShapeAttributes;
import gov.nasa.worldwind.render.ExtrudedPolygon;
import gov.nasa.worldwind.render.Material;
import gov.nasa.worldwind.render.Polyline;
import gov.nasa.worldwind.render.Renderable;
import gov.nasa.worldwind.render.ShapeAttributes;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import org.eclipse.apogy.common.emf.ApogyCommonTransactionFacade;
import org.eclipse.apogy.common.emf.Timed;
import org.eclipse.apogy.core.ApogyCorePackage;
import org.eclipse.apogy.core.environment.earth.GeographicCoordinates;
import org.eclipse.apogy.core.environment.earth.orbit.ApogyCoreEnvironmentEarthOrbitFactory;
import org.eclipse.apogy.core.environment.earth.orbit.CorridorPoint;
import org.eclipse.apogy.core.environment.earth.orbit.EarthOrbitModel;
import org.eclipse.apogy.core.environment.earth.orbit.SpacecraftSwathCorridor;
import org.eclipse.apogy.core.environment.earth.orbit.ui.impl.SpacecraftSwathWorldWindLayerImpl;
import org.eclipse.apogy.core.environment.earth.orbit.ui.utils.WorldWindOrbitUtils;
import org.eclipse.apogy.core.environment.orbit.OrbitModel;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SpacecraftSwathWorldWindLayerCustomImpl
extends SpacecraftSwathWorldWindLayerImpl {
    private static final Logger Logger = LoggerFactory.getLogger(SpacecraftSwathWorldWindLayerImpl.class);
    public static final short GROUND_TRACE_STIPPLE_PATTERN = 255;
    public static final int GROUND_TRACE_STIPPLE_FACTOR = 1;
    private Adapter timedAdapter = null;

    @Override
    public void setOrbitModel(EarthOrbitModel newOrbitModel) {
        super.setOrbitModel(newOrbitModel);
        if (this.isAutoUpdateEnabled()) {
            try {
                this.update();
            }
            catch (Exception e) {
                Logger.error(e.getMessage(), (Throwable)e);
            }
        }
    }

    @Override
    public void setTimeSource(Timed newTimeSource) {
        if (this.timeSource != null) {
            this.timeSource.eAdapters().remove((Object)this.getTimedAdapter());
        }
        super.setTimeSource(newTimeSource);
        if (newTimeSource != null) {
            if (this.isAutoUpdateEnabled()) {
                try {
                    this.update();
                }
                catch (Exception e) {
                    Logger.error(e.getMessage(), (Throwable)e);
                }
            }
            newTimeSource.eAdapters().add((Object)this.getTimedAdapter());
        }
    }

    @Override
    public void setForwardPropagationDuration(double newForwardPropagationDuration) {
        super.setForwardPropagationDuration(newForwardPropagationDuration);
        if (this.isAutoUpdateEnabled()) {
            try {
                this.update();
            }
            catch (Exception e) {
                Logger.error(e.getMessage(), (Throwable)e);
            }
        }
    }

    @Override
    public void setBackwardPropagationDuration(double newBackwardPropagationDuration) {
        super.setBackwardPropagationDuration(newBackwardPropagationDuration);
        if (this.isAutoUpdateEnabled()) {
            try {
                this.update();
            }
            catch (Exception e) {
                Logger.error(e.getMessage(), (Throwable)e);
            }
        }
    }

    @Override
    public void setTimeInterval(double newTimeInterval) {
        super.setTimeInterval(newTimeInterval);
        if (this.isAutoUpdateEnabled()) {
            try {
                this.update();
            }
            catch (Exception e) {
                Logger.error(e.getMessage(), (Throwable)e);
            }
        }
    }

    @Override
    public void setLeftSwathAngle(double newLeftSwathAngle) {
        super.setLeftSwathAngle(newLeftSwathAngle);
        if (this.isAutoUpdateEnabled()) {
            try {
                this.update();
            }
            catch (Exception e) {
                Logger.error(e.getMessage(), (Throwable)e);
            }
        }
    }

    @Override
    public void setRightSwathAngle(double newRightSwathAngle) {
        super.setRightSwathAngle(newRightSwathAngle);
        if (this.isAutoUpdateEnabled()) {
            try {
                this.update();
            }
            catch (Exception e) {
                Logger.error(e.getMessage(), (Throwable)e);
            }
        }
    }

    @Override
    public void setShowGroundTrace(boolean newShowGroundTrace) {
        super.setShowGroundTrace(newShowGroundTrace);
        if (this.isAutoUpdateEnabled()) {
            try {
                this.update();
            }
            catch (Exception e) {
                Logger.error(e.getMessage(), (Throwable)e);
            }
        }
    }

    protected void updateRenderableLayer() {
        if (!this.isUpdating()) {
            ApogyCommonTransactionFacade.INSTANCE.basicSet((EObject)this, (EStructuralFeature)ApogyCorePackage.Literals.UPDATABLE__UPDATING, (Object)true);
            final RenderableLayer layer = this.getRenderableLayer();
            layer.removeAllRenderables();
            Job job = new Job("SpacecraftSwathWorldWindLayer updateRenderableLayer"){

                protected IStatus run(IProgressMonitor monitor) {
                    monitor.beginTask("Update", 2);
                    try {
                        if (SpacecraftSwathWorldWindLayerCustomImpl.this.getOrbitModel() != null && SpacecraftSwathWorldWindLayerCustomImpl.this.getTimeSource() != null && SpacecraftSwathWorldWindLayerCustomImpl.this.isVisible()) {
                            Material interiorMat;
                            Iterator outlineMat;
                            BasicShapeAttributes attributes;
                            List<ExtrudedPolygon> polygons;
                            List<Polyline> centerPolylines;
                            ArrayList<GeographicCoordinates> center;
                            SpacecraftSwathCorridor spacecraftSwathCorridor;
                            Date endDate;
                            Date startDate;
                            long duration;
                            if (SpacecraftSwathWorldWindLayerCustomImpl.this.getBackwardPropagationDuration() > 0.0) {
                                SpacecraftSwathWorldWindLayerCustomImpl.this.setBackwardSpacecraftSwathCorridor(null);
                                duration = Math.round(SpacecraftSwathWorldWindLayerCustomImpl.this.getBackwardPropagationDuration() * 1000.0);
                                startDate = new Date(SpacecraftSwathWorldWindLayerCustomImpl.this.getTimeSource().getTime().getTime() - duration);
                                endDate = SpacecraftSwathWorldWindLayerCustomImpl.this.getTimeSource().getTime();
                                spacecraftSwathCorridor = ApogyCoreEnvironmentEarthOrbitFactory.eINSTANCE.createSpacecraftSwathCorridor();
                                spacecraftSwathCorridor.setStartTime(startDate);
                                spacecraftSwathCorridor.setEndTime(endDate);
                                spacecraftSwathCorridor.setOrbitModel((OrbitModel)SpacecraftSwathWorldWindLayerCustomImpl.this.getOrbitModel());
                                spacecraftSwathCorridor.setTimeInterval(SpacecraftSwathWorldWindLayerCustomImpl.this.getTimeInterval());
                                spacecraftSwathCorridor.setLeftSwathAngle(SpacecraftSwathWorldWindLayerCustomImpl.this.getLeftSwathAngle());
                                spacecraftSwathCorridor.setRightSwathAngle(SpacecraftSwathWorldWindLayerCustomImpl.this.getRightSwathAngle());
                                spacecraftSwathCorridor.update();
                                if (SpacecraftSwathWorldWindLayerCustomImpl.this.isShowGroundTrace()) {
                                    center = new ArrayList<GeographicCoordinates>();
                                    for (CorridorPoint p : spacecraftSwathCorridor.getCorridor().getPoints()) {
                                        center.add(p.getCenter());
                                    }
                                    centerPolylines = WorldWindOrbitUtils.createPolyLineFromGeographicCoordinatesListNoWrapAround(center, 66);
                                    for (Polyline line : centerPolylines) {
                                        line.setColor(Color.YELLOW);
                                        line.setFollowTerrain(true);
                                        line.setStippleFactor(1);
                                        line.setStipplePattern((short)255);
                                        layer.addRenderable((Renderable)line);
                                    }
                                }
                                polygons = WorldWindOrbitUtils.createExtrudedPolygons(spacecraftSwathCorridor.getCorridor(), 5000.0);
                                attributes = new BasicShapeAttributes();
                                attributes.setDrawOutline(false);
                                outlineMat = new Material(new Color(1.0f, 1.0f, 0.0f, 0.2f));
                                attributes.setOutlineMaterial((Material)outlineMat);
                                attributes.setOutlineOpacity(0.2);
                                interiorMat = new Material(new Color(1.0f, 1.0f, 0.0f, 0.2f));
                                attributes.setInteriorMaterial(interiorMat);
                                attributes.setInteriorOpacity((double)0.2f);
                                for (ExtrudedPolygon polygon : polygons) {
                                    polygon.setAttributes((ShapeAttributes)attributes);
                                    layer.addRenderable((Renderable)polygon);
                                }
                                SpacecraftSwathWorldWindLayerCustomImpl.this.setBackwardSpacecraftSwathCorridor(spacecraftSwathCorridor);
                            }
                            monitor.worked(1);
                            if (SpacecraftSwathWorldWindLayerCustomImpl.this.getForwardPropagationDuration() > 0.0) {
                                SpacecraftSwathWorldWindLayerCustomImpl.this.setForwardSpacecraftSwathCorridor(null);
                                duration = Math.round(SpacecraftSwathWorldWindLayerCustomImpl.this.getForwardPropagationDuration() * 1000.0);
                                startDate = SpacecraftSwathWorldWindLayerCustomImpl.this.getTimeSource().getTime();
                                endDate = new Date(SpacecraftSwathWorldWindLayerCustomImpl.this.getTimeSource().getTime().getTime() + duration);
                                spacecraftSwathCorridor = ApogyCoreEnvironmentEarthOrbitFactory.eINSTANCE.createSpacecraftSwathCorridor();
                                spacecraftSwathCorridor.setStartTime(startDate);
                                spacecraftSwathCorridor.setEndTime(endDate);
                                spacecraftSwathCorridor.setOrbitModel((OrbitModel)SpacecraftSwathWorldWindLayerCustomImpl.this.getOrbitModel());
                                spacecraftSwathCorridor.setTimeInterval(SpacecraftSwathWorldWindLayerCustomImpl.this.getTimeInterval());
                                spacecraftSwathCorridor.setLeftSwathAngle(SpacecraftSwathWorldWindLayerCustomImpl.this.getLeftSwathAngle());
                                spacecraftSwathCorridor.setRightSwathAngle(SpacecraftSwathWorldWindLayerCustomImpl.this.getRightSwathAngle());
                                spacecraftSwathCorridor.update();
                                if (SpacecraftSwathWorldWindLayerCustomImpl.this.isShowGroundTrace()) {
                                    center = new ArrayList();
                                    for (CorridorPoint p : spacecraftSwathCorridor.getCorridor().getPoints()) {
                                        center.add(p.getCenter());
                                    }
                                    centerPolylines = WorldWindOrbitUtils.createPolyLineFromGeographicCoordinatesListNoWrapAround(center, 66);
                                    for (Polyline line : centerPolylines) {
                                        line.setColor(Color.RED);
                                        line.setFollowTerrain(true);
                                        line.setStippleFactor(1);
                                        line.setStipplePattern((short)255);
                                        layer.addRenderable((Renderable)line);
                                        layer.addRenderable((Renderable)line);
                                    }
                                }
                                polygons = WorldWindOrbitUtils.createExtrudedPolygons(spacecraftSwathCorridor.getCorridor(), 5000.0);
                                attributes = new BasicShapeAttributes();
                                attributes.setDrawOutline(false);
                                outlineMat = new Material(new Color(1.0f, 0.0f, 0.0f, 0.2f));
                                attributes.setOutlineMaterial((Material)outlineMat);
                                attributes.setOutlineOpacity((double)0.2f);
                                interiorMat = new Material(new Color(1.0f, 0.0f, 0.0f, 0.2f));
                                attributes.setInteriorMaterial(interiorMat);
                                attributes.setInteriorOpacity((double)0.2f);
                                for (ExtrudedPolygon polygon : polygons) {
                                    polygon.setAttributes((ShapeAttributes)attributes);
                                    layer.addRenderable((Renderable)polygon);
                                }
                                SpacecraftSwathWorldWindLayerCustomImpl.this.setForwardSpacecraftSwathCorridor(spacecraftSwathCorridor);
                            }
                            monitor.worked(1);
                            monitor.done();
                        }
                    }
                    catch (Exception e) {
                        Logger.error(e.getMessage(), (Throwable)e);
                    }
                    SpacecraftSwathWorldWindLayerCustomImpl.this.getRenderableLayer().firePropertyChange("gov.nasa.worldwind.avkey.LayerObject", null, (Object)this);
                    ApogyCommonTransactionFacade.INSTANCE.basicSet((EObject)SpacecraftSwathWorldWindLayerCustomImpl.this, (EStructuralFeature)ApogyCorePackage.Literals.UPDATABLE__UPDATING, (Object)false);
                    return Status.OK_STATUS;
                }
            };
            job.schedule();
        }
    }

    protected Adapter getTimedAdapter() {
        if (this.timedAdapter == null) {
            this.timedAdapter = new AdapterImpl(){

                public void notifyChanged(Notification msg) {
                    if (msg.getNotifier() instanceof Timed) {
                        int featureId = msg.getFeatureID(Timed.class);
                        switch (featureId) {
                            case 0: {
                                if (!SpacecraftSwathWorldWindLayerCustomImpl.this.isAutoUpdateEnabled()) break;
                                SpacecraftSwathWorldWindLayerCustomImpl.this.updateRenderableLayer();
                                break;
                            }
                        }
                    }
                }
            };
        }
        return this.timedAdapter;
    }
}

