/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.core.environment.earth.orbit.ui.impl;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.apogy.common.emf.ApogyCommonEMFFacade;
import org.eclipse.apogy.common.emf.ApogyCommonTransactionFacade;
import org.eclipse.apogy.core.environment.earth.orbit.VisibilityPass;
import org.eclipse.apogy.core.environment.earth.orbit.ui.ApogyCoreEnvironmentEarthOrbitUIFactory;
import org.eclipse.apogy.core.environment.earth.orbit.ui.VisibilityPassWorldWindLayer;
import org.eclipse.apogy.core.environment.earth.orbit.ui.impl.SelectedVisibilityPassesWorldWindLayerImpl;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.swt.graphics.RGBA;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SelectedVisibilityPassesWorldWindLayerCustomImpl
extends SelectedVisibilityPassesWorldWindLayerImpl {
    private static final Logger Logger = LoggerFactory.getLogger(SelectedVisibilityPassesWorldWindLayerCustomImpl.class);
    private boolean busy = false;

    @Override
    public void selectionChanged(final List<EObject> items) {
        if (!(this.isLockSelection() || this.isUpdating() || this.busy)) {
            this.busy = true;
            TransactionalEditingDomain transactionalEditingDomain = ApogyCommonTransactionFacade.INSTANCE.getTransactionalEditingDomain((EObject)this);
            RecordingCommand cmd = new RecordingCommand(transactionalEditingDomain){

                protected void doExecute() {
                    try {
                        SelectedVisibilityPassesWorldWindLayerCustomImpl.this.setUpdating(true);
                        ArrayList<VisibilityPass> passes = new ArrayList<VisibilityPass>();
                        for (EObject eObject : items) {
                            if (!(eObject instanceof VisibilityPass)) continue;
                            passes.add((VisibilityPass)eObject);
                        }
                        Logger.info("Selected <" + passes.size() + "> Visibility Passe(s).");
                        if (passes.size() > 0 || SelectedVisibilityPassesWorldWindLayerCustomImpl.this.isAllowZeroSizeSelection()) {
                            SelectedVisibilityPassesWorldWindLayerCustomImpl.this.getVisibilityPassWorldWindLayers().clear();
                            SelectedVisibilityPassesWorldWindLayerCustomImpl.this.getLayers().clear();
                            ArrayList<VisibilityPassWorldWindLayer> layers = new ArrayList<VisibilityPassWorldWindLayer>();
                            for (VisibilityPass visibilityPass : passes) {
                                if (visibilityPass == null) continue;
                                VisibilityPassWorldWindLayer layer = SelectedVisibilityPassesWorldWindLayerCustomImpl.this.createVisibilityPassWorldWindLayer(visibilityPass);
                                layers.add(layer);
                            }
                            SelectedVisibilityPassesWorldWindLayerCustomImpl.this.getVisibilityPassWorldWindLayers().addAll(layers);
                            SelectedVisibilityPassesWorldWindLayerCustomImpl.this.getLayers().addAll(layers);
                        }
                        SelectedVisibilityPassesWorldWindLayerCustomImpl.this.setUpdating(false);
                    }
                    catch (Exception e) {
                        Logger.error("Selection changed failed !", (Throwable)e);
                    }
                    SelectedVisibilityPassesWorldWindLayerCustomImpl.this.busy = false;
                }
            };
            try {
                transactionalEditingDomain.getCommandStack().execute((Command)cmd);
            }
            catch (Throwable throwable) {}
        }
    }

    @Override
    public void setColor(RGBA newColor) {
        super.setColor(newColor);
        for (VisibilityPassWorldWindLayer layer : this.getVisibilityPassWorldWindLayers()) {
            layer.setColor(newColor);
        }
    }

    @Override
    public void setDrawFillLines(boolean newDrawFillLines) {
        super.setDrawFillLines(newDrawFillLines);
        for (VisibilityPassWorldWindLayer layer : this.getVisibilityPassWorldWindLayers()) {
            layer.setDrawFillLines(newDrawFillLines);
        }
    }

    protected void updateRenderableLayer() {
    }

    protected VisibilityPassWorldWindLayer createVisibilityPassWorldWindLayer(VisibilityPass visibilityPass) {
        VisibilityPassWorldWindLayer layer = ApogyCoreEnvironmentEarthOrbitUIFactory.eINSTANCE.createVisibilityPassWorldWindLayer();
        String passName = String.valueOf(visibilityPass.getOutlook().getName()) + " - " + ApogyCommonEMFFacade.INSTANCE.format(visibilityPass.getFromDate());
        layer.setAutoUpdateEnabled(true);
        layer.setVisibilityPass(visibilityPass);
        layer.setName(passName);
        layer.setVisible(true);
        layer.setDrawFillLines(this.isDrawFillLines());
        layer.setColor(this.getColor());
        layer.setDescription("Layer representing visibility pass for <" + visibilityPass.getOutlook().getName() + ">.");
        return layer;
    }
}

