/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.core.environment.earth.orbit.ui.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.apogy.common.emf.ApogyCommonEMFFacade;
import org.eclipse.apogy.common.emf.ApogyCommonEMFFactory;
import org.eclipse.apogy.common.emf.TimeInterval;
import org.eclipse.apogy.core.environment.earth.orbit.ApogyCoreEnvironmentEarthOrbitFacade;
import org.eclipse.apogy.core.environment.earth.orbit.EarthSpacecraft;
import org.eclipse.apogy.core.environment.earth.orbit.Eclipse;
import org.eclipse.apogy.core.environment.earth.orbit.OrbitAnalysisData;
import org.eclipse.apogy.core.environment.earth.orbit.OrbitAnalysisDataSet;
import org.eclipse.apogy.core.environment.earth.orbit.ui.AllVisibilityPassesWorldWindLayer;
import org.eclipse.apogy.core.environment.earth.orbit.ui.ApogyCoreEnvironmentEarthOrbitUIFactory;
import org.eclipse.apogy.core.environment.earth.orbit.ui.EclipsesWorldWindLayer;
import org.eclipse.apogy.core.environment.earth.orbit.ui.OrbitAnalysisDataSetWorldWindLayer;
import org.eclipse.apogy.core.environment.earth.orbit.ui.SpacecraftOrbitAnalysisWorldWindLayer;
import org.eclipse.apogy.core.environment.earth.orbit.ui.SpacecraftOrbitSegmentsWorldWindLayer;
import org.eclipse.apogy.core.environment.earth.orbit.ui.impl.ApogyCoreEnvironmentEarthOrbitUIFacadeImpl;

public class ApogyCoreEnvironmentEarthOrbitUIFacadeCustomImpl
extends ApogyCoreEnvironmentEarthOrbitUIFacadeImpl {
    @Override
    public SpacecraftOrbitAnalysisWorldWindLayer createSpacecraftOrbitAnalysisWorldWindLayer(OrbitAnalysisData orbitAnalysisData, EarthSpacecraft spacecraft) {
        SpacecraftOrbitAnalysisWorldWindLayer layer = ApogyCoreEnvironmentEarthOrbitUIFactory.eINSTANCE.createSpacecraftOrbitAnalysisWorldWindLayer();
        SpacecraftOrbitSegmentsWorldWindLayer orbitLayer = ApogyCoreEnvironmentEarthOrbitUIFactory.eINSTANCE.createSpacecraftOrbitSegmentsWorldWindLayer();
        orbitLayer.setAutoUpdateEnabled(true);
        orbitLayer.setSpacecraft(spacecraft);
        if (spacecraft != null) {
            orbitLayer.setName(spacecraft.getName());
            orbitLayer.setDescription("Orbit Trajectory for spacecraft <" + spacecraft.getName() + ">.");
        }
        EclipsesWorldWindLayer eclipsesLayer = ApogyCoreEnvironmentEarthOrbitUIFactory.eINSTANCE.createEclipsesWorldWindLayer();
        eclipsesLayer.setAutoUpdateEnabled(true);
        eclipsesLayer.setSpacecraft(spacecraft);
        if (spacecraft != null) {
            eclipsesLayer.setName(spacecraft.getName());
            eclipsesLayer.setDescription("Eclipse for spacecraft <" + spacecraft.getName() + ">.");
        }
        if (orbitAnalysisData != null && orbitAnalysisData.getResult() != null) {
            orbitLayer.setSpacecraftOrbitHistory(ApogyCoreEnvironmentEarthOrbitFacade.INSTANCE.getApplicableEarthSpacecraftOrbitHistory((Collection)orbitAnalysisData.getResult().getSpacecraftTrajectories(), spacecraft));
            ArrayList<TimeInterval> eclipseIntervals = new ArrayList<TimeInterval>();
            List eclipses = ApogyCoreEnvironmentEarthOrbitFacade.INSTANCE.getApplicableEclipse((Collection)orbitAnalysisData.getResult().getEclipses(), spacecraft);
            for (Eclipse eclipse : eclipses) {
                TimeInterval umbraInterval = ApogyCommonEMFFactory.eINSTANCE.createTimeInterval();
                TimeInterval penumbraEntryInterval = ApogyCommonEMFFactory.eINSTANCE.createTimeInterval();
                TimeInterval penumbraExitInterval = ApogyCommonEMFFactory.eINSTANCE.createTimeInterval();
                ApogyCoreEnvironmentEarthOrbitFacade.INSTANCE.getEclipseIntervals(eclipse, orbitAnalysisData.getFromDate(), orbitAnalysisData.getToDate(), umbraInterval, penumbraEntryInterval, penumbraExitInterval);
                if (umbraInterval.getFromDate() != null && umbraInterval.getToDate() != null) {
                    eclipseIntervals.add(umbraInterval);
                }
                if (penumbraEntryInterval.getFromDate() != null && penumbraEntryInterval.getToDate() != null) {
                    eclipseIntervals.add(penumbraEntryInterval);
                }
                if (penumbraExitInterval.getFromDate() == null || penumbraExitInterval.getToDate() == null) continue;
                eclipseIntervals.add(penumbraExitInterval);
            }
            TimeInterval dataTimeInterval = ApogyCommonEMFFactory.eINSTANCE.createTimeInterval();
            dataTimeInterval.setFromDate(orbitAnalysisData.getFromDate());
            dataTimeInterval.setToDate(orbitAnalysisData.getToDate());
            List orbitSegmentsIntervals = ApogyCommonEMFFacade.INSTANCE.getTimeIntervalInterstices(dataTimeInterval, eclipseIntervals);
            orbitLayer.getIntervalsToShow().addAll((Collection)orbitSegmentsIntervals);
            eclipsesLayer.getEclipses().addAll((Collection)orbitAnalysisData.getResult().getEclipses());
            eclipsesLayer.setSpacecraftOrbitHistory(ApogyCoreEnvironmentEarthOrbitFacade.INSTANCE.getApplicableEarthSpacecraftOrbitHistory((Collection)orbitAnalysisData.getResult().getSpacecraftTrajectories(), spacecraft));
            eclipsesLayer.setVisible(true);
        }
        layer.getLayers().add((Object)orbitLayer);
        layer.setSpacecraftOrbitLayer(orbitLayer);
        layer.getLayers().add((Object)eclipsesLayer);
        layer.setEclipseWorldWindLayer(eclipsesLayer);
        return layer;
    }

    @Override
    public AllVisibilityPassesWorldWindLayer createAllVisibilityPassesWorldWindLayer(OrbitAnalysisData orbitAnalysisData, EarthSpacecraft spacecraft) {
        AllVisibilityPassesWorldWindLayer layer = ApogyCoreEnvironmentEarthOrbitUIFactory.eINSTANCE.createAllVisibilityPassesWorldWindLayer();
        layer.setAutoUpdateEnabled(true);
        layer.setVisible(true);
        layer.setShowGroundStationPasses(false);
        layer.setShowObservationTargetPasses(true);
        layer.setOrbitAnalysisData(orbitAnalysisData);
        layer.setSpacecraft(spacecraft);
        if (spacecraft != null) {
            layer.setName(spacecraft.getName());
            layer.setDescription("Layer representing passes for spacecraft <" + spacecraft.getName() + ">.");
        }
        return layer;
    }

    @Override
    public OrbitAnalysisDataSetWorldWindLayer createOrbitAnalysisDataSetWorldWindLayer(OrbitAnalysisDataSet orbitAnalysisDataSet) {
        OrbitAnalysisDataSetWorldWindLayer layer = ApogyCoreEnvironmentEarthOrbitUIFactory.eINSTANCE.createOrbitAnalysisDataSetWorldWindLayer();
        layer.setAutoUpdateEnabled(true);
        layer.setVisible(true);
        layer.setOrbitAnalysisDataSet(orbitAnalysisDataSet);
        return layer;
    }
}

