/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.core.environment.earth.orbit.ui.composites;

import javax.measure.unit.Unit;
import org.eclipse.apogy.common.emf.ui.ApogyCommonEMFUIFacade;
import org.eclipse.apogy.common.emf.ui.ECollectionCompositeSettings;
import org.eclipse.apogy.common.emf.ui.emfforms.composites.EMFFormsEListComposite;
import org.eclipse.apogy.core.environment.earth.ApogyCoreEnvironmentEarthPackage;
import org.eclipse.apogy.core.environment.earth.EarthOutlook;
import org.eclipse.emf.databinding.FeaturePath;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.ETypedElement;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.TreeViewerColumn;
import org.eclipse.swt.widgets.Composite;

public class EarthOutlookListComposite<RootEObject extends EObject, ResolvedEObject extends EObject, ItemEObject extends EarthOutlook>
extends EMFFormsEListComposite<RootEObject, ResolvedEObject, ItemEObject> {
    private static final int NAME_COL_MIN_WIDTH = 150;
    private static final int LONGITUDE_COL_MIN_WIDTH = 100;
    private static final int LATITUDE_COL_MIN_WIDTH = 100;
    private static final int ELEVATION_COL_MIN_WIDTH = 100;

    public EarthOutlookListComposite(Composite parent, int style, FeaturePath featurePath, EStructuralFeature eStructuralFeature, ECollectionCompositeSettings settings) {
        super(parent, style, featurePath, eStructuralFeature, settings);
    }

    protected void createColumns(TreeViewer viewer) {
        TreeViewerColumn nameColumn = new TreeViewerColumn(viewer, 0);
        nameColumn.getColumn().setText("Name");
        nameColumn.getColumn().setAlignment(0x1000000);
        nameColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                EarthOutlook outlook = (EarthOutlook)element;
                String text = outlook.getName();
                return text == null || text.length() == 0 ? "" : text;
            }
        });
        nameColumn.getColumn().setData("TREE_COLUMN_MIN_WIDTH", (Object)150);
        Unit longitudeDisplayedUnits = ApogyCommonEMFUIFacade.INSTANCE.getDisplayUnits((ETypedElement)ApogyCoreEnvironmentEarthPackage.Literals.GEOGRAPHIC_COORDINATES__LONGITUDE);
        TreeViewerColumn longitudeViewerColumn = new TreeViewerColumn(viewer, 0);
        longitudeViewerColumn.getColumn().setText("Longitude (" + longitudeDisplayedUnits.toString() + ")");
        longitudeViewerColumn.getColumn().setAlignment(0x1000000);
        longitudeViewerColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                EarthOutlook outlook = (EarthOutlook)element;
                return ApogyCommonEMFUIFacade.INSTANCE.getDisplayedString((Number)outlook.getLongitude(), (ETypedElement)ApogyCoreEnvironmentEarthPackage.Literals.GEOGRAPHIC_COORDINATES__LONGITUDE);
            }
        });
        longitudeViewerColumn.getColumn().setData("TREE_COLUMN_MIN_WIDTH", (Object)100);
        Unit latitudeDisplayedUnits = ApogyCommonEMFUIFacade.INSTANCE.getDisplayUnits((ETypedElement)ApogyCoreEnvironmentEarthPackage.Literals.GEOGRAPHIC_COORDINATES__LATITUDE);
        TreeViewerColumn latitudeViewerColumn = new TreeViewerColumn(viewer, 0);
        latitudeViewerColumn.getColumn().setText("Latitude (" + latitudeDisplayedUnits.toString() + ")");
        latitudeViewerColumn.getColumn().setAlignment(0x1000000);
        latitudeViewerColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                EarthOutlook outlook = (EarthOutlook)element;
                return ApogyCommonEMFUIFacade.INSTANCE.getDisplayedString((Number)outlook.getLatitude(), (ETypedElement)ApogyCoreEnvironmentEarthPackage.Literals.GEOGRAPHIC_COORDINATES__LATITUDE);
            }
        });
        latitudeViewerColumn.getColumn().setData("TREE_COLUMN_MIN_WIDTH", (Object)100);
        Unit elevationDisplayedUnits = ApogyCommonEMFUIFacade.INSTANCE.getDisplayUnits((ETypedElement)ApogyCoreEnvironmentEarthPackage.Literals.GEOGRAPHIC_COORDINATES__ELEVATION);
        TreeViewerColumn elevationTableViewerColumn = new TreeViewerColumn(viewer, 0);
        elevationTableViewerColumn.getColumn().setText("Elevation (" + elevationDisplayedUnits.toString() + ")");
        elevationTableViewerColumn.getColumn().setAlignment(0x1000000);
        elevationTableViewerColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                EarthOutlook outlook = (EarthOutlook)element;
                return ApogyCommonEMFUIFacade.INSTANCE.getDisplayedString((Number)outlook.getElevation(), (ETypedElement)ApogyCoreEnvironmentEarthPackage.Literals.GEOGRAPHIC_COORDINATES__ELEVATION);
            }
        });
        elevationTableViewerColumn.getColumn().setData("TREE_COLUMN_MIN_WIDTH", (Object)100);
    }

    protected void createButtons(Composite parent, int style) {
        this.createNewButton(parent, style);
        this.createDeleteButton(parent, style);
        this.createCopyButton(parent, style);
        this.createSeparator(parent, style);
        this.createUpButton(parent, style);
        this.createDownButton(parent, style);
    }
}

