/*
 * Decompiled with CFR 0.152.
 */
package org.ros.time;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.net.ntp.NTPUDPClient;
import org.apache.commons.net.ntp.TimeInfo;
import org.ros.math.CollectionMath;
import org.ros.message.Duration;
import org.ros.message.Time;
import org.ros.time.TimeProvider;
import org.ros.time.WallTimeProvider;

public class NtpTimeProvider
implements TimeProvider {
    private static final boolean DEBUG = false;
    private static final Log log = LogFactory.getLog(NtpTimeProvider.class);
    private static final int SAMPLE_SIZE = 11;
    private final InetAddress host;
    private final ScheduledExecutorService scheduledExecutorService;
    private final WallTimeProvider wallTimeProvider;
    private final NTPUDPClient ntpClient;
    private long offset;
    private ScheduledFuture<?> scheduledFuture;

    public NtpTimeProvider(InetAddress host, ScheduledExecutorService scheduledExecutorService) {
        this.host = host;
        this.scheduledExecutorService = scheduledExecutorService;
        this.wallTimeProvider = new WallTimeProvider();
        this.ntpClient = new NTPUDPClient();
        this.ntpClient.setDefaultTimeout(500);
        this.offset = 0L;
        this.scheduledFuture = null;
    }

    public void updateTime() throws IOException {
        ArrayList offsets = Lists.newArrayList();
        int failures = 0;
        int i = 0;
        while (i < 11) {
            block3: {
                try {
                    offsets.add(this.computeOffset());
                }
                catch (IOException e) {
                    if (++failures <= 5) break block3;
                    throw e;
                }
            }
            ++i;
        }
        this.offset = (Long)CollectionMath.median(offsets);
        log.info((Object)String.format("NTP time offset: %d ms", this.offset));
    }

    private long computeOffset() throws IOException {
        TimeInfo time;
        try {
            time = this.ntpClient.getTime(this.host);
        }
        catch (IOException e) {
            log.error((Object)("Failed to read time from NTP server: " + this.host.getHostName()), (Throwable)e);
            throw e;
        }
        time.computeDetails();
        return time.getOffset();
    }

    public void startPeriodicUpdates(long period, TimeUnit unit) {
        this.scheduledFuture = this.scheduledExecutorService.scheduleAtFixedRate(new Runnable(){

            @Override
            public void run() {
                try {
                    NtpTimeProvider.this.updateTime();
                }
                catch (IOException e) {
                    log.error((Object)"Periodic NTP update failed.", (Throwable)e);
                }
            }
        }, 0L, period, unit);
    }

    public void stopPeriodicUpdates() {
        Preconditions.checkNotNull(this.scheduledFuture);
        this.scheduledFuture.cancel(true);
        this.scheduledFuture = null;
    }

    @Override
    public Time getCurrentTime() {
        Time currentTime = this.wallTimeProvider.getCurrentTime();
        return currentTime.add(Duration.fromMillis((long)this.offset));
    }
}

