/*
 * Decompiled with CFR 0.152.
 */
package org.ros.node;

import com.google.common.base.Preconditions;
import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.ScheduledExecutorService;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.ros.concurrent.DefaultScheduledExecutorService;
import org.ros.namespace.GraphName;
import org.ros.node.ConnectedNode;
import org.ros.node.DefaultNodeFactory;
import org.ros.node.Node;
import org.ros.node.NodeConfiguration;
import org.ros.node.NodeFactory;
import org.ros.node.NodeListener;
import org.ros.node.NodeMain;
import org.ros.node.NodeMainExecutor;

public class DefaultNodeMainExecutor
implements NodeMainExecutor {
    private static final boolean DEBUG = false;
    private static final Log log = LogFactory.getLog(DefaultNodeMainExecutor.class);
    private final NodeFactory nodeFactory;
    private final ScheduledExecutorService scheduledExecutorService;
    private final Multimap<GraphName, ConnectedNode> connectedNodes;
    private final BiMap<Node, NodeMain> nodeMains;

    public static NodeMainExecutor newDefault() {
        return DefaultNodeMainExecutor.newDefault(new DefaultScheduledExecutorService());
    }

    public static NodeMainExecutor newDefault(ScheduledExecutorService executorService) {
        return new DefaultNodeMainExecutor(new DefaultNodeFactory(executorService), executorService);
    }

    private DefaultNodeMainExecutor(NodeFactory nodeFactory, ScheduledExecutorService scheduledExecutorService) {
        this.nodeFactory = nodeFactory;
        this.scheduledExecutorService = scheduledExecutorService;
        this.connectedNodes = Multimaps.synchronizedMultimap((Multimap)HashMultimap.create());
        this.nodeMains = Maps.synchronizedBiMap((BiMap)HashBiMap.create());
        Runtime.getRuntime().addShutdownHook(new Thread(new Runnable(){

            @Override
            public void run() {
                DefaultNodeMainExecutor.this.shutdown();
            }
        }));
    }

    @Override
    public ScheduledExecutorService getScheduledExecutorService() {
        return this.scheduledExecutorService;
    }

    @Override
    public void execute(final NodeMain nodeMain, NodeConfiguration nodeConfiguration, final Collection<NodeListener> nodeListeners) {
        final NodeConfiguration nodeConfigurationCopy = NodeConfiguration.copyOf(nodeConfiguration);
        nodeConfigurationCopy.setDefaultNodeName(nodeMain.getDefaultNodeName());
        Preconditions.checkNotNull((Object)nodeConfigurationCopy.getNodeName(), (Object)"Node name not specified.");
        this.scheduledExecutorService.execute(new Runnable(){

            @Override
            public void run() {
                ArrayList nodeListenersCopy = Lists.newArrayList();
                nodeListenersCopy.add(new RegistrationListener());
                nodeListenersCopy.add(nodeMain);
                if (nodeListeners != null) {
                    nodeListenersCopy.addAll(nodeListeners);
                }
                Node node = DefaultNodeMainExecutor.this.nodeFactory.newNode(nodeConfigurationCopy, nodeListenersCopy);
                DefaultNodeMainExecutor.this.nodeMains.put((Object)node, (Object)nodeMain);
            }
        });
    }

    @Override
    public void execute(NodeMain nodeMain, NodeConfiguration nodeConfiguration) {
        this.execute(nodeMain, nodeConfiguration, null);
    }

    @Override
    public void shutdownNodeMain(NodeMain nodeMain) {
        Node node = (Node)this.nodeMains.inverse().get((Object)nodeMain);
        if (node != null) {
            this.safelyShutdownNode(node);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void shutdown() {
        Multimap<GraphName, ConnectedNode> multimap = this.connectedNodes;
        synchronized (multimap) {
            for (ConnectedNode connectedNode : this.connectedNodes.values()) {
                this.safelyShutdownNode(connectedNode);
            }
        }
    }

    private void safelyShutdownNode(Node node) {
        boolean success = true;
        try {
            node.shutdown();
        }
        catch (Exception e) {
            log.error((Object)"Exception thrown while shutting down node.", (Throwable)e);
            this.unregisterNode(node);
            success = false;
        }
        if (success) {
            log.info((Object)"Shutdown successful.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void registerNode(ConnectedNode connectedNode) {
        GraphName nodeName = connectedNode.getName();
        Multimap<GraphName, ConnectedNode> multimap = this.connectedNodes;
        synchronized (multimap) {
            for (ConnectedNode illegalConnectedNode : this.connectedNodes.get((Object)nodeName)) {
                System.err.println(String.format("Node name collision. Existing node %s (%s) will be shutdown.", nodeName, illegalConnectedNode.getUri()));
                illegalConnectedNode.shutdown();
            }
            this.connectedNodes.put((Object)nodeName, (Object)connectedNode);
        }
    }

    private void unregisterNode(Node node) {
        node.removeListeners();
        this.connectedNodes.get((Object)node.getName()).remove(node);
        this.nodeMains.remove((Object)node);
    }

    private class RegistrationListener
    implements NodeListener {
        private RegistrationListener() {
        }

        @Override
        public void onStart(ConnectedNode connectedNode) {
            DefaultNodeMainExecutor.this.registerNode(connectedNode);
        }

        @Override
        public void onShutdown(Node node) {
        }

        @Override
        public void onShutdownComplete(Node node) {
            DefaultNodeMainExecutor.this.unregisterNode(node);
        }

        @Override
        public void onError(Node node, Throwable throwable) {
            log.error((Object)"Node error.", throwable);
            DefaultNodeMainExecutor.this.unregisterNode(node);
        }
    }
}

