/*
 * Decompiled with CFR 0.152.
 */
package org.ros.namespace;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.ros.exception.RosRuntimeException;
import org.ros.namespace.GraphName;

public class NameResolver {
    private final GraphName namespace;
    private final Map<GraphName, GraphName> remappings;

    public static NameResolver newFromNamespace(GraphName namespace) {
        return new NameResolver(namespace, new HashMap<GraphName, GraphName>());
    }

    public static NameResolver newFromNamespace(String namespace) {
        return NameResolver.newFromNamespace(GraphName.of(namespace));
    }

    public static NameResolver newRoot() {
        return NameResolver.newFromNamespace(GraphName.root());
    }

    public static NameResolver newRootFromRemappings(Map<GraphName, GraphName> remappings) {
        return new NameResolver(GraphName.root(), remappings);
    }

    public static NameResolver newFromNamespaceAndRemappings(String namespace, Map<GraphName, GraphName> remappings) {
        return new NameResolver(GraphName.of(namespace), remappings);
    }

    public NameResolver(GraphName namespace, Map<GraphName, GraphName> remappings) {
        this.remappings = Collections.unmodifiableMap(remappings);
        this.namespace = namespace;
    }

    public GraphName getNamespace() {
        return this.namespace;
    }

    public GraphName resolve(GraphName namespace, GraphName name) {
        GraphName remappedNamespace = this.lookUpRemapping(namespace);
        if (!remappedNamespace.isGlobal()) {
            throw new IllegalArgumentException(String.format("Namespace %s (remapped from %s) must be global.", remappedNamespace, namespace));
        }
        GraphName remappedName = this.lookUpRemapping(name);
        if (remappedName.isGlobal()) {
            return remappedName;
        }
        if (remappedName.isRelative()) {
            return remappedNamespace.join(remappedName);
        }
        if (remappedName.isPrivate()) {
            throw new RosRuntimeException("Cannot resolve ~private names in arbitrary namespaces.");
        }
        throw new RosRuntimeException("Unable to resolve graph name: " + name);
    }

    public GraphName resolve(String namespace, String name) {
        return this.resolve(GraphName.of(namespace), GraphName.of(name));
    }

    public GraphName resolve(GraphName namespace, String name) {
        return this.resolve(namespace, GraphName.of(name));
    }

    public GraphName resolve(String namespace, GraphName name) {
        return this.resolve(GraphName.of(namespace), name);
    }

    public GraphName resolve(GraphName name) {
        return this.resolve(this.namespace, name);
    }

    public GraphName resolve(String name) {
        return this.resolve(GraphName.of(name));
    }

    public Map<GraphName, GraphName> getRemappings() {
        return this.remappings;
    }

    public NameResolver newChild(GraphName namespace) {
        return new NameResolver(this.resolve(namespace), this.remappings);
    }

    public NameResolver newChild(String namespace) {
        return this.newChild(GraphName.of(namespace));
    }

    protected GraphName lookUpRemapping(GraphName name) {
        GraphName remappedName = name;
        if (this.remappings.containsKey(name)) {
            remappedName = this.remappings.get(name);
        }
        return remappedName;
    }
}

