/*
 * Decompiled with CFR 0.152.
 */
package org.ros.master.client;

import java.net.URI;
import java.util.List;
import org.ros.internal.node.client.MasterClient;
import org.ros.internal.node.response.Response;
import org.ros.internal.node.topic.TopicDeclaration;
import org.ros.master.client.SystemState;
import org.ros.master.client.TopicType;
import org.ros.node.Node;

public class MasterStateClient {
    private final Node caller;
    private final MasterClient masterClient;

    public MasterStateClient(Node caller, URI masterUri) {
        this.caller = caller;
        this.masterClient = new MasterClient(masterUri);
    }

    public URI lookupNode(String nodeName) {
        Response<URI> response = this.masterClient.lookupNode(this.caller.getName(), nodeName);
        return response.getResult();
    }

    public URI getUri() {
        Response<URI> response = this.masterClient.getUri(this.caller.getName());
        return response.getResult();
    }

    public URI lookupService(String serviceName) {
        Response<URI> result = this.masterClient.lookupService(this.caller.getName(), serviceName);
        return result.getResult();
    }

    public List<TopicDeclaration> getPublishedTopics(String subgraph) {
        throw new UnsupportedOperationException();
    }

    public List<TopicType> getTopicTypes() {
        Response<List<TopicType>> result = this.masterClient.getTopicTypes(this.caller.getName());
        return result.getResult();
    }

    public SystemState getSystemState() {
        Response<SystemState> result = this.masterClient.getSystemState(this.caller.getName());
        return result.getResult();
    }
}

