/*
 * Decompiled with CFR 0.152.
 */
package org.ros.internal.transport.queue;

import com.google.common.annotations.VisibleForTesting;
import java.util.concurrent.ExecutorService;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.group.ChannelGroup;
import org.jboss.netty.channel.group.ChannelGroupFuture;
import org.jboss.netty.channel.group.ChannelGroupFutureListener;
import org.jboss.netty.channel.group.DefaultChannelGroup;
import org.ros.concurrent.CancellableLoop;
import org.ros.concurrent.CircularBlockingDeque;
import org.ros.internal.message.MessageBufferPool;
import org.ros.internal.message.MessageBuffers;
import org.ros.message.MessageSerializer;

public class OutgoingMessageQueue<T> {
    private static final boolean DEBUG = false;
    private static final Log log = LogFactory.getLog(OutgoingMessageQueue.class);
    private static final int DEQUE_CAPACITY = 16;
    private final MessageSerializer<T> serializer;
    private final CircularBlockingDeque<T> deque;
    private final ChannelGroup channelGroup;
    private final Writer writer;
    private final MessageBufferPool messageBufferPool;
    private final ChannelBuffer latchedBuffer;
    private final Object mutex;
    private boolean latchMode;
    private T latchedMessage;

    public OutgoingMessageQueue(MessageSerializer<T> serializer, ExecutorService executorService) {
        this.serializer = serializer;
        this.deque = new CircularBlockingDeque(16);
        this.channelGroup = new DefaultChannelGroup();
        this.writer = new Writer();
        this.messageBufferPool = new MessageBufferPool();
        this.latchedBuffer = MessageBuffers.dynamicBuffer();
        this.mutex = new Object();
        this.latchMode = false;
        executorService.execute(this.writer);
    }

    public void setLatchMode(boolean enabled) {
        this.latchMode = enabled;
    }

    public boolean getLatchMode() {
        return this.latchMode;
    }

    public void add(T message) {
        this.deque.addLast(message);
        this.setLatchedMessage(message);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setLatchedMessage(T message) {
        Object object = this.mutex;
        synchronized (object) {
            this.latchedMessage = message;
        }
    }

    public void shutdown() {
        this.writer.cancel();
        this.channelGroup.close().awaitUninterruptibly();
    }

    public void addChannel(Channel channel) {
        if (!this.writer.isRunning()) {
            log.warn((Object)"Failed to add channel. Cannot add channels after shutdown.");
            return;
        }
        if (this.latchMode && this.latchedMessage != null) {
            this.writeLatchedMessage(channel);
        }
        this.channelGroup.add((Object)channel);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeLatchedMessage(Channel channel) {
        Object object = this.mutex;
        synchronized (object) {
            this.latchedBuffer.clear();
            this.serializer.serialize(this.latchedMessage, this.latchedBuffer);
            channel.write((Object)this.latchedBuffer);
        }
    }

    public int getNumberOfChannels() {
        return this.channelGroup.size();
    }

    @VisibleForTesting
    public ChannelGroup getChannelGroup() {
        return this.channelGroup;
    }

    private final class Writer
    extends CancellableLoop {
        private Writer() {
        }

        @Override
        public void loop() throws InterruptedException {
            Object message = OutgoingMessageQueue.this.deque.takeFirst();
            final ChannelBuffer buffer = OutgoingMessageQueue.this.messageBufferPool.acquire();
            OutgoingMessageQueue.this.serializer.serialize(message, buffer);
            OutgoingMessageQueue.this.channelGroup.write((Object)buffer).addListener(new ChannelGroupFutureListener(){

                public void operationComplete(ChannelGroupFuture future) throws Exception {
                    OutgoingMessageQueue.this.messageBufferPool.release(buffer);
                }
            });
        }
    }
}

