/*
 * Decompiled with CFR 0.152.
 */
package org.ros.internal.transport.queue;

import java.util.concurrent.ExecutorService;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.ros.concurrent.CancellableLoop;
import org.ros.concurrent.CircularBlockingDeque;
import org.ros.concurrent.EventDispatcher;
import org.ros.concurrent.ListenerGroup;
import org.ros.concurrent.SignalRunnable;
import org.ros.internal.transport.queue.LazyMessage;
import org.ros.message.MessageListener;

public class MessageDispatcher<T>
extends CancellableLoop {
    private static final boolean DEBUG = false;
    private static final Log log = LogFactory.getLog(MessageDispatcher.class);
    private final CircularBlockingDeque<LazyMessage<T>> lazyMessages;
    private final ListenerGroup<MessageListener<T>> messageListeners;
    private final Object mutex;
    private boolean latchMode;
    private LazyMessage<T> latchedMessage;

    public MessageDispatcher(CircularBlockingDeque<LazyMessage<T>> lazyMessages, ExecutorService executorService) {
        this.lazyMessages = lazyMessages;
        this.messageListeners = new ListenerGroup(executorService);
        this.mutex = new Object();
        this.latchMode = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(MessageListener<T> messageListener, int limit) {
        Object object = this.mutex;
        synchronized (object) {
            EventDispatcher<MessageListener<MessageListener<T>>> eventDispatcher = this.messageListeners.add(messageListener, limit);
            if (this.latchMode && this.latchedMessage != null) {
                eventDispatcher.signal(this.newSignalRunnable(this.latchedMessage));
            }
        }
    }

    private SignalRunnable<MessageListener<T>> newSignalRunnable(final LazyMessage<T> lazyMessage) {
        return new SignalRunnable<MessageListener<T>>(){

            @Override
            public void run(MessageListener<T> messageListener) {
                messageListener.onNewMessage(lazyMessage.get());
            }
        };
    }

    public void setLatchMode(boolean enabled) {
        this.latchMode = enabled;
    }

    public boolean getLatchMode() {
        return this.latchMode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void loop() throws InterruptedException {
        LazyMessage<T> lazyMessage = this.lazyMessages.takeFirst();
        Object object = this.mutex;
        synchronized (object) {
            this.latchedMessage = lazyMessage;
            this.messageListeners.signal(this.newSignalRunnable(this.latchedMessage));
        }
    }

    @Override
    protected void handleInterruptedException(InterruptedException e) {
        this.messageListeners.shutdown();
    }
}

