/*
 * Decompiled with CFR 0.152.
 */
package org.ros.internal.node.xmlrpc;

import com.google.common.collect.Lists;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.ros.exception.RosRuntimeException;
import org.ros.internal.node.response.Response;
import org.ros.internal.node.server.NodeIdentifier;
import org.ros.internal.node.server.ParameterServer;
import org.ros.internal.node.server.master.MasterServer;
import org.ros.internal.node.xmlrpc.MasterXmlRpcEndpoint;
import org.ros.internal.node.xmlrpc.ParameterServerXmlRpcEndpoint;
import org.ros.namespace.GraphName;

public class MasterXmlRpcEndpointImpl
implements MasterXmlRpcEndpoint,
ParameterServerXmlRpcEndpoint {
    private final MasterServer master;
    private final ParameterServer parameterServer;

    public MasterXmlRpcEndpointImpl(MasterServer master) {
        this.master = master;
        this.parameterServer = new ParameterServer();
    }

    @Override
    public List<Object> getPid(String callerId) {
        return Response.newSuccess("server pid", this.master.getPid()).toList();
    }

    @Override
    public List<Object> getPublishedTopics(String callerId, String subgraph) {
        return Response.newSuccess("current topics", this.master.getPublishedTopics(GraphName.of(callerId), GraphName.of(subgraph))).toList();
    }

    @Override
    public List<Object> getTopicTypes(String callerId) {
        return Response.newSuccess("topic types", this.master.getTopicTypes(GraphName.of(callerId))).toList();
    }

    @Override
    public List<Object> getSystemState(String callerId) {
        return Response.newSuccess("current system state", this.master.getSystemState()).toList();
    }

    @Override
    public List<Object> getUri(String callerId) {
        return Response.newSuccess("Success", this.master.getUri().toString()).toList();
    }

    @Override
    public List<Object> lookupNode(String callerId, String nodeName) {
        URI nodeSlaveUri = this.master.lookupNode(GraphName.of(nodeName));
        if (nodeSlaveUri != null) {
            return Response.newSuccess("Success", nodeSlaveUri.toString()).toList();
        }
        return Response.newError("No such node", null).toList();
    }

    @Override
    public List<Object> registerPublisher(String callerId, String topicName, String topicMessageType, String callerSlaveUri) {
        try {
            List<URI> subscribers = this.master.registerPublisher(GraphName.of(callerId), new URI(callerSlaveUri), GraphName.of(topicName), topicMessageType);
            ArrayList urls = Lists.newArrayList();
            for (URI uri : subscribers) {
                urls.add(uri.toString());
            }
            return Response.newSuccess("Success", urls).toList();
        }
        catch (URISyntaxException e) {
            throw new RosRuntimeException(String.format("Improperly formatted URI %s for publisher", callerSlaveUri), e);
        }
    }

    @Override
    public List<Object> unregisterPublisher(String callerId, String topicName, String callerSlaveUri) {
        boolean result = this.master.unregisterPublisher(GraphName.of(callerId), GraphName.of(topicName));
        return Response.newSuccess("Success", result ? 1 : 0).toList();
    }

    @Override
    public List<Object> registerSubscriber(String callerId, String topicName, String topicMessageType, String callerSlaveUri) {
        try {
            List<URI> publishers = this.master.registerSubscriber(GraphName.of(callerId), new URI(callerSlaveUri), GraphName.of(topicName), topicMessageType);
            ArrayList urls = Lists.newArrayList();
            for (URI uri : publishers) {
                urls.add(uri.toString());
            }
            return Response.newSuccess("Success", urls).toList();
        }
        catch (URISyntaxException e) {
            throw new RosRuntimeException(String.format("Improperly formatted URI %s for subscriber", callerSlaveUri), e);
        }
    }

    @Override
    public List<Object> unregisterSubscriber(String callerId, String topicName, String callerSlaveUri) {
        boolean result = this.master.unregisterSubscriber(GraphName.of(callerId), GraphName.of(topicName));
        return Response.newSuccess("Success", result ? 1 : 0).toList();
    }

    @Override
    public List<Object> lookupService(String callerId, String serviceName) {
        URI slaveUri = this.master.lookupService(GraphName.of(serviceName));
        if (slaveUri != null) {
            return Response.newSuccess("Success", slaveUri.toString()).toList();
        }
        return Response.newError("No such service.", null).toList();
    }

    @Override
    public List<Object> registerService(String callerId, String serviceName, String serviceUri, String callerSlaveUri) {
        try {
            this.master.registerService(GraphName.of(callerId), new URI(callerSlaveUri), GraphName.of(serviceName), new URI(serviceUri));
            return Response.newSuccess("Success", 0).toList();
        }
        catch (URISyntaxException e) {
            throw new RosRuntimeException(e);
        }
    }

    @Override
    public List<Object> unregisterService(String callerId, String serviceName, String serviceUri) {
        try {
            boolean result = this.master.unregisterService(GraphName.of(callerId), GraphName.of(serviceName), new URI(serviceUri));
            return Response.newSuccess("Success", result ? 1 : 0).toList();
        }
        catch (URISyntaxException e) {
            throw new RosRuntimeException(e);
        }
    }

    @Override
    public List<Object> setParam(String callerId, String key, Boolean value) {
        this.parameterServer.set(GraphName.of(key), value);
        return Response.newSuccess("Success", null).toList();
    }

    @Override
    public List<Object> setParam(String callerId, String key, Integer value) {
        this.parameterServer.set(GraphName.of(key), value);
        return Response.newSuccess("Success", null).toList();
    }

    @Override
    public List<Object> setParam(String callerId, String key, Double value) {
        this.parameterServer.set(GraphName.of(key), value);
        return Response.newSuccess("Success", null).toList();
    }

    @Override
    public List<Object> setParam(String callerId, String key, String value) {
        this.parameterServer.set(GraphName.of(key), value);
        return Response.newSuccess("Success", null).toList();
    }

    @Override
    public List<Object> setParam(String callerId, String key, List<?> value) {
        this.parameterServer.set(GraphName.of(key), value);
        return Response.newSuccess("Success", null).toList();
    }

    @Override
    public List<Object> setParam(String callerId, String key, Map<?, ?> value) {
        this.parameterServer.set(GraphName.of(key), value);
        return Response.newSuccess("Success", null).toList();
    }

    @Override
    public List<Object> getParam(String callerId, String key) {
        Object value = this.parameterServer.get(GraphName.of(key));
        if (value == null) {
            return Response.newError("Parameter \"" + key + "\" is not set.", null).toList();
        }
        return Response.newSuccess("Success", value).toList();
    }

    @Override
    public List<Object> searchParam(String callerId, String key) {
        throw new UnsupportedOperationException();
    }

    @Override
    public List<Object> subscribeParam(String callerId, String callerSlaveUri, String key) {
        this.parameterServer.subscribe(GraphName.of(key), NodeIdentifier.forNameAndUri(callerId, callerSlaveUri));
        HashMap value = this.parameterServer.get(GraphName.of(key));
        if (value == null) {
            value = new HashMap();
        }
        return Response.newSuccess("Success", value).toList();
    }

    @Override
    public List<Object> unsubscribeParam(String callerId, String callerSlaveUri, String key) {
        throw new UnsupportedOperationException();
    }

    @Override
    public List<Object> deleteParam(String callerId, String key) {
        this.parameterServer.delete(GraphName.of(key));
        return Response.newSuccess("Success", null).toList();
    }

    @Override
    public List<Object> hasParam(String callerId, String key) {
        return Response.newSuccess("Success", this.parameterServer.has(GraphName.of(key))).toList();
    }

    @Override
    public List<Object> getParamNames(String callerId) {
        Collection<GraphName> names = this.parameterServer.getNames();
        ArrayList stringNames = Lists.newArrayList();
        for (GraphName name : names) {
            stringNames.add(name.toString());
        }
        return Response.newSuccess("Success", stringNames).toList();
    }
}

