/*
 * Decompiled with CFR 0.152.
 */
package org.ros.internal.node.topic;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.ros.exception.RemoteException;
import org.ros.internal.node.client.SlaveClient;
import org.ros.internal.node.response.Response;
import org.ros.internal.node.server.NodeIdentifier;
import org.ros.internal.node.topic.DefaultSubscriber;
import org.ros.internal.node.topic.PublisherIdentifier;
import org.ros.internal.node.xmlrpc.XmlRpcTimeoutException;
import org.ros.internal.transport.ProtocolDescription;
import org.ros.internal.transport.ProtocolNames;

class UpdatePublisherRunnable<MessageType>
implements Runnable {
    private static final Log log = LogFactory.getLog(UpdatePublisherRunnable.class);
    private final DefaultSubscriber<MessageType> subscriber;
    private final PublisherIdentifier publisherIdentifier;
    private final NodeIdentifier nodeIdentifier;

    public UpdatePublisherRunnable(DefaultSubscriber<MessageType> subscriber, NodeIdentifier nodeIdentifier, PublisherIdentifier publisherIdentifier) {
        this.subscriber = subscriber;
        this.nodeIdentifier = nodeIdentifier;
        this.publisherIdentifier = publisherIdentifier;
    }

    @Override
    public void run() {
        try {
            SlaveClient slaveClient = new SlaveClient(this.nodeIdentifier.getName(), this.publisherIdentifier.getNodeUri());
            Response<ProtocolDescription> response = slaveClient.requestTopic(this.subscriber.getTopicName(), ProtocolNames.SUPPORTED);
            ProtocolDescription selected = response.getResult();
            if (ProtocolNames.SUPPORTED.contains(selected.getName())) {
                this.subscriber.addPublisher(this.publisherIdentifier, selected.getAddress());
            } else {
                log.error((Object)("Publisher returned unsupported protocol selection: " + response));
            }
        }
        catch (RemoteException e) {
            log.error((Object)e);
        }
        catch (XmlRpcTimeoutException e) {
            log.error((Object)e);
        }
        catch (RuntimeException e) {
            log.error((Object)e);
        }
    }
}

