/*
 * Decompiled with CFR 0.152.
 */
package org.ros.internal.node.topic;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.util.List;
import java.util.Map;
import org.ros.internal.message.topic.TopicDescription;
import org.ros.internal.node.topic.TopicIdentifier;
import org.ros.internal.transport.ConnectionHeader;
import org.ros.namespace.GraphName;

public class TopicDeclaration {
    private final TopicIdentifier topicIdentifier;
    private final TopicDescription topicDescription;

    public static TopicDeclaration newFromHeader(Map<String, String> header) {
        Preconditions.checkArgument((boolean)header.containsKey("topic"));
        GraphName name = GraphName.of(header.get("topic"));
        String type = header.get("type");
        String definition = header.get("message_definition");
        String md5Checksum = header.get("md5sum");
        TopicDescription topicDescription = new TopicDescription(type, definition, md5Checksum);
        return new TopicDeclaration(new TopicIdentifier(name), topicDescription);
    }

    public static TopicDeclaration newFromTopicName(GraphName topicName, TopicDescription topicDescription) {
        return new TopicDeclaration(new TopicIdentifier(topicName), topicDescription);
    }

    public TopicDeclaration(TopicIdentifier topicIdentifier, TopicDescription topicDescription) {
        Preconditions.checkNotNull((Object)topicIdentifier);
        Preconditions.checkNotNull((Object)topicDescription);
        this.topicIdentifier = topicIdentifier;
        this.topicDescription = topicDescription;
    }

    public TopicIdentifier getIdentifier() {
        return this.topicIdentifier;
    }

    public GraphName getName() {
        return this.topicIdentifier.getName();
    }

    public String getMessageType() {
        return this.topicDescription.getType();
    }

    public ConnectionHeader toConnectionHeader() {
        ConnectionHeader connectionHeader = new ConnectionHeader();
        connectionHeader.merge(this.topicIdentifier.toConnectionHeader());
        connectionHeader.addField("type", this.topicDescription.getType());
        connectionHeader.addField("message_definition", this.topicDescription.getDefinition());
        connectionHeader.addField("md5sum", this.topicDescription.getMd5Checksum());
        return connectionHeader;
    }

    public List<String> toList() {
        return Lists.newArrayList((Object[])new String[]{this.getName().toString(), this.getMessageType()});
    }

    public String toString() {
        return "Topic<" + this.topicIdentifier + ", " + this.topicDescription.toString() + ">";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.topicDescription == null ? 0 : this.topicDescription.hashCode());
        result = 31 * result + (this.topicIdentifier == null ? 0 : this.topicIdentifier.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TopicDeclaration other = (TopicDeclaration)obj;
        if (this.topicDescription == null ? other.topicDescription != null : !this.topicDescription.equals((Object)other.topicDescription)) {
            return false;
        }
        return !(this.topicIdentifier == null ? other.topicIdentifier != null : !this.topicIdentifier.equals(other.topicIdentifier));
    }
}

