/*
 * Decompiled with CFR 0.152.
 */
package org.ros.internal.node.topic;

import com.google.common.base.Preconditions;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.ros.internal.node.BaseClientHandshake;
import org.ros.internal.transport.ConnectionHeader;

public class SubscriberHandshake
extends BaseClientHandshake {
    private static final boolean DEBUG = false;
    private static final Log log = LogFactory.getLog(SubscriberHandshake.class);

    public SubscriberHandshake(ConnectionHeader outgoingConnectionHeader) {
        super(outgoingConnectionHeader);
        Preconditions.checkNotNull((Object)outgoingConnectionHeader.getField("type"));
        Preconditions.checkNotNull((Object)outgoingConnectionHeader.getField("md5sum"));
    }

    @Override
    public boolean handshake(ConnectionHeader incommingConnectionHeader) {
        this.setErrorMessage(incommingConnectionHeader.getField("error"));
        String incomingType = incommingConnectionHeader.getField("type");
        if (incomingType == null) {
            this.setErrorMessage("Incoming type cannot be null.");
        } else if (!incomingType.equals(this.outgoingConnectionHeader.getField("type"))) {
            this.setErrorMessage("Message types don't match.");
        }
        String incomingMd5Checksum = incommingConnectionHeader.getField("md5sum");
        if (incomingMd5Checksum == null) {
            this.setErrorMessage("Incoming MD5 checksum cannot be null.");
        } else if (!incomingMd5Checksum.equals(this.outgoingConnectionHeader.getField("md5sum"))) {
            this.setErrorMessage("Checksums don't match.");
        }
        return this.getErrorMessage() == null;
    }
}

