/*
 * Decompiled with CFR 0.152.
 */
package org.ros.internal.node.topic;

import java.util.concurrent.ScheduledExecutorService;
import org.ros.internal.node.server.NodeIdentifier;
import org.ros.internal.node.topic.DefaultPublisher;
import org.ros.internal.node.topic.SubscriberIdentifier;
import org.ros.internal.node.topic.TopicDeclaration;
import org.ros.internal.node.topic.TopicParticipantManager;
import org.ros.message.MessageFactory;
import org.ros.message.MessageSerializer;
import org.ros.namespace.GraphName;
import org.ros.node.topic.DefaultPublisherListener;
import org.ros.node.topic.Publisher;

public class PublisherFactory {
    private final TopicParticipantManager topicParticipantManager;
    private final MessageFactory messageFactory;
    private final ScheduledExecutorService executorService;
    private final NodeIdentifier nodeIdentifier;
    private final Object mutex;

    public PublisherFactory(NodeIdentifier nodeIdentifier, TopicParticipantManager topicParticipantManager, MessageFactory messageFactory, ScheduledExecutorService executorService) {
        this.nodeIdentifier = nodeIdentifier;
        this.topicParticipantManager = topicParticipantManager;
        this.messageFactory = messageFactory;
        this.executorService = executorService;
        this.mutex = new Object();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> Publisher<T> newOrExisting(TopicDeclaration topicDeclaration, MessageSerializer<T> messageSerializer) {
        GraphName topicName = topicDeclaration.getName();
        Object object = this.mutex;
        synchronized (object) {
            if (this.topicParticipantManager.hasPublisher(topicName)) {
                return this.topicParticipantManager.getPublisher(topicName);
            }
            DefaultPublisher<T> publisher = new DefaultPublisher<T>(this.nodeIdentifier, topicDeclaration, messageSerializer, this.messageFactory, this.executorService);
            publisher.addListener(new DefaultPublisherListener<T>(){

                @Override
                public void onNewSubscriber(Publisher<T> publisher, SubscriberIdentifier subscriberIdentifier) {
                    PublisherFactory.this.topicParticipantManager.addPublisherConnection((DefaultPublisher)publisher, subscriberIdentifier);
                }

                @Override
                public void onShutdown(Publisher<T> publisher) {
                    PublisherFactory.this.topicParticipantManager.removePublisher((DefaultPublisher)publisher);
                }
            });
            this.topicParticipantManager.addPublisher(publisher);
            return publisher;
        }
    }
}

