/*
 * Decompiled with CFR 0.152.
 */
package org.ros.internal.node.server.master;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.net.URI;
import java.util.Set;
import org.ros.internal.node.server.master.ServiceRegistrationInfo;
import org.ros.internal.node.server.master.TopicRegistrationInfo;
import org.ros.namespace.GraphName;

public class NodeRegistrationInfo {
    private final GraphName nodeName;
    private final URI nodeSlaveUri;
    private final Set<TopicRegistrationInfo> publishers;
    private final Set<TopicRegistrationInfo> subscribers;
    private final Set<ServiceRegistrationInfo> services;

    public NodeRegistrationInfo(GraphName nodeName, URI nodeSlaveUri) {
        this.nodeName = nodeName;
        this.nodeSlaveUri = nodeSlaveUri;
        this.publishers = Sets.newHashSet();
        this.subscribers = Sets.newHashSet();
        this.services = Sets.newHashSet();
    }

    public GraphName getNodeName() {
        return this.nodeName;
    }

    public URI getNodeSlaveUri() {
        return this.nodeSlaveUri;
    }

    public boolean hasRegistrations() {
        return !this.publishers.isEmpty() || !this.subscribers.isEmpty() || !this.services.isEmpty();
    }

    public Set<TopicRegistrationInfo> getPublishers() {
        return ImmutableSet.copyOf(this.publishers);
    }

    public void addPublisher(TopicRegistrationInfo publisherTopic) {
        this.publishers.add(publisherTopic);
    }

    public boolean removePublisher(TopicRegistrationInfo publisherTopic) {
        return this.publishers.remove(publisherTopic);
    }

    public Set<TopicRegistrationInfo> getSubscribers() {
        return ImmutableSet.copyOf(this.subscribers);
    }

    public void addSubscriber(TopicRegistrationInfo subscriberTopic) {
        this.subscribers.add(subscriberTopic);
    }

    public boolean removeSubscriber(TopicRegistrationInfo subscriberTopic) {
        return this.subscribers.remove(subscriberTopic);
    }

    public Set<ServiceRegistrationInfo> getServices() {
        return ImmutableSet.copyOf(this.services);
    }

    public void addService(ServiceRegistrationInfo service) {
        this.services.add(service);
    }

    public boolean removeService(ServiceRegistrationInfo service) {
        return this.services.remove(service);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.nodeName.hashCode();
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        NodeRegistrationInfo other = (NodeRegistrationInfo)obj;
        return this.nodeName.equals(other.nodeName);
    }
}

