/*
 * Decompiled with CFR 0.152.
 */
package org.ros.internal.node.server.master;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Lists;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.ros.address.AdvertiseAddress;
import org.ros.address.BindAddress;
import org.ros.internal.node.client.SlaveClient;
import org.ros.internal.node.server.XmlRpcServer;
import org.ros.internal.node.server.master.MasterRegistrationListener;
import org.ros.internal.node.server.master.MasterRegistrationManagerImpl;
import org.ros.internal.node.server.master.NodeRegistrationInfo;
import org.ros.internal.node.server.master.ServiceRegistrationInfo;
import org.ros.internal.node.server.master.TopicRegistrationInfo;
import org.ros.internal.node.xmlrpc.MasterXmlRpcEndpointImpl;
import org.ros.namespace.GraphName;

public class MasterServer
extends XmlRpcServer
implements MasterRegistrationListener {
    private static final boolean DEBUG = false;
    private static final Log log = LogFactory.getLog(MasterServer.class);
    public static final int SYSTEM_STATE_PUBLISHERS = 0;
    public static final int SYSTEM_STATE_SUBSCRIBERS = 1;
    public static final int SYSTEM_STATE_SERVICES = 2;
    private static final GraphName MASTER_NODE_NAME = GraphName.of("/master");
    private final MasterRegistrationManagerImpl masterRegistrationManager = new MasterRegistrationManagerImpl(this);

    public MasterServer(BindAddress bindAddress, AdvertiseAddress advertiseAddress) {
        super(bindAddress, advertiseAddress);
    }

    public void start() {
        super.start(MasterXmlRpcEndpointImpl.class, new MasterXmlRpcEndpointImpl(this));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerService(GraphName nodeName, URI nodeSlaveUri, GraphName serviceName, URI serviceUri) {
        MasterRegistrationManagerImpl masterRegistrationManagerImpl = this.masterRegistrationManager;
        synchronized (masterRegistrationManagerImpl) {
            this.masterRegistrationManager.registerService(nodeName, nodeSlaveUri, serviceName, serviceUri);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean unregisterService(GraphName nodeName, GraphName serviceName, URI serviceUri) {
        MasterRegistrationManagerImpl masterRegistrationManagerImpl = this.masterRegistrationManager;
        synchronized (masterRegistrationManagerImpl) {
            return this.masterRegistrationManager.unregisterService(nodeName, serviceName, serviceUri);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<URI> registerSubscriber(GraphName nodeName, URI nodeSlaveUri, GraphName topicName, String topicMessageType) {
        MasterRegistrationManagerImpl masterRegistrationManagerImpl = this.masterRegistrationManager;
        synchronized (masterRegistrationManagerImpl) {
            TopicRegistrationInfo topicInfo = this.masterRegistrationManager.registerSubscriber(nodeName, nodeSlaveUri, topicName, topicMessageType);
            ArrayList publisherUris = Lists.newArrayList();
            for (NodeRegistrationInfo publisherNodeInfo : topicInfo.getPublishers()) {
                publisherUris.add(publisherNodeInfo.getNodeSlaveUri());
            }
            return publisherUris;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean unregisterSubscriber(GraphName nodeName, GraphName topicName) {
        MasterRegistrationManagerImpl masterRegistrationManagerImpl = this.masterRegistrationManager;
        synchronized (masterRegistrationManagerImpl) {
            return this.masterRegistrationManager.unregisterSubscriber(nodeName, topicName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<URI> registerPublisher(GraphName nodeName, URI nodeSlaveUri, GraphName topicName, String topicMessageType) {
        MasterRegistrationManagerImpl masterRegistrationManagerImpl = this.masterRegistrationManager;
        synchronized (masterRegistrationManagerImpl) {
            TopicRegistrationInfo topicInfo = this.masterRegistrationManager.registerPublisher(nodeName, nodeSlaveUri, topicName, topicMessageType);
            ArrayList subscriberSlaveUris = Lists.newArrayList();
            for (NodeRegistrationInfo publisherNodeInfo : topicInfo.getSubscribers()) {
                subscriberSlaveUris.add(publisherNodeInfo.getNodeSlaveUri());
            }
            this.publisherUpdate(topicInfo, subscriberSlaveUris);
            return subscriberSlaveUris;
        }
    }

    private void publisherUpdate(TopicRegistrationInfo topicInfo, List<URI> subscriberSlaveUris) {
        ArrayList publisherUris = Lists.newArrayList();
        for (NodeRegistrationInfo publisherNodeInfo : topicInfo.getPublishers()) {
            publisherUris.add(publisherNodeInfo.getNodeSlaveUri());
        }
        GraphName topicName = topicInfo.getTopicName();
        for (URI subscriberSlaveUri : subscriberSlaveUris) {
            this.contactSubscriberForPublisherUpdate(subscriberSlaveUri, topicName, publisherUris);
        }
    }

    @VisibleForTesting
    protected void contactSubscriberForPublisherUpdate(URI subscriberSlaveUri, GraphName topicName, List<URI> publisherUris) {
        SlaveClient client = new SlaveClient(MASTER_NODE_NAME, subscriberSlaveUri);
        client.publisherUpdate(topicName, publisherUris);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean unregisterPublisher(GraphName nodeName, GraphName topicName) {
        MasterRegistrationManagerImpl masterRegistrationManagerImpl = this.masterRegistrationManager;
        synchronized (masterRegistrationManagerImpl) {
            return this.masterRegistrationManager.unregisterPublisher(nodeName, topicName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public URI lookupNode(GraphName nodeName) {
        MasterRegistrationManagerImpl masterRegistrationManagerImpl = this.masterRegistrationManager;
        synchronized (masterRegistrationManagerImpl) {
            NodeRegistrationInfo node = this.masterRegistrationManager.getNodeRegistrationInfo(nodeName);
            if (node != null) {
                return node.getNodeSlaveUri();
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<List<String>> getTopicTypes(GraphName calledId) {
        MasterRegistrationManagerImpl masterRegistrationManagerImpl = this.masterRegistrationManager;
        synchronized (masterRegistrationManagerImpl) {
            ArrayList result = Lists.newArrayList();
            for (TopicRegistrationInfo topic : this.masterRegistrationManager.getAllTopics()) {
                result.add(Lists.newArrayList((Object[])new String[]{topic.getTopicName().toString(), topic.getMessageType()}));
            }
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Object> getSystemState() {
        MasterRegistrationManagerImpl masterRegistrationManagerImpl = this.masterRegistrationManager;
        synchronized (masterRegistrationManagerImpl) {
            ArrayList result = Lists.newArrayList();
            Collection<TopicRegistrationInfo> topics = this.masterRegistrationManager.getAllTopics();
            result.add(this.getSystemStatePublishers(topics));
            result.add(this.getSystemStateSubscribers(topics));
            result.add(this.getSystemStateServices());
            return result;
        }
    }

    private List<Object> getSystemStatePublishers(Collection<TopicRegistrationInfo> topics) {
        ArrayList result = Lists.newArrayList();
        for (TopicRegistrationInfo topic : topics) {
            if (!topic.hasPublishers()) continue;
            ArrayList topicInfo = Lists.newArrayList();
            topicInfo.add(topic.getTopicName().toString());
            ArrayList publist = Lists.newArrayList();
            for (NodeRegistrationInfo node : topic.getPublishers()) {
                publist.add(node.getNodeName().toString());
            }
            topicInfo.add(publist);
            result.add(topicInfo);
        }
        return result;
    }

    private List<Object> getSystemStateSubscribers(Collection<TopicRegistrationInfo> topics) {
        ArrayList result = Lists.newArrayList();
        for (TopicRegistrationInfo topic : topics) {
            if (!topic.hasSubscribers()) continue;
            ArrayList topicInfo = Lists.newArrayList();
            topicInfo.add(topic.getTopicName().toString());
            ArrayList sublist = Lists.newArrayList();
            for (NodeRegistrationInfo node : topic.getSubscribers()) {
                sublist.add(node.getNodeName().toString());
            }
            topicInfo.add(sublist);
            result.add(topicInfo);
        }
        return result;
    }

    private List<Object> getSystemStateServices() {
        ArrayList result = Lists.newArrayList();
        for (ServiceRegistrationInfo service : this.masterRegistrationManager.getAllServices()) {
            ArrayList topicInfo = Lists.newArrayList();
            topicInfo.add(service.getServiceName().toString());
            topicInfo.add(Lists.newArrayList((Object[])new String[]{service.getServiceName().toString()}));
            result.add(topicInfo);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public URI lookupService(GraphName serviceName) {
        MasterRegistrationManagerImpl masterRegistrationManagerImpl = this.masterRegistrationManager;
        synchronized (masterRegistrationManagerImpl) {
            ServiceRegistrationInfo service = this.masterRegistrationManager.getServiceRegistrationInfo(serviceName);
            if (service != null) {
                return service.getServiceUri();
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Object> getPublishedTopics(GraphName caller, GraphName subgraph) {
        MasterRegistrationManagerImpl masterRegistrationManagerImpl = this.masterRegistrationManager;
        synchronized (masterRegistrationManagerImpl) {
            ArrayList result = Lists.newArrayList();
            for (TopicRegistrationInfo topic : this.masterRegistrationManager.getAllTopics()) {
                if (!topic.hasPublishers()) continue;
                result.add(Lists.newArrayList((Object[])new String[]{topic.getTopicName().toString(), topic.getMessageType()}));
            }
            return result;
        }
    }

    @Override
    public void onNodeReplacement(NodeRegistrationInfo nodeInfo) {
        if (log.isWarnEnabled()) {
            log.warn((Object)String.format("Existing node %s with slave URI %s will be shutdown.", nodeInfo.getNodeName(), nodeInfo.getNodeSlaveUri()));
        }
        SlaveClient client = new SlaveClient(MASTER_NODE_NAME, nodeInfo.getNodeSlaveUri());
        client.shutdown("Replaced by new slave");
    }
}

