/*
 * Decompiled with CFR 0.152.
 */
package org.ros.internal.node.client;

import java.net.MalformedURLException;
import java.net.URI;
import org.apache.xmlrpc.client.XmlRpcClient;
import org.apache.xmlrpc.client.XmlRpcClientConfig;
import org.apache.xmlrpc.client.XmlRpcClientConfigImpl;
import org.apache.xmlrpc.client.XmlRpcCommonsTransportFactory;
import org.apache.xmlrpc.client.XmlRpcTransportFactory;
import org.ros.exception.RosRuntimeException;
import org.ros.internal.node.xmlrpc.XmlRpcClientFactory;
import org.ros.internal.node.xmlrpc.XmlRpcEndpoint;

abstract class Client<T extends XmlRpcEndpoint> {
    private static final int CONNECTION_TIMEOUT = 60000;
    private static final int REPLY_TIMEOUT = 60000;
    private static final int XMLRPC_TIMEOUT = 10000;
    private final URI uri;
    protected final T xmlRpcEndpoint;

    public Client(URI uri, Class<T> interfaceClass) {
        this.uri = uri;
        XmlRpcClientConfigImpl config = new XmlRpcClientConfigImpl();
        try {
            config.setServerURL(uri.toURL());
        }
        catch (MalformedURLException e) {
            throw new RosRuntimeException(e);
        }
        config.setConnectionTimeout(60000);
        config.setReplyTimeout(60000);
        XmlRpcClient client = new XmlRpcClient();
        client.setTransportFactory((XmlRpcTransportFactory)new XmlRpcCommonsTransportFactory(client));
        client.setConfig((XmlRpcClientConfig)config);
        XmlRpcClientFactory<T> factory = new XmlRpcClientFactory<T>(client);
        this.xmlRpcEndpoint = (XmlRpcEndpoint)interfaceClass.cast(factory.newInstance(this.getClass().getClassLoader(), interfaceClass, "", 10000));
    }

    public URI getRemoteUri() {
        return this.uri;
    }
}

