/*
 * Decompiled with CFR 0.152.
 */
package org.ros.internal.loader;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.ros.address.InetAddressFactory;
import org.ros.exception.RosRuntimeException;
import org.ros.namespace.GraphName;
import org.ros.namespace.NameResolver;
import org.ros.node.NodeConfiguration;
import org.ros.node.NodeMain;

public class CommandLineLoader {
    private final List<String> argv;
    private final List<String> nodeArguments;
    private final List<String> remappingArguments;
    private final Map<String, String> environment;
    private final Map<String, String> specialRemappings;
    private final Map<GraphName, GraphName> remappings;
    private String nodeClassName;

    public CommandLineLoader(List<String> argv) {
        this(argv, System.getenv());
    }

    public CommandLineLoader(List<String> argv, Map<String, String> environment) {
        Preconditions.checkArgument((argv.size() > 0 ? 1 : 0) != 0);
        this.argv = argv;
        this.environment = environment;
        this.nodeArguments = Lists.newArrayList();
        this.remappingArguments = Lists.newArrayList();
        this.remappings = Maps.newHashMap();
        this.specialRemappings = Maps.newHashMap();
        this.parseArgv();
    }

    private void parseArgv() {
        this.nodeClassName = this.argv.get(0);
        for (String argument : this.argv.subList(1, this.argv.size())) {
            if (argument.contains(":=")) {
                this.remappingArguments.add(argument);
                continue;
            }
            this.nodeArguments.add(argument);
        }
    }

    public String getNodeClassName() {
        return this.nodeClassName;
    }

    public List<String> getNodeArguments() {
        return Collections.unmodifiableList(this.nodeArguments);
    }

    public NodeConfiguration build() {
        this.parseRemappingArguments();
        NodeConfiguration nodeConfiguration = NodeConfiguration.newPublic(this.getHost());
        nodeConfiguration.setParentResolver(this.buildParentResolver());
        nodeConfiguration.setRosRoot(this.getRosRoot());
        nodeConfiguration.setRosPackagePath(this.getRosPackagePath());
        nodeConfiguration.setMasterUri(this.getMasterUri());
        if (this.specialRemappings.containsKey("__name")) {
            nodeConfiguration.setNodeName(this.specialRemappings.get("__name"));
        }
        return nodeConfiguration;
    }

    private void parseRemappingArguments() {
        for (String remapping : this.remappingArguments) {
            Preconditions.checkState((boolean)remapping.contains(":="));
            String[] remap = remapping.split(":=");
            if (remap.length > 2) {
                throw new IllegalArgumentException("Invalid remapping argument: " + remapping);
            }
            if (remapping.startsWith("__")) {
                this.specialRemappings.put(remap[0], remap[1]);
                continue;
            }
            this.remappings.put(GraphName.of(remap[0]), GraphName.of(remap[1]));
        }
    }

    private NameResolver buildParentResolver() {
        GraphName namespace = GraphName.root();
        if (this.specialRemappings.containsKey("__ns")) {
            namespace = GraphName.of(this.specialRemappings.get("__ns")).toGlobal();
        } else if (this.environment.containsKey("ROS_NAMESPACE")) {
            namespace = GraphName.of(this.environment.get("ROS_NAMESPACE")).toGlobal();
        }
        return new NameResolver(namespace, this.remappings);
    }

    private String getHost() {
        String host = InetAddressFactory.newLoopback().getHostAddress();
        if (this.specialRemappings.containsKey("__ip")) {
            host = this.specialRemappings.get("__ip");
        } else if (this.environment.containsKey("ROS_IP")) {
            host = this.environment.get("ROS_IP");
        } else if (this.environment.containsKey("ROS_HOSTNAME")) {
            host = this.environment.get("ROS_HOSTNAME");
        }
        return host;
    }

    private URI getMasterUri() {
        URI uri = NodeConfiguration.DEFAULT_MASTER_URI;
        try {
            if (this.specialRemappings.containsKey("__master")) {
                uri = new URI(this.specialRemappings.get("__master"));
            } else if (this.environment.containsKey("ROS_MASTER_URI")) {
                uri = new URI(this.environment.get("ROS_MASTER_URI"));
            }
            return uri;
        }
        catch (URISyntaxException e) {
            throw new RosRuntimeException("Invalid master URI: " + uri);
        }
    }

    private File getRosRoot() {
        if (this.environment.containsKey("ROS_ROOT")) {
            return new File(this.environment.get("ROS_ROOT"));
        }
        return null;
    }

    private List<File> getRosPackagePath() {
        if (this.environment.containsKey("ROS_PACKAGE_PATH")) {
            String rosPackagePath = this.environment.get("ROS_PACKAGE_PATH");
            ArrayList paths = Lists.newArrayList();
            String[] stringArray = rosPackagePath.split(File.pathSeparator);
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String path = stringArray[n2];
                paths.add(new File(path));
                ++n2;
            }
            return paths;
        }
        return Lists.newArrayList();
    }

    public NodeMain loadClass(String name) throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        Class<?> clazz = this.getClass().getClassLoader().loadClass(name);
        return (NodeMain)NodeMain.class.cast(clazz.newInstance());
    }
}

