/*
 * Decompiled with CFR 0.152.
 */
package org.ros.concurrent;

import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;

public class WatchdogTimer {
    private final ScheduledExecutorService scheduledExecutorService;
    private final long period;
    private final TimeUnit unit;
    private final Runnable runnable;
    private boolean pulsed;
    private ScheduledFuture<?> scheduledFuture;

    public WatchdogTimer(ScheduledExecutorService scheduledExecutorService, long period, TimeUnit unit, final Runnable runnable) {
        this.scheduledExecutorService = scheduledExecutorService;
        this.period = period;
        this.unit = unit;
        this.runnable = new Runnable(){

            @Override
            public void run() {
                try {
                    if (!WatchdogTimer.this.pulsed) {
                        runnable.run();
                    }
                }
                finally {
                    WatchdogTimer.this.pulsed = false;
                }
            }
        };
        this.pulsed = false;
    }

    public void start() {
        this.scheduledFuture = this.scheduledExecutorService.scheduleAtFixedRate(this.runnable, this.period, this.period, this.unit);
    }

    public void pulse() {
        this.pulsed = true;
    }

    public void cancel() {
        this.scheduledFuture.cancel(true);
    }
}

