/*
 * Decompiled with CFR 0.152.
 */
package org.ros.concurrent;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import org.ros.concurrent.EventDispatcher;
import org.ros.concurrent.SignalRunnable;

public class ListenerGroup<T> {
    private static final int DEFAULT_QUEUE_CAPACITY = 128;
    private final ExecutorService executorService;
    private final Collection<EventDispatcher<T>> eventDispatchers;

    public ListenerGroup(ExecutorService executorService) {
        this.executorService = executorService;
        this.eventDispatchers = Lists.newCopyOnWriteArrayList();
    }

    public EventDispatcher<T> add(T listener, int queueCapacity) {
        EventDispatcher<T> eventDispatcher = new EventDispatcher<T>(listener, queueCapacity);
        this.eventDispatchers.add(eventDispatcher);
        this.executorService.execute(eventDispatcher);
        return eventDispatcher;
    }

    public EventDispatcher<T> add(T listener) {
        return this.add(listener, 128);
    }

    public Collection<EventDispatcher<T>> addAll(Collection<T> listeners, int limit) {
        ArrayList eventDispatchers = Lists.newArrayList();
        for (T listener : listeners) {
            eventDispatchers.add(this.add(listener, limit));
        }
        return eventDispatchers;
    }

    public Collection<EventDispatcher<T>> addAll(Collection<T> listeners) {
        return this.addAll(listeners, 128);
    }

    public boolean remove(T listener) {
        for (EventDispatcher<T> eventDispatcher : this.eventDispatchers) {
            if (!listener.equals(eventDispatcher.getListener())) continue;
            eventDispatcher.cancel();
            this.eventDispatchers.remove(eventDispatcher);
            return true;
        }
        return false;
    }

    public int size() {
        return this.eventDispatchers.size();
    }

    public void signal(SignalRunnable<T> signalRunnable) {
        for (EventDispatcher<T> eventDispatcher : this.eventDispatchers) {
            eventDispatcher.signal(signalRunnable);
        }
    }

    public boolean signal(final SignalRunnable<T> signalRunnable, long timeout, TimeUnit unit) throws InterruptedException {
        ArrayList copy = Lists.newArrayList(this.eventDispatchers);
        final CountDownLatch latch = new CountDownLatch(copy.size());
        for (EventDispatcher eventDispatcher : copy) {
            eventDispatcher.signal(new SignalRunnable<T>(){

                @Override
                public void run(T listener) {
                    signalRunnable.run(listener);
                    latch.countDown();
                }
            });
        }
        return latch.await(timeout, unit);
    }

    public void shutdown() {
        for (EventDispatcher<T> eventDispatcher : this.eventDispatchers) {
            eventDispatcher.cancel();
        }
        this.eventDispatchers.clear();
    }
}

