/*
 * Decompiled with CFR 0.152.
 */
package org.ros.concurrent;

import org.ros.concurrent.CancellableLoop;
import org.ros.concurrent.CircularBlockingDeque;
import org.ros.concurrent.SignalRunnable;

public class EventDispatcher<T>
extends CancellableLoop {
    private final T listener;
    private final CircularBlockingDeque<SignalRunnable<T>> events;

    public EventDispatcher(T listener, int queueCapacity) {
        this.listener = listener;
        this.events = new CircularBlockingDeque(queueCapacity);
    }

    public void signal(SignalRunnable<T> signalRunnable) {
        this.events.addLast(signalRunnable);
    }

    @Override
    public void loop() throws InterruptedException {
        SignalRunnable<T> signalRunnable = this.events.takeFirst();
        signalRunnable.run(this.listener);
    }

    public T getListener() {
        return this.listener;
    }
}

