/*
 * Decompiled with CFR 0.152.
 */
package org.ros.address;

import java.net.InetSocketAddress;
import org.ros.address.InetAddressFactory;

public class BindAddress {
    private final InetSocketAddress address;

    private BindAddress(InetSocketAddress address) {
        this.address = address;
    }

    public static BindAddress newPublic(int port) {
        return new BindAddress(new InetSocketAddress(port));
    }

    public static BindAddress newPublic() {
        return BindAddress.newPublic(0);
    }

    public static BindAddress newPrivate(int port) {
        return new BindAddress(new InetSocketAddress(InetAddressFactory.newLoopback(), port));
    }

    public static BindAddress newPrivate() {
        return BindAddress.newPrivate(0);
    }

    public String toString() {
        return "BindAddress<" + this.address + ">";
    }

    public InetSocketAddress toInetSocketAddress() {
        return this.address;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.address == null ? 0 : this.address.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        BindAddress other = (BindAddress)obj;
        return !(this.address == null ? other.address != null : !this.address.equals(other.address));
    }
}

