/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.components;

import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.dialogs.ContainerCheckedTreeViewer;

public class CachedCheckboxTreeViewer
extends ContainerCheckedTreeViewer {
    private final Set<Object> checkState = new HashSet<Object>();

    protected CachedCheckboxTreeViewer(Tree tree) {
        super(tree);
        this.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                CachedCheckboxTreeViewer.this.updateCheckState(event.getElement(), event.getChecked());
            }
        });
        this.setUseHashlookup(true);
    }

    protected void updateCheckState(Object element, boolean state) {
        if (state) {
            ITreeContentProvider contentProvider = null;
            if (this.getContentProvider() instanceof ITreeContentProvider) {
                contentProvider = (ITreeContentProvider)this.getContentProvider();
            }
            if (contentProvider != null) {
                Object[] children = contentProvider.getChildren(element);
                if (children != null && children.length > 0) {
                    Object[] objectArray = children;
                    int n = children.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Object child = objectArray[n2];
                        this.updateCheckState(child, state);
                        ++n2;
                    }
                } else {
                    this.checkState.add(element);
                }
            } else {
                this.checkState.add(element);
            }
        } else if (this.checkState != null) {
            Object[] children;
            ITreeContentProvider contentProvider = null;
            if (this.getContentProvider() instanceof ITreeContentProvider) {
                contentProvider = (ITreeContentProvider)this.getContentProvider();
            }
            if (contentProvider != null && (children = contentProvider.getChildren(element)) != null && children.length > 0) {
                Object[] objectArray = children;
                int n = children.length;
                int n3 = 0;
                while (n3 < n) {
                    Object child = objectArray[n3];
                    this.updateCheckState(child, state);
                    ++n3;
                }
            }
            this.checkState.remove(element);
        }
    }

    public void restoreLeafCheckState() {
        if (this.checkState == null) {
            return;
        }
        this.getTree().setRedraw(false);
        super.setCheckedElements(new Object[0]);
        this.setGrayedElements(new Object[0]);
        Iterator<Object> iter = this.checkState.iterator();
        Object element = null;
        if (iter.hasNext()) {
            this.expandAll();
        }
        while (iter.hasNext()) {
            element = iter.next();
            super.setChecked(element, true);
        }
        this.getTree().setRedraw(true);
    }

    public Object[] getCheckedLeafElements() {
        if (this.checkState == null) {
            return new Object[0];
        }
        return this.checkState.toArray(new Object[0]);
    }

    public int getCheckedLeafCount() {
        if (this.checkState == null) {
            return 0;
        }
        return this.checkState.size();
    }

    public boolean setChecked(Object element, boolean state) {
        this.updateCheckState(element, state);
        return super.setChecked(element, state);
    }

    public void setCheckedElements(Object[] elements) {
        super.setCheckedElements(elements);
        this.checkState.clear();
        ITreeContentProvider contentProvider = null;
        if (this.getContentProvider() instanceof ITreeContentProvider) {
            contentProvider = (ITreeContentProvider)this.getContentProvider();
        }
        int i = 0;
        while (i < elements.length) {
            Object[] children;
            Object[] objectArray = children = contentProvider != null ? contentProvider.getChildren(elements[i]) : null;
            if (!(this.getGrayed(elements[i]) || children != null && children.length != 0 || this.checkState.contains(elements[i]))) {
                this.checkState.add(elements[i]);
            }
            ++i;
        }
    }

    public void setAllChecked(boolean state) {
        block8: {
            Object[] visible;
            int n;
            block7: {
                TreeItem[] treeItemArray = super.getTree().getItems();
                n = treeItemArray.length;
                int n2 = 0;
                while (n2 < n) {
                    TreeItem item = treeItemArray[n2];
                    item.setChecked(state);
                    ++n2;
                }
                if (!state) break block7;
                visible = this.getFilteredChildren(this.getRoot());
                ITreeContentProvider contentProvider = null;
                if (this.getContentProvider() instanceof ITreeContentProvider) {
                    contentProvider = (ITreeContentProvider)this.getContentProvider();
                }
                if (contentProvider == null) {
                    Object[] objectArray = visible;
                    int n3 = visible.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        Object element = objectArray[n4];
                        this.checkState.add(element);
                        ++n4;
                    }
                } else {
                    HashSet<Object> toCheck = new HashSet<Object>();
                    Object[] objectArray = visible;
                    int n5 = visible.length;
                    int n6 = 0;
                    while (n6 < n5) {
                        Object element = objectArray[n6];
                        this.addFilteredChildren(element, contentProvider, toCheck);
                        ++n6;
                    }
                    this.checkState.addAll(toCheck);
                }
                break block8;
            }
            if (this.checkState == null) break block8;
            Object[] objectArray = visible = this.filter(this.checkState.toArray());
            int n7 = visible.length;
            n = 0;
            while (n < n7) {
                Object element = objectArray[n];
                this.checkState.remove(element);
                ++n;
            }
        }
    }

    private void addFilteredChildren(Object element, ITreeContentProvider contentProvider, Collection<Object> result) {
        if (!contentProvider.hasChildren(element)) {
            result.add(element);
        } else {
            Object[] visibleChildren;
            Object[] objectArray = visibleChildren = this.getFilteredChildren(element);
            int n = visibleChildren.length;
            int n2 = 0;
            while (n2 < n) {
                Object visibleChild = objectArray[n2];
                this.addFilteredChildren(visibleChild, contentProvider, result);
                ++n2;
            }
        }
    }

    public void remove(Object[] elementsOrTreePaths) {
        Object[] objectArray = elementsOrTreePaths;
        int n = elementsOrTreePaths.length;
        int n2 = 0;
        while (n2 < n) {
            Object elementsOrTreePath = objectArray[n2];
            this.updateCheckState(elementsOrTreePath, false);
            ++n2;
        }
        super.remove(elementsOrTreePaths);
    }

    public void remove(Object elementsOrTreePaths) {
        this.updateCheckState(elementsOrTreePaths, false);
        super.remove(elementsOrTreePaths);
    }
}

