/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.core.invocator.ui.parts;

import java.util.List;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import javax.inject.Named;
import org.eclipse.apogy.common.e4.ui.ApogyCommonE4UIFacade;
import org.eclipse.apogy.common.emf.ApogyCommonTransactionFacade;
import org.eclipse.apogy.common.emf.ui.ApogyCommonEMFUIFactory;
import org.eclipse.apogy.common.emf.ui.ECollectionCompositeLayout;
import org.eclipse.apogy.common.emf.ui.ECollectionCompositeSettings;
import org.eclipse.apogy.common.emf.ui.composites.AbstractECollectionComposite;
import org.eclipse.apogy.core.invocator.AbstractOperationCall;
import org.eclipse.apogy.core.invocator.AbstractProgramRuntime;
import org.eclipse.apogy.core.invocator.ApogyCoreInvocatorFacade;
import org.eclipse.apogy.core.invocator.ApogyCoreInvocatorPackage;
import org.eclipse.apogy.core.invocator.InvocatorSession;
import org.eclipse.apogy.core.invocator.OperationCallsList;
import org.eclipse.apogy.core.invocator.OperationCallsListProgramRuntime;
import org.eclipse.apogy.core.invocator.Program;
import org.eclipse.apogy.core.invocator.ProgramFactoriesRegistry;
import org.eclipse.apogy.core.invocator.ProgramFactory;
import org.eclipse.apogy.core.invocator.ui.composites.OperationCallsListComposite;
import org.eclipse.apogy.core.invocator.ui.parts.AbstractSessionECollectionPart;
import org.eclipse.apogy.core.invocator.ui.parts.IProgramPart;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.ui.workbench.modeling.ESelectionService;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;

public class OperationCallsListPart
extends AbstractSessionECollectionPart<OperationCallsList>
implements IProgramPart {
    private static final String PARENT_PART_ID = "org.eclipse.apogy.core.invocator.ui.part.scriptBasedProgramsList";
    private OperationCallsListComposite composite;
    private Adapter runtimeAdapter = null;
    @Inject
    public ESelectionService selectionService;

    @Inject
    @Optional
    public void setSelection(@Named(value="org.eclipse.ui.selection") OperationCallsList operationCallsList) {
        if (ApogyCommonE4UIFacade.INSTANCE.isActive(this.ePartService, PARENT_PART_ID)) {
            this.setContent((EObject)operationCallsList);
        }
    }

    @Override
    @PostConstruct
    public void initialize() {
        IStructuredSelection ss = (IStructuredSelection)this.getParentSelection(PARENT_PART_ID);
        this.setContent((EObject)(ss == null ? null : (OperationCallsList)ss.getFirstElement()));
    }

    @Override
    public AbstractECollectionComposite<?, ?, ?> createECollectionComposite(Composite parent, int style) {
        ECollectionCompositeSettings settings = ApogyCommonEMFUIFactory.eINSTANCE.createECollectionCompositeSettings();
        settings.setDetailSectionDisplayed(true);
        settings.setLayout(ECollectionCompositeLayout.VERTICAL);
        this.composite = new OperationCallsListComposite(parent, 0, settings){

            @Override
            protected void selectionChanged(IStructuredSelection selection) {
                super.selectionChanged(selection);
                OperationCallsListPart.this.selectionService.setSelection(selection == null ? null : selection.getFirstElement());
            }

            @Override
            protected Color getBackgroundColor(AbstractOperationCall abstractOperationCall) {
                Color color = null;
                if (OperationCallsListPart.this.getAbstractProgramRuntime() instanceof OperationCallsListProgramRuntime && OperationCallsListPart.this.getProgram() instanceof OperationCallsList) {
                    OperationCallsListProgramRuntime runtime = (OperationCallsListProgramRuntime)OperationCallsListPart.this.getAbstractProgramRuntime();
                    OperationCallsList operationCallsList = (OperationCallsList)OperationCallsListPart.this.getProgram();
                    AbstractOperationCall runningOpsCall = null;
                    if (runtime.getIndexCurrentlyExecuted() > -1) {
                        runningOpsCall = (AbstractOperationCall)operationCallsList.getOperationCalls().get(runtime.getIndexCurrentlyExecuted());
                    }
                    AbstractOperationCall lastExecutedOpsCall = null;
                    if (runtime.getIndexLastExecuted() > -1) {
                        lastExecutedOpsCall = (AbstractOperationCall)operationCallsList.getOperationCalls().get(runtime.getIndexLastExecuted());
                    }
                    if (abstractOperationCall == runningOpsCall) {
                        color = Display.getCurrent().getSystemColor(7);
                    } else if (abstractOperationCall == lastExecutedOpsCall) {
                        color = Display.getCurrent().getSystemColor(5);
                    }
                }
                return color;
            }
        };
        return this.composite;
    }

    @PreDestroy
    public void preDestroy() {
        AbstractProgramRuntime runtime = this.getAbstractProgramRuntime();
        if (runtime != null) {
            runtime.eAdapters().remove((Object)this.getRuntimeAdapter());
        }
    }

    @Override
    public Program getProgram() {
        if (this.composite != null) {
            return (Program)this.composite.getRootEObject();
        }
        return null;
    }

    @Override
    public AbstractProgramRuntime getAbstractProgramRuntime() {
        AbstractProgramRuntime runtime = null;
        if (this.getProgram() != null) {
            List runtimes = ApogyCoreInvocatorFacade.INSTANCE.getActiveInvocatorSession().getProgramRuntimesList().findAbstractProgramRuntime(this.getProgram());
            if (!runtimes.isEmpty()) {
                runtime = (AbstractProgramRuntime)runtimes.get(0);
            } else {
                ProgramFactory programFactory = (ProgramFactory)ProgramFactoriesRegistry.INSTANCE.getProgramFactoriesMap().get(this.getProgram().eClass());
                if (programFactory != null) {
                    runtime = programFactory.createProgramRuntime(this.getProgram(), null);
                    runtime.setName(this.getProgram().getName());
                    if (runtime != null) {
                        ApogyCommonTransactionFacade.INSTANCE.basicAdd((EObject)ApogyCoreInvocatorFacade.INSTANCE.getActiveInvocatorSession().getProgramRuntimesList(), (EStructuralFeature)ApogyCoreInvocatorPackage.Literals.PROGRAM_RUNTIMES_LIST__PROGRAM_RUNTIMES, (Object)runtime, true);
                    }
                }
            }
        }
        if (runtime != null && !runtime.eAdapters().contains((Object)this.getRuntimeAdapter())) {
            runtime.eAdapters().add((Object)this.getRuntimeAdapter());
        }
        return runtime;
    }

    protected void doSetContent(OperationCallsList rootEObject) {
        this.composite.setRootEObject((EObject)rootEObject);
    }

    @Override
    protected void sessionChanged(InvocatorSession session) {
        this.initialize();
    }

    protected Adapter getRuntimeAdapter() {
        if (this.runtimeAdapter == null) {
            this.runtimeAdapter = new AdapterImpl(){

                public void notifyChanged(Notification msg) {
                    Display.getDefault().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            if (OperationCallsListPart.this.composite != null && !OperationCallsListPart.this.composite.isDisposed()) {
                                OperationCallsListPart.this.composite.getViewer().refresh(true);
                            }
                        }
                    });
                }
            };
        }
        return this.runtimeAdapter;
    }
}

