/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.core.invocator.ui.impl;

import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;
import javax.measure.unit.Unit;
import org.eclipse.apogy.common.emf.ApogyCommonEMFFacade;
import org.eclipse.apogy.common.emf.ApogyCommonTransactionFacade;
import org.eclipse.apogy.common.emf.ui.ApogyCommonEMFUIFacade;
import org.eclipse.apogy.core.invocator.AbstractOperationCall;
import org.eclipse.apogy.core.invocator.AbstractTypeImplementation;
import org.eclipse.apogy.core.invocator.ApogyCoreInvocatorFacade;
import org.eclipse.apogy.core.invocator.ApogyCoreInvocatorPackage;
import org.eclipse.apogy.core.invocator.ArgumentsList;
import org.eclipse.apogy.core.invocator.Context;
import org.eclipse.apogy.core.invocator.InvocatorSession;
import org.eclipse.apogy.core.invocator.Type;
import org.eclipse.apogy.core.invocator.Variable;
import org.eclipse.apogy.core.invocator.VariableFeatureReference;
import org.eclipse.apogy.core.invocator.VariablesList;
import org.eclipse.apogy.core.invocator.ui.impl.ApogyCoreInvocatorUIFacadeImpl;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EOperation;
import org.eclipse.emf.ecore.EParameter;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.ETypedElement;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.edit.command.SetCommand;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.jface.dialogs.MessageDialog;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ApogyCoreInvocatorUIFacadeCustomImpl
extends ApogyCoreInvocatorUIFacadeImpl {
    private static final Logger Logger = LoggerFactory.getLogger(ApogyCoreInvocatorUIFacadeImpl.class);

    @Override
    public void copyInitializationData(Context source, Context destination) throws Exception {
        if (source.getVariableImplementationsList().getVariableImplementations().size() != destination.getVariableImplementationsList().getVariableImplementations().size()) {
            throw new Exception("Contexts <" + source.getName() + "> and <" + destination.getName() + "> are not consistent");
        }
        Iterator sourceVariableImplementations = source.getVariableImplementationsList().getVariableImplementations().iterator();
        Iterator destinationVariableImplementations = destination.getVariableImplementationsList().getVariableImplementations().iterator();
        while (sourceVariableImplementations.hasNext()) {
            try {
                CompoundCommand command = new CompoundCommand();
                this.copyInitializationData((AbstractTypeImplementation)sourceVariableImplementations.next(), (AbstractTypeImplementation)destinationVariableImplementations.next(), command);
                EditingDomain editingDomain = AdapterFactoryEditingDomain.getEditingDomainFor((EObject)source);
                editingDomain.getCommandStack().execute((Command)command);
            }
            catch (Exception e) {
                throw new Exception("Contexts <" + source.getName() + "> and <" + destination.getName() + "> are not consistent", e);
            }
        }
    }

    @Override
    public void copyInitializationData(AbstractTypeImplementation source, AbstractTypeImplementation destination, CompoundCommand command) throws Exception {
        if (source.getHandlingType() != destination.getHandlingType()) {
            throw new Exception();
        }
        if (source.getTypeMemberImplementations().size() != destination.getTypeMemberImplementations().size()) {
            throw new Exception();
        }
        command.append((Command)new SetCommand(AdapterFactoryEditingDomain.getEditingDomainFor((EObject)source), (EObject)destination, (EStructuralFeature)ApogyCoreInvocatorPackage.Literals.ABSTRACT_TYPE_IMPLEMENTATION__ABSTRACT_INITIALIZATION_DATA, (Object)EcoreUtil.copy((EObject)source.getAbstractInitializationData())));
        Iterator sourceImplementations = source.getTypeMemberImplementations().iterator();
        Iterator destinationImplementations = destination.getTypeMemberImplementations().iterator();
        while (sourceImplementations.hasNext()) {
            this.copyInitializationData((AbstractTypeImplementation)sourceImplementations.next(), (AbstractTypeImplementation)destinationImplementations.next(), command);
        }
    }

    @Override
    public void initSession() {
        ApogyCommonTransactionFacade.INSTANCE.getDefaultEditingDomain().getCommandStack().execute((Command)new RecordingCommand(ApogyCommonTransactionFacade.INSTANCE.getDefaultEditingDomain()){

            protected void doExecute() {
                ApogyCoreInvocatorFacade.INSTANCE.initVariableInstances();
            }
        });
    }

    @Override
    public void disposeSession() {
        ApogyCommonTransactionFacade.INSTANCE.getDefaultEditingDomain().getCommandStack().execute((Command)new RecordingCommand(ApogyCommonTransactionFacade.INSTANCE.getDefaultEditingDomain()){

            protected void doExecute() {
                ApogyCoreInvocatorFacade.INSTANCE.disposeVariableInstances();
            }
        });
    }

    @Override
    public void addVariable(final VariablesList variablesList, final Variable variable) {
        TransactionalEditingDomain domain = (TransactionalEditingDomain)AdapterFactoryEditingDomain.getEditingDomainFor((EObject)variablesList);
        domain.getCommandStack().execute((Command)new RecordingCommand(domain){

            protected void doExecute() {
                ApogyCoreInvocatorFacade.INSTANCE.addVariable(variablesList, variable);
            }
        });
    }

    @Override
    public void deleteVariables(final VariablesList variablesList, final List<Variable> variables) {
        String variablesToDeleteMessage = ApogyCommonEMFFacade.INSTANCE.toString(variables, ", ");
        MessageDialog dialog = new MessageDialog(null, "Delete the selected variables", null, "Are you sure to delete these variables: " + variablesToDeleteMessage, 3, new String[]{"Yes", "No"}, 1);
        int result = dialog.open();
        if (result == 0) {
            TransactionalEditingDomain domain = (TransactionalEditingDomain)AdapterFactoryEditingDomain.getEditingDomainFor((EObject)variablesList);
            domain.getCommandStack().execute((Command)new RecordingCommand(domain){

                protected void doExecute() {
                    for (Variable variable : variables) {
                        try {
                            ApogyCoreInvocatorFacade.INSTANCE.deleteVariable(variablesList, variable);
                        }
                        catch (Exception e) {
                            Logger.error("Unable to delete the variable <" + variable.getName() + ">", (Throwable)e);
                        }
                    }
                }
            });
        }
    }

    @Override
    public void saveToPersistedState(MPart mPart, String persistedStateKey, EObject eObject) {
        InvocatorSession activeInvocatorSession = ApogyCoreInvocatorFacade.INSTANCE.getActiveInvocatorSession();
        if (activeInvocatorSession != null) {
            Resource parentResource = activeInvocatorSession.eResource();
            ResourceSet resourceSet = parentResource.getResourceSet();
            ApogyCommonEMFUIFacade.INSTANCE.saveToPersistedState(mPart, persistedStateKey, eObject, resourceSet);
        } else {
            Logger.error("Failed to save EObject to Part <" + mPart.getElementId() + "> Persisted State at key <" + persistedStateKey + "> : The active session is null.");
        }
    }

    @Override
    public EObject readFromPersistedState(MPart mPart, String persistedStateKey) {
        InvocatorSession activeInvocatorSession = ApogyCoreInvocatorFacade.INSTANCE.getActiveInvocatorSession();
        if (activeInvocatorSession != null) {
            Resource parentResource = activeInvocatorSession.eResource();
            ResourceSet resourceSet = parentResource.getResourceSet();
            return ApogyCommonEMFUIFacade.INSTANCE.readFromPersistedState(mPart, persistedStateKey, resourceSet);
        }
        Logger.error("Failed to load EObject from Part <" + mPart.getElementId() + "> Persisted State at key <" + persistedStateKey + "> : The active session is null.");
        return null;
    }

    @Override
    public SortedSet<Type> sortTypeByName(List<Type> types) {
        TreeSet<Type> sorted = new TreeSet<Type>(new Comparator<Type>(){

            @Override
            public int compare(Type o1, Type o2) {
                if (o1.getName() != null && o2.getName() != null) {
                    int compare = o1.getName().compareToIgnoreCase(o2.getName());
                    if (compare != 0) {
                        return compare;
                    }
                    return o1.getTypeApiAdapterClass().getName().compareTo(o2.getTypeApiAdapterClass().getName());
                }
                return o1.getTypeApiAdapterClass().getName().compareTo(o2.getTypeApiAdapterClass().getName());
            }
        });
        sorted.addAll(types);
        return sorted;
    }

    @Override
    public String asString(AbstractOperationCall abstractOperationCall, boolean includeVariableFeatureReference, boolean includeReturnType, boolean includeParametersTypes, boolean includeParametersValues) {
        String text = "";
        if (includeReturnType) {
            text = abstractOperationCall.getEOperation().getEType() != null ? String.valueOf(text) + abstractOperationCall.getEOperation().getEType().getInstanceClass().getSimpleName() + " " : String.valueOf(text) + "void ";
        }
        if (includeVariableFeatureReference) {
            text = String.valueOf(text) + ApogyCoreInvocatorFacade.INSTANCE.getVariableFeatureReferenceString((VariableFeatureReference)abstractOperationCall) + ".";
        }
        text = String.valueOf(text) + abstractOperationCall.getEOperation().getName();
        if (includeParametersTypes || includeParametersValues) {
            text = String.valueOf(text) + this.getParameterString(abstractOperationCall, includeParametersTypes, includeParametersValues);
        }
        return text;
    }

    @Override
    public Unit<?> getVariableFeatureReferenceDisplayUnits(VariableFeatureReference variableFeatureReference) {
        EStructuralFeature eStructuralFeature;
        if (variableFeatureReference != null && variableFeatureReference.getFeaturePath() != null && (eStructuralFeature = ApogyCommonEMFFacade.INSTANCE.getLastFeature(variableFeatureReference.getFeaturePath())) != null) {
            return ApogyCommonEMFUIFacade.INSTANCE.getDisplayUnits((ETypedElement)eStructuralFeature);
        }
        return null;
    }

    private String getParameterString(AbstractOperationCall abstractOperationCall, boolean includeParametersTypes, boolean includeParametersValues) {
        String eParamaters_str = "";
        EOperation eOperation = abstractOperationCall.getEOperation();
        ArgumentsList argumentList = abstractOperationCall.getArgumentsList();
        if (argumentList != null) {
            List argumentValues = argumentList.getArgumentValues();
            eParamaters_str = "(";
            int index = 0;
            while (index < argumentList.getArguments().size()) {
                EParameter eParameter = (EParameter)eOperation.getEParameters().get(index);
                Object value = argumentValues.get(index);
                if (includeParametersTypes) {
                    eParamaters_str = String.valueOf(eParamaters_str) + eParameter.getEType().getInstanceClass().getSimpleName() + " ";
                }
                if (includeParametersValues) {
                    eParamaters_str = String.valueOf(eParamaters_str) + this.getParameterValue(eParameter, value) + " ";
                }
                eParamaters_str = String.valueOf(eParamaters_str) + ", ";
                ++index;
            }
            eParamaters_str = eParamaters_str.substring(0, eParamaters_str.length() - 2);
            eParamaters_str = String.valueOf(eParamaters_str) + ")";
        } else {
            eParamaters_str = "()";
        }
        return eParamaters_str;
    }

    private String getParameterValue(EParameter eParameter, Object value) {
        String valueString = "";
        if (value == null) {
            value = "null";
        } else if (value instanceof Number) {
            valueString = ApogyCommonEMFUIFacade.INSTANCE.getDisplayedString((Number)value, (ETypedElement)eParameter);
        } else {
            valueString = value.toString();
            if (valueString.length() > 50) {
                valueString = valueString.substring(0, 49);
            }
        }
        return valueString;
    }
}

