/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.core.invocator.ui.handlers;

import org.eclipse.apogy.core.invocator.AbstractProgramRuntime;
import org.eclipse.apogy.core.invocator.ApogyCoreInvocatorFacade;
import org.eclipse.apogy.core.invocator.ui.handlers.AbstractProgramRuntimeHandler;
import org.eclipse.e4.core.di.annotations.CanExecute;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StepReturnProgramRuntimeHandler
extends AbstractProgramRuntimeHandler {
    private static final Logger Logger = LoggerFactory.getLogger(StepReturnProgramRuntimeHandler.class);

    @Execute
    public void execute(MPart part) {
        AbstractProgramRuntime runtime = this.getAbstractProgramRuntime(part);
        if (runtime != null) {
            try {
                runtime.stepReturn();
            }
            catch (Exception e) {
                String errorMessage = "Failed to Step Over Return!";
                Logger.error(errorMessage, (Throwable)e);
                this.openErrorDialog(errorMessage);
            }
        }
    }

    @Override
    @CanExecute
    public boolean canExecute(MPart part) {
        if (ApogyCoreInvocatorFacade.INSTANCE.getActiveInvocatorSession() == null) {
            return false;
        }
        if (ApogyCoreInvocatorFacade.INSTANCE.getActiveInvocatorSession().getProgramRuntimesList() == null) {
            return false;
        }
        return this.getAbstractProgramRuntime(part) != null;
    }
}

