/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.core.invocator.ui.composites;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileReader;
import java.io.FileWriter;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;

public class TextScriptEditorComposite
extends Composite {
    private String relativeScriptPath;
    private final StyledText styledText;
    private boolean isDirty = false;

    public TextScriptEditorComposite(Composite parent, int style) {
        super(parent, style);
        this.setLayout((Layout)new GridLayout(1, false));
        this.styledText = new StyledText((Composite)this, 2816);
        this.styledText.setEditable(true);
        this.styledText.setLayoutData((Object)new GridData(4, 4, false, false));
        this.styledText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent arg0) {
                TextScriptEditorComposite.this.setDirty(true);
            }
        });
    }

    public String getScriptRelativePath() {
        return this.relativeScriptPath;
    }

    public void setScriptPath(String relativeScriptPath) {
        this.relativeScriptPath = relativeScriptPath;
        if (relativeScriptPath != null) {
            try {
                this.styledText.setText(this.loadScript(relativeScriptPath));
            }
            catch (Exception exception) {
                this.styledText.setText(null);
            }
        } else {
            this.styledText.setText(null);
        }
        this.setDirty(false);
    }

    public boolean isDirty() {
        return this.isDirty;
    }

    private void setDirty(boolean isDirty) {
        this.isDirty = isDirty;
        this.fileDirtyChanged(isDirty);
    }

    protected void fileDirtyChanged(boolean isDirty) {
    }

    public void saveScript() throws Exception {
        IPath absolutePath = ResourcesPlugin.getWorkspace().getRoot().getLocation().append(this.relativeScriptPath);
        BufferedWriter out = new BufferedWriter(new FileWriter(absolutePath.toOSString()));
        out.write(this.styledText.getText());
        out.flush();
        out.close();
        this.setDirty(false);
    }

    private String loadScript(String relativeScriptPath) throws Exception {
        IPath absolutePath = ResourcesPlugin.getWorkspace().getRoot().getLocation().append(relativeScriptPath);
        BufferedReader in = new BufferedReader(new FileReader(absolutePath.toOSString()));
        String line = null;
        StringBuffer sb = new StringBuffer();
        while ((line = in.readLine()) != null) {
            sb.append(String.valueOf(line) + "\n");
        }
        in.close();
        return sb.toString();
    }
}

