/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.core.invocator.ui.composites;

import java.util.ArrayList;
import java.util.Date;
import org.eclipse.apogy.common.emf.ApogyCommonEMFFacade;
import org.eclipse.apogy.common.emf.ApogyCommonEMFPackage;
import org.eclipse.apogy.common.emf.ApogyCommonTransactionFacade;
import org.eclipse.apogy.common.emf.ui.ApogyCommonEMFUIFactory;
import org.eclipse.apogy.common.emf.ui.ECollectionCompositeSettings;
import org.eclipse.apogy.common.emf.ui.composites.AbstractEListComposite;
import org.eclipse.apogy.common.emf.ui.emfforms.wizards.EObjectWizard;
import org.eclipse.apogy.core.invocator.AbstractOperationCall;
import org.eclipse.apogy.core.invocator.ApogyCoreInvocatorFacade;
import org.eclipse.apogy.core.invocator.ApogyCoreInvocatorPackage;
import org.eclipse.apogy.core.invocator.Context;
import org.eclipse.apogy.core.invocator.OperationCallsList;
import org.eclipse.apogy.core.invocator.VariableFeatureReference;
import org.eclipse.apogy.core.invocator.ui.ApogyCoreInvocatorUIFacade;
import org.eclipse.apogy.core.invocator.ui.composites.ArgumentsListComposite;
import org.eclipse.core.databinding.UpdateValueStrategy;
import org.eclipse.core.databinding.conversion.IConverter;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.emf.databinding.EMFProperties;
import org.eclipse.emf.databinding.FeaturePath;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.jface.databinding.swt.ISWTObservableValue;
import org.eclipse.jface.databinding.swt.WidgetProperties;
import org.eclipse.jface.databinding.viewers.IViewerObservableValue;
import org.eclipse.jface.databinding.viewers.ViewerProperties;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.TreeViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OperationCallsListComposite
extends AbstractEListComposite<OperationCallsList, OperationCallsList, AbstractOperationCall> {
    private static final Logger Logger = LoggerFactory.getLogger(OperationCallsListComposite.class);
    private Text opsCallDescription;
    private ArgumentsListComposite argumentsListComposite;
    private static final int NAME_COL_MIN_WIDTH = 200;
    private static final int FEATURE_COL_MIN_WIDTH = 200;
    private static final int TYPE_COL_MIN_WIDTH = 100;
    private static final int COMMAND_COL_MIN_WIDTH = 200;

    public OperationCallsListComposite(Composite parent, int style, ECollectionCompositeSettings settings) {
        super(parent, style, null, (EStructuralFeature)ApogyCoreInvocatorPackage.Literals.OPERATION_CALL_CONTAINER__OPERATION_CALLS, settings);
    }

    protected void createButtons(Composite parent, int style) {
        this.createNewButton(parent, style);
        this.createDeleteButton(parent, style);
        this.createSeparator(parent, style);
        this.createUpButton(parent, style);
        this.createDownButton(parent, style);
        this.createSeparator(parent, style);
        this.createRunButton(parent, style);
    }

    protected void createColumns(TreeViewer viewer) {
        TreeViewerColumn nameColumn = new TreeViewerColumn(viewer, 0);
        nameColumn.getColumn().setData("TREE_COLUMN_MIN_WIDTH", (Object)200);
        nameColumn.getColumn().setText("Name");
        nameColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                return ((AbstractOperationCall)element).getName() == null ? "<unnamed>" : ((AbstractOperationCall)element).getName();
            }

            public Color getBackground(Object element) {
                if (element instanceof AbstractOperationCall) {
                    return OperationCallsListComposite.this.getBackgroundColor((AbstractOperationCall)element);
                }
                return null;
            }
        });
        TreeViewerColumn featureColumn = new TreeViewerColumn(viewer, 0);
        featureColumn.getColumn().setData("TREE_COLUMN_MIN_WIDTH", (Object)200);
        featureColumn.getColumn().setText("Feature");
        featureColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                String str = ApogyCoreInvocatorFacade.INSTANCE.getOperationCallString((AbstractOperationCall)element);
                return str.contains("#") ? str.substring(0, str.indexOf("#")) : str;
            }

            public String getToolTipText(Object element) {
                AbstractOperationCall operationCall = (AbstractOperationCall)element;
                String text = null;
                if (operationCall.getFeaturePath().getFeaturePath().length > 0) {
                    EClass eClass = ApogyCoreInvocatorFacade.INSTANCE.getInstanceClass((VariableFeatureReference)operationCall);
                    if (eClass != null) {
                        text = "Feature refers to type <" + eClass.getName() + ">";
                        String description = ApogyCommonEMFFacade.INSTANCE.getDocumentation((EModelElement)eClass);
                        if (description != null && description.length() > 0) {
                            text = String.valueOf(text) + " : " + description;
                        }
                    }
                } else {
                    text = "Variable named <" + operationCall.getVariable().getName() + ">";
                    if (operationCall.getVariable().getDescription() != null && operationCall.getVariable().getDescription().length() > 0) {
                        text = String.valueOf(text) + " : " + operationCall.getVariable().getDescription();
                    }
                }
                return text;
            }

            public Color getBackground(Object element) {
                if (element instanceof AbstractOperationCall) {
                    return OperationCallsListComposite.this.getBackgroundColor((AbstractOperationCall)element);
                }
                return null;
            }
        });
        TreeViewerColumn commandColumn = new TreeViewerColumn(viewer, 0);
        commandColumn.getColumn().setData("TREE_COLUMN_MIN_WIDTH", (Object)200);
        commandColumn.getColumn().setText("Command");
        commandColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                AbstractOperationCall operationCall = (AbstractOperationCall)element;
                return ApogyCoreInvocatorUIFacade.INSTANCE.asString(operationCall, false, false, false, true);
            }

            public String getToolTipText(Object element) {
                AbstractOperationCall operationCall = (AbstractOperationCall)element;
                String text = ApogyCommonEMFFacade.INSTANCE.getDocumentation((EModelElement)operationCall.getEOperation());
                return text;
            }

            public Color getBackground(Object element) {
                if (element instanceof AbstractOperationCall) {
                    return OperationCallsListComposite.this.getBackgroundColor((AbstractOperationCall)element);
                }
                return null;
            }
        });
        TreeViewerColumn returnColumn = new TreeViewerColumn(viewer, 0);
        returnColumn.getColumn().setData("TREE_COLUMN_MIN_WIDTH", (Object)100);
        returnColumn.getColumn().setText("Return Type");
        returnColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                AbstractOperationCall abstractOperationCall = (AbstractOperationCall)element;
                if (abstractOperationCall.getEOperation().getEType() != null) {
                    return abstractOperationCall.getEOperation().getEType().getInstanceClass().getSimpleName();
                }
                return "";
            }

            public String getToolTipText(Object element) {
                AbstractOperationCall operationCall = (AbstractOperationCall)element;
                if (operationCall.getEOperation().getEType() != null) {
                    return ApogyCommonEMFFacade.INSTANCE.getDocumentation((EModelElement)operationCall.getEOperation().getEType());
                }
                return null;
            }

            public Color getBackground(Object element) {
                if (element instanceof AbstractOperationCall) {
                    return OperationCallsListComposite.this.getBackgroundColor((AbstractOperationCall)element);
                }
                return null;
            }
        });
    }

    protected void doNew() {
        EObjectWizard wizard = new EObjectWizard((EObject)((OperationCallsList)this.getResolvedEObject()), this.getFeaturePath(), (EReference)this.getEStructuralFeature(), ApogyCoreInvocatorPackage.Literals.OPERATION_CALL, null);
        WizardDialog dialog = new WizardDialog(this.getShell(), (IWizard)wizard);
        dialog.open();
    }

    protected void createRunButtonBindings(Button button) {
        IObservableValue sessionStartDate = EMFProperties.value((FeaturePath)FeaturePath.fromList((EStructuralFeature[])new EStructuralFeature[]{ApogyCoreInvocatorPackage.Literals.APOGY_CORE_INVOCATOR_FACADE__ACTIVE_INVOCATOR_SESSION, ApogyCoreInvocatorPackage.Literals.INVOCATOR_SESSION__ENVIRONMENT, ApogyCoreInvocatorPackage.Literals.ENVIRONMENT__ACTIVE_CONTEXT, ApogyCoreInvocatorPackage.Literals.CONTEXT__INSTANCES_CREATION_DATE})).observe((Object)ApogyCoreInvocatorFacade.INSTANCE);
        IObservableValue sessionDisposeDate = EMFProperties.value((FeaturePath)FeaturePath.fromList((EStructuralFeature[])new EStructuralFeature[]{ApogyCoreInvocatorPackage.Literals.APOGY_CORE_INVOCATOR_FACADE__ACTIVE_INVOCATOR_SESSION, ApogyCoreInvocatorPackage.Literals.INVOCATOR_SESSION__ENVIRONMENT, ApogyCoreInvocatorPackage.Literals.ENVIRONMENT__ACTIVE_CONTEXT, ApogyCoreInvocatorPackage.Literals.CONTEXT__INSTANCES_DISPOSAL_DATE})).observe((Object)ApogyCoreInvocatorFacade.INSTANCE);
        IViewerObservableValue selectionObservableValue = ViewerProperties.singleSelection().observe((Viewer)this.getViewer());
        ArrayList<Object> valesToWatch = new ArrayList<Object>();
        valesToWatch.add(sessionStartDate);
        valesToWatch.add(sessionDisposeDate);
        valesToWatch.add(selectionObservableValue);
        ISWTObservableValue buttonEnabledObservableValue = WidgetProperties.enabled().observe((Widget)button);
        for (IObservableValue iObservableValue : valesToWatch) {
            this.getDataBindingContext().bindValue((IObservableValue)buttonEnabledObservableValue, iObservableValue, new UpdateValueStrategy(UpdateValueStrategy.POLICY_NEVER), new UpdateValueStrategy(UpdateValueStrategy.POLICY_UPDATE).setConverter(IConverter.create(Object.class, Boolean.class, o -> {
                if (o != null) {
                    Context activeContext = ApogyCoreInvocatorFacade.INSTANCE.getActiveInvocatorSession().getEnvironment().getActiveContext();
                    if (activeContext != null) {
                        Date startDate = activeContext.getInstancesCreationDate();
                        Date disposeDate = activeContext.getInstancesDisposalDate();
                        if (startDate != null && disposeDate == null) {
                            return true;
                        }
                        return false;
                    }
                    return false;
                }
                return false;
            })));
        }
    }

    protected void doRun() {
        final ArrayList operationCalls = new ArrayList();
        operationCalls.addAll(this.getSelectedItemObjects());
        Job job = new Job("Run"){

            protected IStatus run(IProgressMonitor monitor) {
                for (AbstractOperationCall opsCall : operationCalls) {
                    try {
                        ApogyCoreInvocatorFacade.INSTANCE.exec(opsCall);
                    }
                    catch (Throwable t) {
                        Logger.error("Failed to execute operation call <" + opsCall.getName() + ">!", t);
                    }
                }
                return Status.OK_STATUS;
            }
        };
        job.schedule();
    }

    protected Composite createDetailComposite(Composite parent, int style) {
        Composite top = new Composite(parent, style);
        top.setLayout((Layout)new GridLayout(2, false));
        Label descriptionLabel = new Label(top, 0);
        descriptionLabel.setText("Description:");
        GridData descriptionLabelGridData = new GridData(16384, 128, false, false);
        descriptionLabel.setLayoutData((Object)descriptionLabelGridData);
        this.opsCallDescription = new Text(top, 2);
        this.opsCallDescription.setEditable(true);
        GridData opsCallDescriptionGridData = new GridData(4, 4, true, true);
        this.opsCallDescription.setLayoutData((Object)opsCallDescriptionGridData);
        this.opsCallDescription.addKeyListener(new KeyListener(){

            public void keyReleased(KeyEvent e) {
                AbstractOperationCall operationCall;
                if (OperationCallsListComposite.this.getSelectedItemObjects().size() > 0 && (operationCall = (AbstractOperationCall)OperationCallsListComposite.this.getSelectedItemObjects().get(0)) != null) {
                    ApogyCommonTransactionFacade.INSTANCE.basicSet((EObject)operationCall, (EStructuralFeature)ApogyCommonEMFPackage.Literals.DESCRIBED__DESCRIPTION, (Object)OperationCallsListComposite.this.opsCallDescription.getText());
                }
            }

            public void keyPressed(KeyEvent e) {
            }
        });
        Label parametersLabel = new Label(top, 0);
        parametersLabel.setText("Parameters:");
        GridData parametersLabelGridData = new GridData(16384, 128, false, false);
        parametersLabel.setLayoutData((Object)parametersLabelGridData);
        ECollectionCompositeSettings settings = ApogyCommonEMFUIFactory.eINSTANCE.createECollectionCompositeSettings();
        settings.setButtonsSectionDisplayed(false);
        settings.setDetailSectionDisplayed(true);
        this.argumentsListComposite = new ArgumentsListComposite(top, 0, settings);
        GridData argumentsListCompositeGridData = new GridData(4, 4, true, true);
        this.argumentsListComposite.setLayoutData(argumentsListCompositeGridData);
        return top;
    }

    protected void selectionChanged(IStructuredSelection selection) {
        AbstractOperationCall operationCall;
        AbstractOperationCall abstractOperationCall = operationCall = this.getSelectedItemObjects() != null && !this.getSelectedItemObjects().isEmpty() ? (AbstractOperationCall)this.getSelectedItemObjects().get(0) : null;
        if (operationCall != null) {
            if (operationCall.getDescription() != null) {
                this.opsCallDescription.setText(operationCall.getDescription());
            } else {
                this.opsCallDescription.setText("N/A");
            }
        }
        if (this.argumentsListComposite != null && !this.argumentsListComposite.isDisposed()) {
            this.argumentsListComposite.setRootEObject((EObject)operationCall);
        }
    }

    protected Color getBackgroundColor(AbstractOperationCall abstractOperationCall) {
        return null;
    }
}

