/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.core.invocator.ui.composites;

import org.eclipse.apogy.common.converters.ApogyCommonConvertersFacade;
import org.eclipse.apogy.common.converters.IFileExporter;
import org.eclipse.apogy.common.converters.ui.wizards.ExportToFileWizard;
import org.eclipse.apogy.common.emf.Named;
import org.eclipse.apogy.common.emf.ui.composites.AbstractEObjectComposite;
import org.eclipse.apogy.common.emf.ui.emfforms.ApogyCommonEMFUiEMFFormsFacade;
import org.eclipse.apogy.core.invocator.AbstractResult;
import org.eclipse.apogy.core.invocator.AbstractResultValue;
import org.eclipse.apogy.core.invocator.AttributeResultValue;
import org.eclipse.apogy.core.invocator.ReferenceResultValue;
import org.eclipse.emf.databinding.FeaturePath;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;

public class AttributeResultValueComposite<RootEObject extends AbstractResult, ResolvedEObject extends AbstractResultValue>
extends AbstractEObjectComposite<RootEObject, ResolvedEObject, Object> {
    private Button exportButton;
    private Composite detailsComposite;

    public AttributeResultValueComposite(Composite parent, int style, FeaturePath featurePath, EStructuralFeature eStructuralFeature) {
        super(parent, style, featurePath, eStructuralFeature, null);
    }

    public Object getValue() {
        Object value = null;
        if (this.getRootEObject() != null) {
            AbstractResultValue abstractResultValue = ((AbstractResult)this.getRootEObject()).getResultValue();
            if (abstractResultValue instanceof AttributeResultValue) {
                AttributeResultValue attributeResultValue = (AttributeResultValue)abstractResultValue;
                if (attributeResultValue.getValue() != null) {
                    value = attributeResultValue.getValue().getObject();
                }
            } else if (abstractResultValue instanceof ReferenceResultValue) {
                ReferenceResultValue referenceResultValue = (ReferenceResultValue)abstractResultValue;
                value = referenceResultValue.getValue();
            }
        }
        return value;
    }

    protected Composite createContentComposite(Composite parent, int style) {
        try {
            Composite top = new Composite(parent, 0);
            top.setLayout((Layout)new GridLayout(1, false));
            Group valueGroup = new Group(top, 2048);
            valueGroup.setLayout((Layout)new GridLayout(1, false));
            valueGroup.setText("Value");
            valueGroup.setLayoutData((Object)new GridData(4, 4, true, true));
            this.exportButton = new Button((Composite)valueGroup, 8);
            this.exportButton.setText("Export Value...");
            this.exportButton.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent arg0) {
                    Object value = AttributeResultValueComposite.this.getValue();
                    String defaultFileName = null;
                    if (AttributeResultValueComposite.this.getRootEObject() instanceof Named) {
                        Named named = (Named)AttributeResultValueComposite.this.getRootEObject();
                        defaultFileName = named.getName();
                    }
                    IFileExporter iFileExporter = ApogyCommonConvertersFacade.INSTANCE.getIFileExporter(value);
                    ExportToFileWizard wizard = new ExportToFileWizard(iFileExporter, value, defaultFileName);
                    WizardDialog dialog = new WizardDialog(AttributeResultValueComposite.this.getShell(), (IWizard)wizard);
                    dialog.open();
                }

                public void widgetDefaultSelected(SelectionEvent arg0) {
                }
            });
            this.detailsComposite = new Composite((Composite)valueGroup, 2048);
            this.detailsComposite.setLayout((Layout)new GridLayout(1, false));
            this.detailsComposite.setLayoutData((Object)new GridData(4, 4, true, true));
            this.updateValue(this.getValue());
            return top;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public void setRootEObject(RootEObject rootEObject) {
        super.setRootEObject(rootEObject);
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                AttributeResultValueComposite.this.updateValue(AttributeResultValueComposite.this.getValue());
            }
        });
    }

    protected void rootEObjectChanged(RootEObject rootEObject) {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                AttributeResultValueComposite.this.updateValue(AttributeResultValueComposite.this.getValue());
            }
        });
    }

    private void updateValue(Object value) {
        if (this.exportButton != null && !this.exportButton.isDisposed()) {
            IFileExporter iFileExporter = ApogyCommonConvertersFacade.INSTANCE.getIFileExporter(value);
            this.exportButton.setEnabled(iFileExporter != null);
        }
        if (this.detailsComposite != null && !this.detailsComposite.isDisposed()) {
            if (value instanceof EObject) {
                ApogyCommonEMFUiEMFFormsFacade.INSTANCE.createEMFForms(this.detailsComposite, (EObject)value);
            } else if (value != null) {
                ApogyCommonEMFUiEMFFormsFacade.INSTANCE.createEMFForms(this.detailsComposite, null, value.toString());
            } else {
                ApogyCommonEMFUiEMFFormsFacade.INSTANCE.createEMFForms(this.detailsComposite, null);
            }
        }
    }
}

