/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.addons.vehicle.ui.jme3.scene_objects;

import com.jme3.asset.AssetManager;
import com.jme3.effect.ParticleEmitter;
import com.jme3.effect.ParticleMesh;
import com.jme3.material.Material;
import com.jme3.math.ColorRGBA;
import com.jme3.math.Vector3f;
import com.jme3.scene.Geometry;
import com.jme3.scene.Mesh;
import com.jme3.scene.Spatial;
import com.jme3.scene.VertexBuffer;
import com.jme3.util.BufferUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import org.eclipse.apogy.addons.vehicle.Thruster;
import org.eclipse.apogy.addons.vehicle.ui.ThrusterSceneObject;
import org.eclipse.apogy.common.topology.Node;
import org.eclipse.apogy.common.topology.ui.jme3.JME3RenderEngineDelegate;
import org.eclipse.apogy.common.topology.ui.jme3.JME3Utilities;
import org.eclipse.apogy.common.topology.ui.jme3.scene_objects.DefaultJME3SceneObject;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.swt.graphics.RGBA;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ThrusterJME3Object
extends DefaultJME3SceneObject<Thruster>
implements ThrusterSceneObject {
    private static final Logger Logger = LoggerFactory.getLogger(ThrusterJME3Object.class);
    private static final float FIRE_PARTICLE_SPEED = 30.0f;
    private static final float SMOKE_PARTICLE_SPEED = 10.0f;
    private static final int FIRE_PARTICLE_NUMBER = 3000;
    private static final int SMOKE_PARTICLE_NUMBER = 1500;
    private Adapter adapter;
    private final AssetManager assetManager;
    private Geometry plumeGeometry = null;
    private boolean plumeEnvelopeVisible = false;
    private double plumeEnvelopeLength = 1.0;
    private ColorRGBA plumeEnvelopeColor = ColorRGBA.White;
    private final ParticleEmitter fireEmitter;
    private final ParticleEmitter smokeEmitter;

    public ThrusterJME3Object(Thruster node, JME3RenderEngineDelegate jme3RenderEngineDelegate) {
        super((Node)node, jme3RenderEngineDelegate);
        this.assetManager = this.jme3Application.getAssetManager();
        this.plumeGeometry = this.createPlumeGeometry();
        this.fireEmitter = this.createFireEmitter((float)node.getPlumeAngle());
        this.getAttachmentNode().attachChild((Spatial)this.fireEmitter);
        this.smokeEmitter = this.createSmokeEmitter((float)node.getPlumeAngle());
        this.getAttachmentNode().attachChild((Spatial)this.smokeEmitter);
        this.updateExhaustPlume((float)((Thruster)this.getTopologyNode()).getThrustLevel(), (float)((Thruster)this.getTopologyNode()).getPlumeAngle());
        ((Thruster)this.getTopologyNode()).eAdapters().add((Object)this.getAdapter());
    }

    public void updateGeometry(float tpf) {
        if (this.plumeGeometry != null) {
            this.getAttachmentNode().detachChild((Spatial)this.plumeGeometry);
        }
        this.plumeGeometry = this.createPlumeGeometry();
        if (this.plumeEnvelopeVisible) {
            this.getAttachmentNode().attachChild((Spatial)this.plumeGeometry);
        }
        float thrust = (float)((Thruster)this.getTopologyNode()).getThrustLevel();
        float plumeAngle = (float)((Thruster)this.getTopologyNode()).getPlumeAngle();
        float velocityVariation = plumeAngle / ((float)Math.PI * 2);
        if (this.fireEmitter != null) {
            this.fireEmitter.setParticlesPerSec((float)this.fireEmitter.getMaxNumParticles() * thrust);
            this.fireEmitter.getParticleInfluencer().setVelocityVariation(velocityVariation);
        }
        if (this.smokeEmitter != null) {
            this.smokeEmitter.setParticlesPerSec((float)this.smokeEmitter.getMaxNumParticles() * thrust);
            this.smokeEmitter.getParticleInfluencer().setVelocityVariation(velocityVariation);
        }
    }

    public List<Geometry> getGeometries() {
        ArrayList<Geometry> geometries = new ArrayList<Geometry>();
        geometries.add(this.plumeGeometry);
        return geometries;
    }

    public void dispose() {
        if (this.getTopologyNode() != null) {
            ((Thruster)this.getTopologyNode()).eAdapters().remove((Object)this.getAdapter());
        }
        if (this.fireEmitter != null) {
            this.fireEmitter.killAllParticles();
        }
        if (this.smokeEmitter != null) {
            this.smokeEmitter.killAllParticles();
        }
        super.dispose();
    }

    public void setColor(RGBA rgb) {
        Logger.info("Setting Plume Envelope Color to <" + rgb + "> .");
        this.plumeEnvelopeColor = JME3Utilities.convertToColorRGBA((RGBA)rgb);
        this.jme3Application.enqueue((Callable)new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                if (ThrusterJME3Object.this.plumeGeometry != null) {
                    Material mat = ThrusterJME3Object.this.plumeGeometry.getMaterial();
                    mat.setColor("Diffuse", ThrusterJME3Object.this.plumeEnvelopeColor.clone());
                    mat.setColor("Ambient", ThrusterJME3Object.this.plumeEnvelopeColor.clone());
                    mat.setColor("Specular", ThrusterJME3Object.this.plumeEnvelopeColor.clone());
                }
                return null;
            }
        });
    }

    public void setPlumeEnvelopeVisible(boolean visible) {
        Logger.info("Setting Plume Visibility to <" + visible + ">.");
        this.plumeEnvelopeVisible = visible;
        this.jme3Application.enqueue((Callable)new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                if (ThrusterJME3Object.this.plumeEnvelopeVisible) {
                    if (ThrusterJME3Object.this.plumeGeometry == null) {
                        ThrusterJME3Object.this.plumeGeometry = ThrusterJME3Object.this.createPlumeGeometry();
                    }
                    if (!ThrusterJME3Object.this.getAttachmentNode().hasChild((Spatial)ThrusterJME3Object.this.plumeGeometry)) {
                        ThrusterJME3Object.this.getAttachmentNode().attachChild((Spatial)ThrusterJME3Object.this.plumeGeometry);
                    }
                } else if (ThrusterJME3Object.this.plumeGeometry != null) {
                    ThrusterJME3Object.this.getAttachmentNode().detachChild((Spatial)ThrusterJME3Object.this.plumeGeometry);
                }
                return null;
            }
        });
    }

    public void setPlumeEnvelopeLength(double length) {
        Logger.info("Setting Plume Length to <" + length + "> m.");
        this.plumeEnvelopeLength = length;
        this.jme3Application.enqueue((Callable)new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                if (ThrusterJME3Object.this.plumeGeometry != null) {
                    ThrusterJME3Object.this.getAttachmentNode().detachChild((Spatial)ThrusterJME3Object.this.plumeGeometry);
                }
                ThrusterJME3Object.this.plumeGeometry = ThrusterJME3Object.this.createPlumeGeometry();
                if (ThrusterJME3Object.this.plumeEnvelopeVisible) {
                    ThrusterJME3Object.this.getAttachmentNode().attachChild((Spatial)ThrusterJME3Object.this.plumeGeometry);
                }
                return null;
            }
        });
    }

    private Geometry createPlumeGeometry() {
        Geometry geometry = new Geometry("Plume Envelope", this.createPlumeMesh());
        geometry.setMaterial(this.createPlumeMaterial());
        return geometry;
    }

    private Mesh createPlumeMesh() {
        Mesh cone = this.createPlumeEnvelop((float)((Thruster)this.getTopologyNode()).getPlumeAngle(), (float)this.plumeEnvelopeLength, 32);
        return cone;
    }

    private Material createPlumeMaterial() {
        ColorRGBA color = this.plumeEnvelopeColor.clone();
        Material mat = new Material(this.assetManager, "Common/MatDefs/Light/Lighting.j3md");
        if (color != null) {
            mat.setColor("Diffuse", color);
            mat.setColor("Ambient", color);
            mat.setColor("Specular", color);
        }
        mat.setFloat("Shininess", 64.0f);
        mat.setBoolean("UseMaterialColors", true);
        return mat;
    }

    private ParticleEmitter createFireEmitter(float angle) {
        ParticleEmitter emit = new ParticleEmitter("ThrusterFireEmitter", ParticleMesh.Type.Triangle, 3000);
        emit.setGravity(0.0f, 0.0f, 0.0f);
        emit.getParticleInfluencer().setInitialVelocity(new Vector3f(0.0f, 0.0f, 30.0f));
        float velVariation = angle / ((float)Math.PI * 2);
        emit.getParticleInfluencer().setVelocityVariation(velVariation);
        emit.setLowLife(0.015f);
        emit.setHighLife(0.016f);
        emit.setStartSize(0.1f);
        emit.setEndSize(0.01f);
        emit.setEndColor(new ColorRGBA(1.0f, 0.0f, 0.0f, 1.0f));
        emit.setStartColor(new ColorRGBA(1.0f, 1.0f, 0.0f, 0.0f));
        emit.setImagesX(15);
        Material mat = new Material(this.assetManager, "Common/MatDefs/Misc/Particle.j3md");
        mat.setTexture("Texture", this.assetManager.loadTexture("Effects/Smoke/Smoke.png"));
        emit.setMaterial(mat);
        emit.setParticlesPerSec(0.0f);
        return emit;
    }

    private ParticleEmitter createSmokeEmitter(float angle) {
        ParticleEmitter emit = new ParticleEmitter("ThrusterSmokeEmitter", ParticleMesh.Type.Triangle, 1500);
        emit.setGravity(0.0f, 0.0f, 0.0f);
        emit.getParticleInfluencer().setInitialVelocity(new Vector3f(0.0f, 0.0f, 10.0f));
        float velVariation = angle / ((float)Math.PI * 2);
        emit.getParticleInfluencer().setVelocityVariation(velVariation);
        emit.setLowLife(0.1f);
        emit.setHighLife(0.5f);
        emit.setStartSize(0.05f);
        emit.setEndSize(0.5f);
        emit.setStartColor(new ColorRGBA(0.588f, 0.2f, 0.0f, 0.3f));
        emit.setEndColor(new ColorRGBA(0.5f, 0.5f, 0.5f, 0.1f));
        emit.setImagesX(15);
        Material mat = new Material(this.assetManager, "Common/MatDefs/Misc/Particle.j3md");
        mat.setTexture("Texture", this.assetManager.loadTexture("Effects/Smoke/Smoke.png"));
        emit.setMaterial(mat);
        emit.setParticlesPerSec(0.0f);
        return emit;
    }

    private Mesh createPlumeEnvelop(float apexAngle, float maxRadius, int numberOfFaces) {
        Mesh mesh = null;
        ArrayList<Vector3f> verticesList = new ArrayList<Vector3f>();
        ArrayList<Integer> indexesList = new ArrayList<Integer>();
        ArrayList<Vector3f> normalslList = new ArrayList<Vector3f>();
        if (apexAngle != 0.0f) {
            int verticeIndex = 0;
            double angle = 0.0;
            double angleIncrement = Math.toRadians(360.0) / (double)numberOfFaces;
            float x0 = 0.0f;
            float y0 = 0.0f;
            float z0 = 0.0f;
            float x1 = 0.0f;
            float y1 = 0.0f;
            float z1 = 0.0f;
            int i = 0;
            while (i < numberOfFaces) {
                float rXY = (float)((double)maxRadius * Math.tan(apexAngle / 2.0f));
                x0 = (float)((double)rXY * Math.cos(angle));
                y0 = (float)((double)rXY * Math.sin(angle));
                x1 = (float)((double)rXY * Math.cos(angle + angleIncrement));
                y1 = (float)((double)rXY * Math.sin(angle + angleIncrement));
                z0 = maxRadius;
                z1 = maxRadius;
                Vector3f origin = new Vector3f();
                Vector3f p0 = new Vector3f(x0, y0, z0);
                Vector3f p1 = new Vector3f(x1, y1, z1);
                verticesList.add(origin);
                indexesList.add(new Integer(verticeIndex));
                verticesList.add(p1);
                indexesList.add(new Integer(++verticeIndex));
                verticesList.add(p0);
                indexesList.add(new Integer(++verticeIndex));
                ++verticeIndex;
                Vector3f normal1 = JME3Utilities.computeTriangleNormal((Vector3f)origin, (Vector3f)p1, (Vector3f)p0);
                normalslList.add(normal1);
                normalslList.add(normal1);
                normalslList.add(normal1);
                angle += angleIncrement;
                ++i;
            }
        } else {
            verticesList.add(new Vector3f(0.0f, 0.0f, 0.0f));
            verticesList.add(new Vector3f(0.0f, 0.0f, maxRadius));
            indexesList.add(new Integer(0));
            indexesList.add(new Integer(1));
            indexesList.add(new Integer(0));
            normalslList.add(new Vector3f(0.0f, 0.0f, 1.0f));
        }
        mesh = new Mesh();
        mesh.setBuffer(VertexBuffer.Type.Position, 3, BufferUtils.createFloatBuffer((float[])JME3Utilities.convertToFloatArray(verticesList)));
        mesh.setBuffer(VertexBuffer.Type.Index, 3, BufferUtils.createIntBuffer((int[])JME3Utilities.convertToIntArray(indexesList)));
        mesh.setBuffer(VertexBuffer.Type.Normal, 3, BufferUtils.createFloatBuffer((float[])JME3Utilities.convertToFloatArray(normalslList)));
        mesh.updateBound();
        return mesh;
    }

    private void updateExhaustPlume(final float thrust, final float plumeAngle) {
        this.jme3Application.enqueue((Callable)new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                float velocityVariation = plumeAngle / ((float)Math.PI * 2);
                if (ThrusterJME3Object.this.fireEmitter != null) {
                    ThrusterJME3Object.this.fireEmitter.setParticlesPerSec((float)ThrusterJME3Object.this.fireEmitter.getMaxNumParticles() * thrust);
                    ThrusterJME3Object.this.fireEmitter.getParticleInfluencer().setVelocityVariation(velocityVariation);
                }
                if (ThrusterJME3Object.this.smokeEmitter != null) {
                    ThrusterJME3Object.this.smokeEmitter.setParticlesPerSec((float)ThrusterJME3Object.this.smokeEmitter.getMaxNumParticles() * thrust);
                    ThrusterJME3Object.this.smokeEmitter.getParticleInfluencer().setVelocityVariation(velocityVariation);
                }
                return null;
            }
        });
    }

    private Adapter getAdapter() {
        if (this.adapter == null) {
            this.adapter = new AdapterImpl(){

                public void notifyChanged(Notification msg) {
                    if (msg.getNotifier() instanceof Thruster) {
                        int featureId = msg.getFeatureID(Thruster.class);
                        switch (featureId) {
                            case 8: {
                                ThrusterJME3Object.this.requestUpdate();
                                break;
                            }
                            case 7: {
                                ThrusterJME3Object.this.requestUpdate();
                                break;
                            }
                        }
                    }
                }
            };
        }
        return this.adapter;
    }
}

