/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.addons.geometry.paths.impl;

import java.util.Collection;
import javax.vecmath.Point3d;
import org.eclipse.apogy.addons.geometry.paths.ApogyAddonsGeometryPathsFactory;
import org.eclipse.apogy.addons.geometry.paths.SegmentWayPointPathInterpolator;
import org.eclipse.apogy.addons.geometry.paths.WayPointPath;
import org.eclipse.apogy.addons.geometry.paths.impl.UniformDistanceWayPointPathInterpolatorImpl;
import org.eclipse.apogy.common.geometry.data3d.ApogyCommonGeometryData3DFacade;
import org.eclipse.apogy.common.geometry.data3d.CartesianPositionCoordinates;
import org.eclipse.core.runtime.IProgressMonitor;

public class UniformDistanceWayPointPathInterpolatorCustomImpl
extends UniformDistanceWayPointPathInterpolatorImpl {
    private double getHighResolutionMaximumDistanceInterval() {
        return this.getDistanceInterval() * 0.01;
    }

    private WayPointPath getHighResolutionWayPointPath(WayPointPath path) throws Exception {
        SegmentWayPointPathInterpolator interpolator = ApogyAddonsGeometryPathsFactory.eINSTANCE.createSegmentWayPointPathInterpolator();
        interpolator.setMaximumDistanceInterval(this.getHighResolutionMaximumDistanceInterval());
        return (WayPointPath)interpolator.process(path);
    }

    private double computeAverage(double[] values, int startIndex, int endIndex) {
        double average = 0.0;
        int i = startIndex;
        while (i < endIndex) {
            average += values[i];
            ++i;
        }
        return average /= (double)(endIndex - startIndex);
    }

    private WayPointPath filterPath(WayPointPath path) throws Exception {
        WayPointPath result = ApogyAddonsGeometryPathsFactory.eINSTANCE.createWayPointPath();
        int n = Math.round((float)Math.ceil(this.getDistanceInterval() / this.getHighResolutionMaximumDistanceInterval()));
        int nlPath = (int)Math.round((double)((float)path.getLength()) / this.getDistanceInterval());
        double[][] slopes = new double[3][path.getPoints().size()];
        int i = 1;
        while (i < path.getPoints().size()) {
            Point3d p0 = ((CartesianPositionCoordinates)path.getPoints().get(i - 1)).asPoint3d();
            Point3d p1 = ((CartesianPositionCoordinates)path.getPoints().get(i)).asPoint3d();
            slopes[0][i] = p1.x - p0.x;
            slopes[1][i] = p1.y - p0.y;
            slopes[2][i] = p1.z - p0.z;
            ++i;
        }
        result.getPoints().add((Object)ApogyCommonGeometryData3DFacade.INSTANCE.createCartesianPositionCoordinates((CartesianPositionCoordinates)path.getPoints().get(0)));
        int ihpath = 0;
        int j = 1;
        while (j < nlPath) {
            double ux = this.computeAverage(slopes[0], ihpath, ihpath + n);
            double uy = this.computeAverage(slopes[1], ihpath, ihpath + n);
            double uz = this.computeAverage(slopes[2], ihpath, ihpath + n);
            double norm = Math.sqrt(ux * ux + uy * uy + uz * uz);
            ihpath += n;
            Point3d lastPoint = result.getEndPoint().asPoint3d();
            CartesianPositionCoordinates newPoint = ApogyCommonGeometryData3DFacade.INSTANCE.createCartesianPositionCoordinates(lastPoint.x + (ux /= norm) * this.getDistanceInterval(), lastPoint.y + (uy /= norm) * this.getDistanceInterval(), lastPoint.z + (uz /= norm) * this.getDistanceInterval());
            result.getPoints().add((Object)newPoint);
            ++j;
        }
        if (result.getEndPoint().asPoint3d().distance(path.getEndPoint().asPoint3d()) <= this.getDistanceInterval()) {
            result.getEndPoint().setX(path.getEndPoint().getX());
            result.getEndPoint().setY(path.getEndPoint().getY());
            result.getEndPoint().setZ(path.getEndPoint().getZ());
        } else {
            result.getPoints().add((Object)ApogyCommonGeometryData3DFacade.INSTANCE.createCartesianPositionCoordinates(path.getEndPoint()));
        }
        return result;
    }

    public WayPointPath doProcess(WayPointPath input, IProgressMonitor monitor) throws Exception {
        this.setInput(input);
        monitor.beginTask("Interpolating WayPointPath.", 2);
        WayPointPath result = ApogyAddonsGeometryPathsFactory.eINSTANCE.createWayPointPath();
        this.setOutput(result);
        WayPointPath highResolutionPath = this.getHighResolutionWayPointPath(input);
        monitor.worked(1);
        result.getPoints().addAll((Collection)this.filterPath(highResolutionPath).getPoints());
        monitor.worked(1);
        monitor.done();
        return result;
    }
}

