/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.common.math.quickhull3d;

import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;
import org.eclipse.apogy.common.math.quickhull3d.Face;
import org.eclipse.apogy.common.math.quickhull3d.Vertex;

class HalfEdge {
    Vertex vertex;
    Face face;
    HalfEdge next;
    HalfEdge prev;
    HalfEdge opposite;

    public HalfEdge(Vertex v, Face f) {
        this.vertex = v;
        this.face = f;
    }

    public HalfEdge() {
    }

    public void setNext(HalfEdge edge) {
        this.next = edge;
    }

    public HalfEdge getNext() {
        return this.next;
    }

    public void setPrev(HalfEdge edge) {
        this.prev = edge;
    }

    public HalfEdge getPrev() {
        return this.prev;
    }

    public Face getFace() {
        return this.face;
    }

    public HalfEdge getOpposite() {
        return this.opposite;
    }

    public void setOpposite(HalfEdge edge) {
        this.opposite = edge;
        edge.opposite = this;
    }

    public Vertex head() {
        return this.vertex;
    }

    public Vertex tail() {
        return this.prev != null ? this.prev.vertex : null;
    }

    public Face oppositeFace() {
        return this.opposite != null ? this.opposite.face : null;
    }

    public String getVertexString() {
        if (this.tail() != null) {
            return this.tail().index + "-" + this.head().index;
        }
        return "?-" + this.head().index;
    }

    public double length() {
        if (this.tail() != null) {
            Vector3d v0 = new Vector3d(this.tail().pnt);
            Vector3d v1 = new Vector3d(this.head().pnt);
            v1.sub((Tuple3d)v0);
            return v1.length();
        }
        return -1.0;
    }

    public double lengthSquared() {
        if (this.tail() != null) {
            Vector3d v0 = new Vector3d(this.tail().pnt);
            Vector3d v1 = new Vector3d(this.head().pnt);
            v1.sub((Tuple3d)v0);
            return v1.lengthSquared();
        }
        return -1.0;
    }
}

