/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.common.geometry.data3d.ui.commands;

import org.eclipse.apogy.common.geometry.data3d.CartesianCoordinatesSet;
import org.eclipse.apogy.common.geometry.data3d.Data3DIO;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.IHandler;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.handlers.HandlerUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SaveCartesianCoordinatesSetToFileCommandHandler
extends AbstractHandler
implements IHandler {
    private static final Logger Logger = LoggerFactory.getLogger(SaveCartesianCoordinatesSetToFileCommandHandler.class);
    protected static String currentDir = System.getProperty("user.dir");

    public Object execute(ExecutionEvent event) throws ExecutionException {
        for (Object selection : (IStructuredSelection)HandlerUtil.getActiveMenuSelection((ExecutionEvent)event)) {
            if (!(selection instanceof CartesianCoordinatesSet)) continue;
            CartesianCoordinatesSet coordinatesSet = (CartesianCoordinatesSet)selection;
            IWorkbench wb = PlatformUI.getWorkbench();
            Shell shell = wb.getActiveWorkbenchWindow().getShell();
            this.saveToFile(shell, coordinatesSet);
        }
        return null;
    }

    protected void saveToFile(Shell shell, CartesianCoordinatesSet coordinatesSet) {
        FileDialog fileChooser = new FileDialog(shell, 8192);
        fileChooser.setText("Save Coordinates Set (" + coordinatesSet.getPoints().size() + " points) to file");
        fileChooser.setFilterPath(currentDir);
        fileChooser.setFilterExtensions(new String[]{"*.xyz;*.csv;"});
        String filename = fileChooser.open();
        if (filename != null) {
            try {
                if (filename.endsWith(".xyz")) {
                    this.saveAsXYZ(coordinatesSet, filename);
                } else if (filename.endsWith(".csv")) {
                    this.saveAsCSV(coordinatesSet, filename);
                } else {
                    String fileExtension = "";
                    if (filename.lastIndexOf(".") > 0) {
                        fileExtension = filename.substring(filename.lastIndexOf("."));
                    }
                    String message = "Failed to save the coordinates. The specified file extension <" + fileExtension + "> is not supported.";
                    Logger.error(message);
                    MessageBox messageBox = new MessageBox(shell, 33);
                    messageBox.setMessage(message);
                    messageBox.open();
                }
            }
            catch (Exception e) {
                Logger.error(e.getMessage(), (Throwable)e);
            }
            currentDir = fileChooser.getFilterPath();
        }
    }

    protected void saveAsXYZ(CartesianCoordinatesSet coordinatesSet, String fileName) {
        Logger.info("Saving coordinates to file <" + fileName + ">.");
        try {
            Data3DIO.INSTANCE.saveCoordinatesSetToXYZ(coordinatesSet, fileName);
            Logger.info("Saved coordinates to file <" + fileName + ">.");
        }
        catch (Throwable t) {
            Logger.error("Failed to save coordinates to file <" + fileName + ">.", t);
        }
    }

    protected void saveAsCSV(CartesianCoordinatesSet coordinatesSet, String fileName) {
        Logger.info("Saving coordinates to file <" + fileName + ">.");
        try {
            Data3DIO.INSTANCE.saveCoordinatesSetToCSV(coordinatesSet, fileName);
            Logger.info("Saved coordinates to file <" + fileName + ">.");
        }
        catch (Throwable t) {
            Logger.error("Failed to save coordinates to file <" + fileName + ">.", t);
        }
    }
}

