/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.core.converters;

import java.io.File;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import javax.vecmath.Tuple3d;
import org.eclipse.apogy.common.converters.FileExporterUtilities;
import org.eclipse.apogy.common.math.ApogyCommonMathFacade;
import org.eclipse.apogy.core.OperationCallPositionedResult;
import org.eclipse.apogy.core.invocator.OperationCallResult;
import org.eclipse.apogy.core.invocator.converters.OperationCallResultFileExporter;

public class OperationCallPositionedResultFileExporter
extends OperationCallResultFileExporter {
    public Class<?> getOutputType() {
        return File.class;
    }

    public Class<?> getInputType() {
        return OperationCallPositionedResult.class;
    }

    public boolean canConvert(Object input) {
        return input instanceof OperationCallPositionedResult;
    }

    public void exportToFile(Object input, String filePath, List<String> extensions) throws Exception {
        OperationCallResult operationCallResult = (OperationCallResult)input;
        for (String extension : extensions) {
            String fullPathString = String.valueOf(filePath) + "." + extension;
            if (!extension.equalsIgnoreCase("metadata")) continue;
            FileExporterUtilities.saveMetaDataToFile((String)fullPathString, (String)this.getMetaData(operationCallResult));
        }
    }

    public List<String> getSupportedFileExtensions() {
        ArrayList<String> extensions = new ArrayList<String>();
        extensions.add("metadata");
        return extensions;
    }

    public String getDescription(String fileExtension) {
        if (fileExtension.contains("metadata")) {
            return "The OperationCallResult metadata (Description, Variable, Operation Call, Parameters, time stamp, Pose).";
        }
        return null;
    }

    public String getMetaData(Object input) {
        if (input instanceof OperationCallResult) {
            return this.getMetaData((OperationCallResult)input);
        }
        return null;
    }

    public String getMetaData(OperationCallPositionedResult operationCallResult) {
        Tuple3d orientation;
        Tuple3d position;
        String metadata = super.getMetaData((OperationCallResult)operationCallResult);
        DecimalFormat positionFormat = new DecimalFormat("0.000");
        DecimalFormat orientationFormat = new DecimalFormat("0.000");
        if (operationCallResult.getPose() != null) {
            position = ApogyCommonMathFacade.INSTANCE.extractPosition(operationCallResult.getPose()).asTuple3d();
            metadata = String.valueOf(metadata) + "Absolute Position (m) = (" + positionFormat.format(position.x) + ", " + positionFormat.format(position.y) + ", " + positionFormat.format(position.z) + ")";
            orientation = ApogyCommonMathFacade.INSTANCE.extractOrientation(operationCallResult.getPose()).asTuple3d();
            metadata = String.valueOf(metadata) + "Absolute Orientation (deg) = (" + orientationFormat.format(Math.toDegrees(orientation.x)) + ", " + orientationFormat.format(Math.toDegrees(orientation.y)) + ", " + orientationFormat.format(Math.toDegrees(orientation.z)) + ")";
        }
        if (operationCallResult.getRelativePose() != null) {
            position = ApogyCommonMathFacade.INSTANCE.extractPosition(operationCallResult.getRelativePose()).asTuple3d();
            metadata = String.valueOf(metadata) + "Relative Position (m) = (" + positionFormat.format(position.x) + ", " + positionFormat.format(position.y) + ", " + positionFormat.format(position.z) + ")";
            orientation = ApogyCommonMathFacade.INSTANCE.extractOrientation(operationCallResult.getRelativePose()).asTuple3d();
            metadata = String.valueOf(metadata) + "Relative Orientation (deg) = (" + orientationFormat.format(Math.toDegrees(orientation.x)) + ", " + orientationFormat.format(Math.toDegrees(orientation.y)) + ", " + orientationFormat.format(Math.toDegrees(orientation.z)) + ")";
        }
        return metadata;
    }
}

