/*
 * Decompiled with CFR 0.152.
 */
package org.ros.rosjava_geometry;

import com.google.common.collect.Lists;
import geometry_msgs.Point;
import java.util.ArrayList;
import java.util.Iterator;

public class Vector3 {
    private static final Vector3 ZERO = new Vector3(0.0, 0.0, 0.0);
    private static final Vector3 X_AXIS = new Vector3(1.0, 0.0, 0.0);
    private static final Vector3 Y_AXIS = new Vector3(0.0, 1.0, 0.0);
    private static final Vector3 Z_AXIS = new Vector3(0.0, 0.0, 1.0);
    private final double x;
    private final double y;
    private final double z;

    public static Vector3 fromVector3Message(geometry_msgs.Vector3 message) {
        return new Vector3(message.getX(), message.getY(), message.getZ());
    }

    public static Vector3 fromPointMessage(Point message) {
        return new Vector3(message.getX(), message.getY(), message.getZ());
    }

    public static Vector3 zero() {
        return ZERO;
    }

    public static Vector3 xAxis() {
        return X_AXIS;
    }

    public static Vector3 yAxis() {
        return Y_AXIS;
    }

    public static Vector3 zAxis() {
        return Z_AXIS;
    }

    public Vector3(double x, double y, double z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public Vector3 add(Vector3 other) {
        return new Vector3(this.x + other.x, this.y + other.y, this.z + other.z);
    }

    public Vector3 subtract(Vector3 other) {
        return new Vector3(this.x - other.x, this.y - other.y, this.z - other.z);
    }

    public Vector3 invert() {
        return new Vector3(-this.x, -this.y, -this.z);
    }

    public double dotProduct(Vector3 other) {
        return this.x * other.x + this.y * other.y + this.z * other.z;
    }

    public Vector3 normalize() {
        return new Vector3(this.x / this.getMagnitude(), this.y / this.getMagnitude(), this.z / this.getMagnitude());
    }

    public Vector3 scale(double factor) {
        return new Vector3(this.x * factor, this.y * factor, this.z * factor);
    }

    public double getX() {
        return this.x;
    }

    public double getY() {
        return this.y;
    }

    public double getZ() {
        return this.z;
    }

    public double getMagnitudeSquared() {
        return this.x * this.x + this.y * this.y + this.z * this.z;
    }

    public double getMagnitude() {
        return Math.sqrt(this.getMagnitudeSquared());
    }

    public geometry_msgs.Vector3 toVector3Message(geometry_msgs.Vector3 result) {
        result.setX(this.x);
        result.setY(this.y);
        result.setZ(this.z);
        return result;
    }

    public Point toPointMessage(Point result) {
        result.setX(this.x);
        result.setY(this.y);
        result.setZ(this.z);
        return result;
    }

    public boolean almostEquals(Vector3 other, double epsilon) {
        ArrayList epsilons = Lists.newArrayList();
        epsilons.add(this.x - other.x);
        epsilons.add(this.y - other.y);
        epsilons.add(this.z - other.z);
        Iterator iterator = epsilons.iterator();
        while (iterator.hasNext()) {
            double e = (Double)iterator.next();
            if (!(Math.abs(e) > epsilon)) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        return String.format("Vector3<x: %.4f, y: %.4f, z: %.4f>", this.x, this.y, this.z);
    }

    public int hashCode() {
        double x = this.x == 0.0 ? 0.0 : this.x;
        double y = this.y == 0.0 ? 0.0 : this.y;
        double z = this.z == 0.0 ? 0.0 : this.z;
        int prime = 31;
        int result = 1;
        long temp = Double.doubleToLongBits(x);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(y);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(z);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        return result;
    }

    public boolean equals(Object obj) {
        double otherZ;
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Vector3 other = (Vector3)obj;
        double x = this.x == 0.0 ? 0.0 : this.x;
        double y = this.y == 0.0 ? 0.0 : this.y;
        double z = this.z == 0.0 ? 0.0 : this.z;
        double otherX = other.x == 0.0 ? 0.0 : other.x;
        double otherY = other.y == 0.0 ? 0.0 : other.y;
        double d = otherZ = other.z == 0.0 ? 0.0 : other.z;
        if (Double.doubleToLongBits(x) != Double.doubleToLongBits(otherX)) {
            return false;
        }
        if (Double.doubleToLongBits(y) != Double.doubleToLongBits(otherY)) {
            return false;
        }
        return Double.doubleToLongBits(z) == Double.doubleToLongBits(otherZ);
    }
}

