/*
 * Decompiled with CFR 0.152.
 */
package org.ros.rosjava_geometry;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import geometry_msgs.TransformStamped;
import java.util.Map;
import org.ros.concurrent.CircularBlockingDeque;
import org.ros.message.Time;
import org.ros.namespace.GraphName;
import org.ros.rosjava_geometry.FrameTransform;
import org.ros.rosjava_geometry.LazyFrameTransform;
import org.ros.rosjava_geometry.Transform;

public class FrameTransformTree {
    private static final int TRANSFORM_QUEUE_CAPACITY = 16;
    private final Object mutex = new Object();
    private final Map<GraphName, CircularBlockingDeque<LazyFrameTransform>> transforms = Maps.newConcurrentMap();

    public void update(TransformStamped transformStamped) {
        Preconditions.checkNotNull((Object)transformStamped);
        GraphName source = GraphName.of((String)transformStamped.getChildFrameId());
        LazyFrameTransform lazyFrameTransform = new LazyFrameTransform(transformStamped);
        this.add(source, lazyFrameTransform);
    }

    @VisibleForTesting
    void update(FrameTransform frameTransform) {
        Preconditions.checkNotNull((Object)frameTransform);
        GraphName source = frameTransform.getSourceFrame();
        LazyFrameTransform lazyFrameTransform = new LazyFrameTransform(frameTransform);
        this.add(source, lazyFrameTransform);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void add(GraphName source, LazyFrameTransform lazyFrameTransform) {
        GraphName relativeSource = source.toRelative();
        if (!this.transforms.containsKey(relativeSource)) {
            this.transforms.put(relativeSource, (CircularBlockingDeque<LazyFrameTransform>)new CircularBlockingDeque(16));
        }
        Object object = this.mutex;
        synchronized (object) {
            this.transforms.get(relativeSource).addFirst((Object)lazyFrameTransform);
        }
    }

    public FrameTransform lookUp(GraphName source) {
        Preconditions.checkNotNull((Object)source);
        return this.getLatest(source.toRelative());
    }

    private FrameTransform getLatest(GraphName source) {
        CircularBlockingDeque<LazyFrameTransform> deque = this.transforms.get(source);
        if (deque == null) {
            return null;
        }
        LazyFrameTransform lazyFrameTransform = (LazyFrameTransform)deque.peekFirst();
        if (lazyFrameTransform == null) {
            return null;
        }
        return lazyFrameTransform.get();
    }

    public FrameTransform get(String source) {
        Preconditions.checkNotNull((Object)source);
        return this.lookUp(GraphName.of((String)source));
    }

    public FrameTransform lookUp(GraphName source, Time time) {
        Preconditions.checkNotNull((Object)source);
        Preconditions.checkNotNull((Object)time);
        return this.get(source, time);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private FrameTransform get(GraphName source, Time time) {
        CircularBlockingDeque<LazyFrameTransform> deque = this.transforms.get(source);
        if (deque == null) {
            return null;
        }
        LazyFrameTransform result = null;
        Object object = this.mutex;
        synchronized (object) {
            long offset = 0L;
            for (LazyFrameTransform lazyFrameTransform : deque) {
                if (result == null) {
                    result = lazyFrameTransform;
                    offset = Math.abs(time.subtract(result.get().getTime()).totalNsecs());
                    continue;
                }
                long newOffset = Math.abs(time.subtract(lazyFrameTransform.get().getTime()).totalNsecs());
                if (newOffset >= offset) continue;
                result = lazyFrameTransform;
                offset = newOffset;
            }
        }
        if (result == null) {
            return null;
        }
        return result.get();
    }

    public FrameTransform get(String source, Time time) {
        Preconditions.checkNotNull((Object)source);
        return this.lookUp(GraphName.of((String)source), time);
    }

    public FrameTransform transform(GraphName source, GraphName target) {
        Preconditions.checkNotNull((Object)source);
        Preconditions.checkNotNull((Object)target);
        GraphName relativeSource = source.toRelative();
        GraphName relativeTarget = target.toRelative();
        if (relativeSource.equals((Object)relativeTarget)) {
            return new FrameTransform(Transform.identity(), relativeSource, relativeTarget, null);
        }
        FrameTransform sourceToRoot = this.transformToRoot(relativeSource);
        FrameTransform targetToRoot = this.transformToRoot(relativeTarget);
        if (sourceToRoot == null && targetToRoot == null) {
            return null;
        }
        if (sourceToRoot == null) {
            if (targetToRoot.getTargetFrame().equals((Object)relativeSource)) {
                return targetToRoot.invert();
            }
            return null;
        }
        if (targetToRoot == null) {
            if (sourceToRoot.getTargetFrame().equals((Object)relativeTarget)) {
                return sourceToRoot;
            }
            return null;
        }
        if (sourceToRoot.getTargetFrame().equals((Object)targetToRoot.getTargetFrame())) {
            Transform transform = targetToRoot.getTransform().invert().multiply(sourceToRoot.getTransform());
            return new FrameTransform(transform, relativeSource, relativeTarget, sourceToRoot.getTime());
        }
        return null;
    }

    public FrameTransform transform(String source, String target) {
        Preconditions.checkNotNull((Object)source);
        Preconditions.checkNotNull((Object)target);
        return this.transform(GraphName.of((String)source), GraphName.of((String)target));
    }

    @VisibleForTesting
    FrameTransform transformToRoot(GraphName source) {
        FrameTransform result = this.getLatest(source);
        if (result == null) {
            return null;
        }
        FrameTransform resultToParent;
        while ((resultToParent = this.lookUp(result.getTargetFrame(), result.getTime())) != null) {
            Transform transform = resultToParent.getTransform().multiply(result.getTransform());
            GraphName target = resultToParent.getTargetFrame();
            result = new FrameTransform(transform, source, target, result.getTime());
        }
        return result;
    }
}

