/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.examples.robotic_arm.impl;

import org.eclipse.apogy.examples.robotic_arm.ApogyExamplesRoboticArmFacade;
import org.eclipse.apogy.examples.robotic_arm.MoveSpeedLevel;
import org.eclipse.apogy.examples.robotic_arm.impl.RoboticArmStubImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RoboticArmStubCustomImpl
extends RoboticArmStubImpl {
    private static final Logger Logger = LoggerFactory.getLogger(RoboticArmStubImpl.class);
    private static final String DEGREE_SYM = "\u00b0";

    @Override
    public boolean init() {
        Logger.info("Just a stub: The necessary initialization for the arm would have taken place.");
        ApogyExamplesRoboticArmFacade.INSTANCE.setActiveRoboticArm(this);
        this.setInitialized(true);
        return true;
    }

    @Override
    public void cmdMoveSpeedLevel(MoveSpeedLevel speedLevel) {
        Logger.info("Set speed level to <" + speedLevel.getLiteral() + ">.");
        this.setSpeed(speedLevel);
    }

    @Override
    public void moveTo(double turretAngle, double shoulderAngle, double elbowAngle, double wristAngle) {
        Logger.info("moveTo(" + Math.toDegrees(turretAngle) + DEGREE_SYM + ", " + Math.toDegrees(shoulderAngle) + DEGREE_SYM + ", " + Math.toDegrees(elbowAngle) + DEGREE_SYM + ", " + Math.toDegrees(wristAngle) + DEGREE_SYM + ").");
        this.setTurretAngle(Math.toDegrees(turretAngle));
        this.setShoulderAngle(Math.toDegrees(shoulderAngle));
        this.setElbowAngle(Math.toDegrees(elbowAngle));
        this.setWristAngle(Math.toDegrees(wristAngle));
    }

    @Override
    public void stow() {
        Logger.info("The robotic arm would have moved to the stow joint configuration.");
        this.setTurretAngle(0.0);
        this.setShoulderAngle(90.0);
        this.setElbowAngle(-180.0);
        this.setWristAngle(0.0);
    }
}

